/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.TrainingModel;
import chemaxon.calculations.training.logp.LogPUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class AtomicContributionBasedTrainingModel
implements TrainingModel<Molecule> {
    public static final int ionicIncIndex = 0;
    protected int[][] cHtab;
    protected int[][] bHtab;
    protected MolAtom[] atomArray;
    protected int hybridState;
    protected int actualAtom;
    protected int fragmentId;
    protected Molecule mol;
    protected boolean UNKNOWN;
    protected boolean alphaKeto;
    protected boolean structInc = false;
    private int sInc = 0;
    protected int SulfurSnInc = 0;
    protected Ionizer ionizer;
    protected boolean resetIonizer = true;
    public static final int PARAMETERCOUNT = 300;
    protected boolean resultValid = true;
    float progress = -1.0f;
    protected List<Integer> alphaKetoHeteroAtoms = new ArrayList<Integer>();
    int[][] atomIDs;
    int index = 0;

    @Override
    public double[] getDescriptors(Molecule data, boolean forceData) {
        double[] result = this.getDescriptors(data, forceData, null);
        return result;
    }

    public double[] getDescriptors(Molecule data, boolean forceData, Ionizer ionizer) {
        this.ionizer = ionizer;
        this.resetIonizer = ionizer == null;
        double[] descriptor = this.getDescriptorsByAtomId(data, forceData, false)[0];
        if (descriptor == null) {
            return new double[0];
        }
        return descriptor;
    }

    public double[][] getDescriptorsByAtomId(Molecule data, boolean forceData) {
        return this.getDescriptorsByAtomId(data, forceData, true);
    }

    public double[][] getDescriptorsByAtomId(Molecule data, boolean forceData, Ionizer ionizer) {
        this.ionizer = ionizer;
        this.resetIonizer = ionizer == null;
        return this.getDescriptorsByAtomId(data, forceData);
    }

    public int[][] getAtomIDs() {
        return this.atomIDs;
    }

    private double[][] getDescriptorsByAtomId(Molecule data, boolean forceData, boolean separatedDataNeeded) {
        boolean usable;
        this.UNKNOWN = false;
        this.resultValid = true;
        Molecule molecule = this.getMolecule(data);
        this.mapMolecule(molecule);
        this.progress = 0.0f;
        if (this.resetIonizer) {
            this.initIonizer();
        }
        double[][] atomicDescriptors = new double[separatedDataNeeded ? molecule.getAtomCount() : 1][300];
        this.atomIDs = new int[molecule.getAtomCount()][];
        this.alphaKetoHeteroAtoms = this.getAlphaKetoHeteroAtoms();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            this.setDescriptor(i, atomicDescriptors[separatedDataNeeded ? i : 0]);
        }
        boolean valid = this.resultValid && molecule.getAtomCount() > 0;
        boolean bl = usable = valid && (forceData || !this.UNKNOWN && !this.isZwitterion(molecule));
        if (!usable) {
            atomicDescriptors[0] = null;
        }
        return atomicDescriptors;
    }

    protected List<Integer> getAlphaKetoHeteroAtoms() {
        ArrayList<Integer> vec = new ArrayList<Integer>();
        vec.add(8);
        vec.add(16);
        vec.add(34);
        vec.add(52);
        vec.add(7);
        return vec;
    }

    protected Molecule getMolecule(Molecule molecule) {
        return molecule;
    }

    private void initIonizer() {
        this.ionizer = new Ionizer();
        this.ionizer.micropKaCalc = true;
        this.ionizer.setpKaPrefixType(1);
        this.ionizer.setMolecule(this.mol);
        this.ionizer.initMsCalculation();
    }

    protected void mapMolecule(Molecule molecule) {
        this.cHtab = molecule.createCHtab();
        this.bHtab = molecule.createBHtab();
        this.atomArray = molecule.getAtomArray();
        this.mol = molecule;
    }

    protected double setDescriptor(int atomIndex, double[] descriptor) {
        ArrayList<Integer> atomContributions = new ArrayList<Integer>();
        int[] aInc = new int[2];
        this.getAtomID(atomIndex);
        this.atomIDs[atomIndex] = new int[]{this.hybridState, this.fragmentId};
        int pc = this.atomArray[atomIndex].getAtno();
        int impH = this.atomArray[atomIndex].getImplicitHcount();
        switch (pc) {
            case 6: {
                aInc[0] = this.getCarbonID(atomIndex, atomContributions);
                break;
            }
            case 7: {
                aInc[0] = this.getNitrogenID(atomIndex, atomContributions);
                break;
            }
            case 8: {
                aInc[0] = this.getOxigenID(atomIndex, atomContributions);
                break;
            }
            case 16: {
                aInc[0] = this.getSulfurID(atomIndex, atomContributions);
                break;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                aInc[0] = this.getHalogenID(atomIndex, atomContributions);
                break;
            }
            default: {
                aInc[0] = this.getMinoricAtomID(atomIndex, atomContributions);
            }
        }
        if (impH != 0) {
            aInc[1] = this.getHidrogenID(atomIndex, impH, atomContributions);
        }
        this.setStrucID(descriptor);
        this.resultValid &= this.validate(aInc);
        this.incDescriptors(atomContributions, descriptor);
        return atomContributions.isEmpty() ? -1.0 : (double)((Integer)atomContributions.get(0)).intValue();
    }

    protected boolean validate(int[] aInc) {
        return aInc[0] > -1;
    }

    protected void incDescriptors(List<Integer> vec, double[] descriptor) {
        for (int i = 0; i < vec.size(); ++i) {
            int n = vec.get(i);
            descriptor[n] = descriptor[n] + 1.0;
        }
    }

    private void setStrucID(double[] descriptor) {
        if (this.structInc) {
            descriptor[181] = descriptor[181] + (double)this.sInc;
        }
        this.structInc = false;
        this.sInc = 0;
        for (int i = 0; i < this.SulfurSnInc; ++i) {
            descriptor[263] = descriptor[263] + 1.0;
        }
        this.SulfurSnInc = 0;
    }

    private void getAtomID(int atom) {
        int[] ids = LogPUtil.getAtomID(this.mol, atom);
        this.actualAtom = atom;
        this.hybridState = ids[0];
        this.fragmentId = ids[1];
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length) continue;
            this.sInc += this.getStrucInc(nb);
        }
    }

    protected int getStrucInc(int nb) {
        return 0;
    }

    protected int getSp3CarbonID(int atom, List<Integer> atomContributions) {
        switch (this.fragmentId) {
            case 4: 
            case 9: 
            case 53: {
                atomContributions.add(1);
                break;
            }
            case 14: 
            case 58: 
            case 102: {
                atomContributions.add(2);
                break;
            }
            case 19: 
            case 63: 
            case 107: 
            case 151: {
                atomContributions.add(3);
                break;
            }
            case 24: 
            case 68: 
            case 112: 
            case 156: 
            case 200: {
                atomContributions.add(4);
                break;
            }
            case 39: {
                atomContributions.add(5);
                break;
            }
            case 44: 
            case 88: {
                atomContributions.add(6);
                break;
            }
            case 74: {
                atomContributions.add(7);
                break;
            }
            case 49: 
            case 93: 
            case 137: 
            case 142: {
                atomContributions.add(8);
                break;
            }
            case 79: 
            case 123: {
                atomContributions.add(9);
                break;
            }
            case 109: {
                atomContributions.add(10);
                break;
            }
            case 54: 
            case 98: 
            case 186: {
                atomContributions.add(11);
                break;
            }
            case 84: 
            case 128: 
            case 172: {
                atomContributions.add(12);
                break;
            }
            case 114: 
            case 158: {
                atomContributions.add(13);
                break;
            }
            case 144: {
                atomContributions.add(14);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    protected int getChargedSp2CarbonId() {
        switch (this.fragmentId) {
            case 18: {
                return 186;
            }
        }
        return 187;
    }

    protected int getSp2CarbonID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            this.UNKNOWN = true;
            int descIndex = this.getChargedSp2CarbonId();
            atomContributions.add(descIndex);
            return descIndex;
        }
        switch (this.fragmentId) {
            case 38: 
            case 218: {
                atomContributions.add(15);
                break;
            }
            case 223: {
                atomContributions.add(16);
                break;
            }
            case 267: {
                atomContributions.add(16);
                break;
            }
            case 228: 
            case 238: {
                atomContributions.add(17);
                break;
            }
            case 272: 
            case 316: {
                atomContributions.add(17);
                break;
            }
            case 253: {
                atomContributions.add(18);
                break;
            }
            case 302: {
                atomContributions.add(19);
                break;
            }
            case 258: {
                atomContributions.add(19);
                break;
            }
            case 284: 
            case 288: {
                atomContributions.add(20);
                break;
            }
            case 2593: {
                atomContributions.add(24);
                break;
            }
            case 2598: 
            case 2642: 
            case 3888: {
                atomContributions.add(25);
                break;
            }
            case 2628: {
                atomContributions.add(26);
                break;
            }
            case 9073: {
                atomContributions.add(27);
                break;
            }
            case 2592: 
            case 9078: 
            case 9122: 
            case 10368: {
                atomContributions.add(28);
                break;
            }
            case 9108: 
            case 16848: {
                atomContributions.add(29);
                break;
            }
            case 15553: 
            case 93313: {
                atomContributions.add(30);
                break;
            }
            case 15558: 
            case 15602: {
                atomContributions.add(31);
                break;
            }
            case 15588: {
                atomContributions.add(32);
                break;
            }
            case 47953: {
                atomContributions.add(33);
                break;
            }
            case 48002: {
                atomContributions.add(34);
                break;
            }
            case 47958: {
                atomContributions.add(34);
                break;
            }
            case 49248: {
                atomContributions.add(34);
                break;
            }
            case 47988: {
                atomContributions.add(35);
                break;
            }
            case 43: {
                atomContributions.add(36);
                break;
            }
            case 87: {
                atomContributions.add(37);
                break;
            }
            case 48: {
                atomContributions.add(38);
                break;
            }
            case 122: {
                atomContributions.add(39);
                break;
            }
            case 92: 
            case 136: {
                atomContributions.add(39);
                break;
            }
            case 78: {
                atomContributions.add(40);
                break;
            }
            case 73: {
                atomContributions.add(40);
                break;
            }
            case 108: {
                atomContributions.add(41);
                break;
            }
            case 54433: {
                atomContributions.add(42);
                break;
            }
            case 54438: 
            case 54482: 
            case 55728: 
            case 62208: 
            case 93318: 
            case 93362: 
            case 94608: {
                atomContributions.add(43);
                break;
            }
            case 54468: 
            case 93348: {
                atomContributions.add(44);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    protected int getSpCarbonID(int atom, List<Integer> atomContributions) {
        switch (this.fragmentId) {
            case 7: 
            case 151: {
                atomContributions.add(21);
                break;
            }
            case 12: 
            case 56: 
            case 432: {
                atomContributions.add(22);
                break;
            }
            case 48: {
                atomContributions.add(23);
                break;
            }
            case 72: 
            case 156: {
                atomContributions.add(40);
                break;
            }
            case 186: {
                atomContributions.add(40);
                break;
            }
            case 200: {
                atomContributions.add(40);
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    private int getCarbonID(int atom, List<Integer> atomContributions) {
        switch (this.hybridState) {
            case 4: {
                return this.getSp3CarbonID(atom, atomContributions);
            }
            case 3: {
                return this.getSp2CarbonID(atom, atomContributions);
            }
            case 2: {
                return this.getSpCarbonID(atom, atomContributions);
            }
        }
        this.UNKNOWN = true;
        return -1;
    }

    protected boolean isAraS(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int pc;
            if (!this.isArA(this.cHtab[a][i]) || (pc = this.atomArray[this.cHtab[a][i]].getAtno()) == 16 || pc == 6) continue;
            return false;
        }
        return true;
    }

    protected boolean isAraEstherInc(int a) {
        if (this.ionizer.getCarboxy(a) != 2 || this.ionizer.getPolarGroupProperty(a) == 412 || this.ionizer.isInRing(a)) {
            return false;
        }
        int[] distances = this.calcShortestDistance(a, 2);
        for (int i = 0; i < distances.length; ++i) {
            int t;
            if (distances[i] != 2 || (t = this.ionizer.getpKaBasicType(i, 0)) != 200 && t != 500 && t != 600) continue;
            return false;
        }
        return true;
    }

    protected boolean isEtenEstherInc(int a) {
        if (this.ionizer.getCarboxy(a) != 2 || this.ionizer.getPolarGroupProperty(a) == 412) {
            return false;
        }
        int[] distances = this.calcShortestDistance(a, 1);
        for (int i = 0; i < distances.length; ++i) {
            if (distances[i] != 1 || this.ionizer.delocable(i) != 1 || this.atomArray[i].getAtno() != 6 || this.isArA(i)) continue;
            return true;
        }
        return false;
    }

    private int[] calcShortestDistance(int atom, int maxDistance) {
        int actAtom = atom;
        int[] shortestDist = new int[this.atomArray.length];
        int[] sphere = new int[this.atomArray.length];
        int sphereSize = 0;
        for (int i = 0; i < this.atomArray.length; ++i) {
            shortestDist[i] = -1;
            sphere[i] = -1;
        }
        shortestDist[atom] = 0;
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.atomArray.length || shortestDist[sphereAtom] > 0 || sphereAtom == atom) continue;
                    shortestDist[sphereAtom] = distance;
                    sphere[sphereSize] = sphereAtom;
                    ++sphereSize;
                }
            }
            if (sphere[i] != -1) {
                actAtom = sphere[i];
                distance = shortestDist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
        return shortestDist;
    }

    protected int getQuaternerNitrogenID(int atom, List<Integer> atomContributions) {
        this.UNKNOWN = true;
        return -1;
    }

    protected int getChargedNPlusR4NitrogenID() {
        switch (this.fragmentId) {
            case 24: {
                return 197;
            }
            case 19: {
                return 181;
            }
            case 14: {
                return 182;
            }
            case 53: {
                return 183;
            }
            case 58: {
                return 184;
            }
            case 63: {
                return 185;
            }
            case 88: {
                return 184;
            }
            case 68: {
                return 198;
            }
        }
        return 182;
    }

    protected int getNPlusR4NitrogenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            this.UNKNOWN = true;
            int descIndex = this.getChargedNPlusR4NitrogenID();
            atomContributions.add(descIndex);
            return descIndex;
        }
        switch (this.fragmentId) {
            case 54: {
                if (this.ionizer.getCarboxy(this.actualAtom) != 1200) break;
                atomContributions.add(76);
                return 76;
            }
        }
        return -1;
    }

    private boolean isAmidineorGuanidine(int atomIndex) {
        return this.ionizer.getpKaBasicType(atomIndex, 0) == 3;
    }

    protected int getChargedSP3Nitrogen() {
        switch (this.fragmentId) {
            case 2593: {
                return 193;
            }
            case 9078: {
                return 194;
            }
            case 9108: {
                return 193;
            }
            case 223: {
                if (this.isAmidineorGuanidine(this.actualAtom)) {
                    return 195;
                }
                return 194;
            }
            case 228: {
                return 196;
            }
            case 2598: {
                return 199;
            }
            case 267: {
                return 193;
            }
        }
        if (this.ionizer.getCarboxy(this.actualAtom) == 1200) {
            return 0;
        }
        return this.isAmidineorGuanidine(this.actualAtom) ? 195 : 194;
    }

    protected int getSP3NitrogenID(int atom, List<Integer> atomContributions) {
        int descIndex = -1;
        if (this.isCharged(this.actualAtom)) {
            descIndex = this.getChargedSP3Nitrogen();
            if (descIndex > -1) {
                atomContributions.add(descIndex);
            }
            if (descIndex != 196 && descIndex != 199) {
                this.UNKNOWN = true;
            }
            return descIndex;
        }
        if (this.isAlphaKeto(this.actualAtom)) {
            descIndex = this.fragmentId == 57 ? 70 : 72;
            atomContributions.add(0, descIndex);
            return descIndex;
        }
        switch (this.fragmentId) {
            case 8: {
                descIndex = 66;
                break;
            }
            case 13: {
                descIndex = 67;
                break;
            }
            case 18: {
                descIndex = 68;
                break;
            }
            case 48: {
                descIndex = 72;
                break;
            }
            case 38: 
            case 43: 
            case 52: {
                descIndex = 69;
                break;
            }
            case 57: {
                descIndex = 70;
                break;
            }
            case 62: {
                descIndex = 71;
                break;
            }
            case 73: {
                descIndex = 67;
                break;
            }
            case 92: {
                descIndex = 71;
                break;
            }
            case 101: 
            case 106: 
            case 150: 
            case 2593: 
            case 2598: {
                descIndex = 73;
                break;
            }
            case 78: {
                if (this.ionizer.getCarboxy(this.actualAtom) == 100) {
                    descIndex = 77;
                    break;
                }
                descIndex = 76;
                break;
            }
            case 108: {
                descIndex = 76;
                break;
            }
            case 302: {
                descIndex = 78;
                break;
            }
            case 122: {
                if (this.ionizer.getCarboxy(this.actualAtom) == 1300) {
                    descIndex = 76;
                    break;
                }
                descIndex = 76;
                break;
            }
            case 2628: 
            case 9108: {
                if (this.ispyridineOxide(this.actualAtom)) {
                    descIndex = 76;
                    break;
                }
                descIndex = 75;
                break;
            }
            case 3888: {
                descIndex = 75;
                break;
            }
            case 258: {
                descIndex = 78;
                break;
            }
            case 9073: 
            case 15553: 
            case 15558: 
            case 47953: {
                descIndex = 73;
                break;
            }
            case 87: {
                descIndex = 78;
                break;
            }
            case 9122: {
                descIndex = 73;
                break;
            }
            case 9078: {
                descIndex = 73;
                break;
            }
            case 10368: 
            case 16848: {
                descIndex = 73;
                break;
            }
            case 54433: {
                descIndex = 75;
            }
        }
        if (descIndex > -1) {
            atomContributions.add(0, descIndex);
        }
        return descIndex;
    }

    protected int getChargedSP2Nitrogen() {
        switch (this.fragmentId) {
            case 2592: {
                return 188;
            }
            case 12: {
                if (this.ionizer.getPolarGroupProperty(this.actualAtom) == 410) {
                    return 190;
                }
                return 189;
            }
            case 200: {
                return 0;
            }
            case 7: 
            case 156: {
                return 191;
            }
            case 72: {
                return 191;
            }
            case 36: {
                return 192;
            }
        }
        if (this.ionizer.getCarboxy(this.actualAtom) == 400) {
            return -1;
        }
        return 189;
    }

    protected int getSP2NitrogenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            int descIndex = this.getChargedSP2Nitrogen();
            if (descIndex > -1) {
                atomContributions.add(descIndex);
            }
            return descIndex;
        }
        if (this.isAlphaKeto(this.actualAtom)) {
            atomContributions.add(0, 72);
            return 72;
        }
        int descIndex = -1;
        switch (this.fragmentId) {
            case 2592: {
                descIndex = 75;
                break;
            }
            case 9072: {
                descIndex = 75;
                break;
            }
            case 6: {
                descIndex = 74;
                break;
            }
            case 150: {
                descIndex = 74;
                break;
            }
            case 12: 
            case 42: 
            case 217: {
                descIndex = 74;
                break;
            }
            case 72: 
            case 86: {
                descIndex = 78;
                break;
            }
            case 252: {
                descIndex = 74;
                break;
            }
            case 37: 
            case 222: 
            case 54432: 
            case 93312: {
                descIndex = 74;
                break;
            }
            case 15552: 
            case 47952: {
                descIndex = 75;
                break;
            }
            case 266: {
                descIndex = 73;
            }
        }
        if (descIndex > -1) {
            atomContributions.add(0, descIndex);
        }
        return descIndex;
    }

    private int getNitrogenID(int atom, List<Integer> atomContributions) {
        switch (this.hybridState) {
            case 5: {
                return this.getQuaternerNitrogenID(atom, atomContributions);
            }
            case 4: {
                return this.getNPlusR4NitrogenID(atom, atomContributions);
            }
            case 3: {
                return this.getSP3NitrogenID(atom, atomContributions);
            }
            case 1: 
            case 2: {
                return this.getSP2NitrogenID(atom, atomContributions);
            }
        }
        this.UNKNOWN = true;
        return -1;
    }

    protected boolean isSemiAraAtom(int atomIndex) {
        return this.ionizer.getsAra(atomIndex) == 1;
    }

    protected int get2OxigenID(int atom, List<Integer> atomContributions) {
        block0 : switch (this.fragmentId) {
            case 7: {
                this.isAlphaKeto(this.actualAtom);
                if (this.alphaKeto) {
                    atomContributions.add(57);
                    break;
                }
                if (this.isEnol(this.actualAtom)) {
                    atomContributions.add(57);
                    break;
                }
                atomContributions.add(56);
                break;
            }
            case 37: {
                atomContributions.add(57);
                break;
            }
            case 51: {
                atomContributions.add(57);
                break;
            }
            case 12: {
                atomContributions.add(60);
                break;
            }
            case 42: 
            case 56: 
            case 72: 
            case 86: 
            case 100: 
            case 2592: 
            case 9072: 
            case 15552: {
                atomContributions.add(0, 60);
                break;
            }
            default: {
                if (!this.isCharged(this.actualAtom)) break;
                this.UNKNOWN = true;
                switch (this.fragmentId) {
                    case 217: {
                        atomContributions.add(137);
                        break block0;
                    }
                    case 252: {
                        atomContributions.add(138);
                    }
                }
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    protected int get1OxigenID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            switch (this.fragmentId) {
                case 6: {
                    atomContributions.add(180);
                    break;
                }
                case 50: {
                    this.UNKNOWN = true;
                    atomContributions.add(0);
                    break;
                }
                case 36: {
                    atomContributions.add(190);
                    break;
                }
                default: {
                    this.UNKNOWN = true;
                    atomContributions.add(0);
                    break;
                }
            }
        } else {
            switch (this.fragmentId) {
                case 216: {
                    atomContributions.add(58);
                    break;
                }
                case 36: {
                    atomContributions.add(this.isNitroTypeOxigen(this.actualAtom) ? 61 : 58);
                }
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    protected int get3OxigenID(int atom, List<Integer> atomContributions) {
        this.UNKNOWN = true;
        return -1;
    }

    private int getOxigenID(int atom, List<Integer> atomContributions) {
        switch (this.hybridState) {
            case 1: {
                return this.get1OxigenID(atom, atomContributions);
            }
            case 2: {
                return this.get2OxigenID(atom, atomContributions);
            }
            case 3: {
                return this.get3OxigenID(atom, atomContributions);
            }
        }
        this.UNKNOWN = true;
        return -1;
    }

    protected int getSulfurID(int atom, List<Integer> atomContributions) {
        if (this.isCharged(this.actualAtom)) {
            int descIndex = -1;
            switch (this.fragmentId) {
                case 6: {
                    descIndex = 170;
                    break;
                }
                case 50: {
                    descIndex = 171;
                    break;
                }
                default: {
                    descIndex = 171;
                }
            }
            this.UNKNOWN = true;
            if (descIndex > -1) {
                atomContributions.add(descIndex);
                return atomContributions.get(0);
            }
            return -1;
        }
        switch (this.fragmentId) {
            case 7: 
            case 37: {
                atomContributions.add(106);
                break;
            }
            case 12: 
            case 42: 
            case 72: 
            case 100: {
                atomContributions.add(0, 107);
                break;
            }
            case 6: 
            case 36: 
            case 216: 
            case 228: 
            case 258: 
            case 288: {
                atomContributions.add(108);
                break;
            }
            case 48: 
            case 92: 
            case 122: 
            case 136: {
                atomContributions.add(0, 109);
                break;
            }
            case 84: 
            case 128: 
            case 144: 
            case 172: {
                atomContributions.add(110);
                break;
            }
            case 51: 
            case 56: 
            case 86: {
                atomContributions.add(111);
                break;
            }
            case 114: 
            case 158: {
                atomContributions.add(112);
                break;
            }
            case 2592: 
            case 9072: 
            case 15552: {
                atomContributions.add(113);
                break;
            }
            case 108: {
                atomContributions.add(114);
            }
        }
        if (atomContributions.isEmpty()) {
            this.UNKNOWN = true;
            return -1;
        }
        return atomContributions.get(0);
    }

    protected int getMinoricAtomID(int ai, List<Integer> atomContributions) {
        int pc = this.atomArray[ai].getAtno();
        block0 : switch (pc) {
            case 34: {
                switch (this.fragmentId) {
                    case 2592: 
                    case 9072: 
                    case 15552: {
                        atomContributions.add(64);
                        break block0;
                    }
                }
                atomContributions.add(65);
                break;
            }
            case 15: {
                if (this.skipPhosphor()) {
                    this.UNKNOWN = true;
                    atomContributions.add(171);
                    return 171;
                }
                switch (this.fragmentId) {
                    case 54: {
                        atomContributions.add(116);
                        break block0;
                    }
                    case 144: {
                        atomContributions.add(117);
                        break block0;
                    }
                    case 108: {
                        atomContributions.add(118);
                        break block0;
                    }
                    case 18: {
                        atomContributions.add(119);
                        break block0;
                    }
                    case 114: {
                        atomContributions.add(120);
                        break block0;
                    }
                }
                this.UNKNOWN = true;
                return -1;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 38: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 56: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                atomContributions.add(130);
                return 130;
            }
            default: {
                this.UNKNOWN = true;
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    protected boolean skipPhosphor() {
        return this.isCharged(this.actualAtom);
    }

    protected boolean isAraConnect(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            if (!this.ionizer.isArA(this.cHtab[a][i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isOxigenConnect(int a) {
        for (int i = 0; i < this.cHtab[a].length; ++i) {
            int protonCount = this.atomArray[this.cHtab[a][i]].getAtno();
            if (protonCount != 8) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnol(int Oh) {
        int nb = this.cHtab[Oh][0];
        int pc = this.atomArray[nb].getAtno();
        if (pc != 6 && pc != 14) {
            return false;
        }
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int bondOrder;
            int nnb = this.cHtab[nb][i];
            if (nnb >= this.atomArray.length || (bondOrder = this.mol.getBond(this.bHtab[nb][nnb]).getType()) != 2 || (pc = this.atomArray[nb].getAtno()) != 6 && pc != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean isCharged(int atom) {
        double charge = this.atomArray[atom].getCharge();
        return charge != 0.0;
    }

    private int getHalogenID(int atom, List<Integer> atomContributions) {
        int pc = this.atomArray[atom].getAtno();
        int oxnumber = 0;
        try {
            int nb = this.cHtab[atom][0];
            if (this.atomArray[this.cHtab[atom][0]].getAtno() != 6) {
                switch (pc) {
                    case 9: {
                        atomContributions.add(85);
                        break;
                    }
                    case 17: {
                        atomContributions.add(90);
                        break;
                    }
                    case 35: {
                        atomContributions.add(95);
                        break;
                    }
                    case 53: {
                        atomContributions.add(100);
                        break;
                    }
                    default: {
                        this.UNKNOWN = true;
                    }
                }
                if (atomContributions.isEmpty()) {
                    return -1;
                }
                return atomContributions.get(0);
            }
            this.hybridState = this.cHtab[nb].length;
            oxnumber = this.getFormalOxidationNumber(nb, this.getEN(nb));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        switch (oxnumber) {
            case 0: {
                switch (pc) {
                    case 9: {
                        atomContributions.add(81);
                        break;
                    }
                    case 17: {
                        atomContributions.add(86);
                        break;
                    }
                    case 35: {
                        atomContributions.add(91);
                        break;
                    }
                    case 53: {
                        atomContributions.add(96);
                    }
                }
                break;
            }
            case 1: {
                block20 : switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(81);
                                break;
                            }
                            case 17: {
                                atomContributions.add(86);
                                break;
                            }
                            case 35: {
                                atomContributions.add(91);
                                break;
                            }
                            case 53: {
                                atomContributions.add(96);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(84);
                                break;
                            }
                            case 17: {
                                atomContributions.add(89);
                                break;
                            }
                            case 35: {
                                atomContributions.add(94);
                                break;
                            }
                            case 53: {
                                atomContributions.add(99);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(85);
                                break block20;
                            }
                            case 17: {
                                atomContributions.add(90);
                                break block20;
                            }
                            case 35: {
                                atomContributions.add(95);
                                break block20;
                            }
                            case 53: {
                                atomContributions.add(100);
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                block43 : switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(82);
                                break;
                            }
                            case 17: {
                                atomContributions.add(87);
                                break;
                            }
                            case 35: {
                                atomContributions.add(92);
                                break;
                            }
                            case 53: {
                                atomContributions.add(97);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(85);
                                break block43;
                            }
                            case 17: {
                                atomContributions.add(90);
                                break block43;
                            }
                            case 35: {
                                atomContributions.add(95);
                                break block43;
                            }
                            case 53: {
                                atomContributions.add(100);
                            }
                        }
                    }
                }
                break;
            }
            case 3: {
                block59 : switch (this.hybridState) {
                    case 4: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(83);
                                break;
                            }
                            case 17: {
                                atomContributions.add(88);
                                break;
                            }
                            case 35: {
                                atomContributions.add(93);
                                break;
                            }
                            case 53: {
                                atomContributions.add(98);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(85);
                                break block59;
                            }
                            case 17: {
                                atomContributions.add(90);
                                break block59;
                            }
                            case 35: {
                                atomContributions.add(95);
                                break block59;
                            }
                            case 53: {
                                atomContributions.add(100);
                            }
                        }
                    }
                }
                break;
            }
            case 4: {
                block75 : switch (this.hybridState) {
                    case 2: 
                    case 3: 
                    case 4: {
                        switch (pc) {
                            case 9: {
                                atomContributions.add(85);
                                break block75;
                            }
                            case 17: {
                                atomContributions.add(90);
                                break block75;
                            }
                            case 35: {
                                atomContributions.add(95);
                                break block75;
                            }
                            case 53: {
                                atomContributions.add(100);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                this.UNKNOWN = true;
                return -1;
            }
        }
        if (atomContributions.isEmpty()) {
            return -1;
        }
        return atomContributions.get(0);
    }

    private void addToVec(List<Integer> vector, int value, int count) {
        for (int i = 0; i < count; ++i) {
            vector.add(value);
        }
    }

    private int getHidrogenID(int ai, int impH, List<Integer> atomContributions) {
        int L = this.cHtab[ai].length;
        int pc = this.atomArray[ai].getAtno();
        switch (pc) {
            case 6: {
                if (this.isAlphaCarbon(ai)) {
                    this.addToVec(atomContributions, 51, impH);
                    return 51;
                }
                int oxnumber = this.getFormalOxidationNumber(ai, this.getEN(ai));
                switch (oxnumber) {
                    case 0: {
                        switch (L) {
                            case 4: {
                                int xAtoms = this.getBetaXAtoms(ai);
                                switch (xAtoms) {
                                    case 0: {
                                        this.addToVec(atomContributions, 46, impH);
                                        return 46;
                                    }
                                    case 1: {
                                        this.addToVec(atomContributions, 52, impH);
                                        return 52;
                                    }
                                    case 2: {
                                        this.addToVec(atomContributions, 53, impH);
                                        return 53;
                                    }
                                    case 3: {
                                        this.addToVec(atomContributions, 54, impH);
                                        return 54;
                                    }
                                }
                                this.addToVec(atomContributions, 55, impH);
                                return 55;
                            }
                            case 3: {
                                this.addToVec(atomContributions, 47, impH);
                                return 47;
                            }
                            case 2: {
                                this.addToVec(atomContributions, 48, impH);
                                return 48;
                            }
                        }
                    }
                    case 1: {
                        switch (L) {
                            case 4: {
                                this.addToVec(atomContributions, 47, impH);
                                return 47;
                            }
                            case 3: {
                                this.addToVec(atomContributions, 48, impH);
                                return 48;
                            }
                        }
                    }
                    case 2: {
                        switch (L) {
                            case 4: {
                                this.addToVec(atomContributions, 48, impH);
                                return 48;
                            }
                            case 3: {
                                this.addToVec(atomContributions, 49, impH);
                                return 49;
                            }
                        }
                    }
                    case 3: {
                        switch (L) {
                            case 4: {
                                this.addToVec(atomContributions, 49, impH);
                                return 49;
                            }
                            case 3: {
                                this.addToVec(atomContributions, 49, impH);
                                return 49;
                            }
                            case 2: {
                                this.addToVec(atomContributions, 49, impH);
                                return 49;
                            }
                        }
                    }
                }
            }
        }
        this.addToVec(atomContributions, 50, impH);
        return 50;
    }

    private int getBetaXAtoms(int atom) {
        int xAtom = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int pc;
                int nnb = this.cHtab[nb][j];
                if (nnb == atom || nnb >= this.atomArray.length || (pc = this.atomArray[nnb].getAtno()) <= 6) continue;
                if (pc != 16) {
                    ++xAtom;
                    continue;
                }
                if (this.isArA(nnb)) continue;
                ++xAtom;
            }
        }
        return xAtom;
    }

    private boolean isAlphaCarbon(int atom) {
        this.alphaKeto = false;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length) continue;
            int pc = this.atomArray[nb].getAtno();
            int bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType();
            if (pc != 6 && pc != 16 || bondOrder != 1) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.atomArray.length || (bondOrder = this.mol.getBond(this.bHtab[nb][nnb]).getType()) <= 1 || this.isPyrroleN(nnb)) continue;
                this.alphaKeto = true;
                pc = this.atomArray[nnb].getAtno();
                if (pc <= 6) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPyrroleN(int atom) {
        if (this.isArA(atom)) {
            int pc = this.atomArray[atom].getAtno();
            if (pc == 7) {
                int charge = this.atomArray[atom].getCharge();
                if (this.cHtab[atom].length == 2 && charge == 0) {
                    return false;
                }
                if (this.cHtab[atom].length == 3) {
                    return charge != 1;
                }
                if (this.cHtab[atom].length == 2 && charge == -1) {
                    return true;
                }
                if (this.ispyridineOxide(atom)) {
                    return false;
                }
            } else if (pc != 6) {
                return true;
            }
        }
        return false;
    }

    private boolean ispyridineOxide(int atom) {
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int bondOrder;
            int pc;
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length || (pc = this.atomArray[nb].getAtno()) != 8 || (bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType()) != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isNitroTypeOxigen(int atom) {
        int nb = this.cHtab[atom][0];
        if (nb >= this.atomArray.length) {
            return false;
        }
        int pc = this.atomArray[nb].getAtno();
        int oCount = 0;
        if (pc == 7) {
            for (int i = 0; i < this.cHtab[nb].length; ++i) {
                int bondOrder;
                int nnb = this.cHtab[nb][i];
                if (nnb >= this.atomArray.length || (bondOrder = this.mol.getBond(this.bHtab[nb][nnb]).getType()) <= 1 || (pc = this.atomArray[nnb].getAtno()) != 8) continue;
                ++oCount;
            }
            if (this.atomArray[nb].hasAromaticBond() ? oCount == 1 : oCount == 2) {
                return true;
            }
        }
        return false;
    }

    private double getEN(int atom) {
        int pc = this.atomArray[atom].getAtno();
        return MolAtom.electronegOf(pc);
    }

    private int getFormalOxidationNumber(int atom, double en) {
        int oxsum = 0;
        int bondOrder = 0;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length) continue;
            double elene = this.getEN(nb);
            boolean pyridineType = false;
            if (!(elene > en)) continue;
            bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType();
            if (bondOrder == 4) {
                double pc = this.atomArray[nb].getAtno();
                if (pc == 7.0) {
                    if (this.ispyridineOxide(nb)) {
                        pyridineType = true;
                    }
                    if (this.cHtab[nb].length == 2 || pyridineType) {
                        oxsum += 2;
                        continue;
                    }
                    if (this.cHtab[nb].length != 3) continue;
                    ++oxsum;
                    continue;
                }
                if (pc == 7.0) continue;
                ++oxsum;
                continue;
            }
            if (bondOrder == 4) continue;
            oxsum += bondOrder;
        }
        if (oxsum > 4) {
            oxsum = 4;
        }
        return oxsum;
    }

    protected boolean isAlphaKeto(int atom) {
        this.alphaKeto = false;
        for (int i = 0; i < this.cHtab[atom].length; ++i) {
            int bondOrder;
            int nb = this.cHtab[atom][i];
            if (nb >= this.atomArray.length || (bondOrder = this.mol.getBond(this.bHtab[atom][nb]).getType()) != 1 && bondOrder != 4) continue;
            for (int j = 0; j < this.cHtab[nb].length; ++j) {
                int pc;
                int nnb = this.cHtab[nb][j];
                if (nnb >= this.atomArray.length || !this.alphaKetoHeteroAtoms.contains(pc = this.atomArray[nnb].getAtno()) || (bondOrder = this.mol.getBond(this.bHtab[nb][nnb]).getType()) != 2) continue;
                this.alphaKeto = true;
                return true;
            }
        }
        return false;
    }

    private boolean isArA(int atom) {
        return atom < this.atomArray.length && this.atomArray[atom].hasAromaticBond();
    }

    protected boolean isZwitterion(Molecule mol) {
        Ionizer ionizer = new Ionizer();
        Molecule molCopy = mol.cloneMoleculeWithDocument();
        ionizer.setpKaPrefixType(1);
        ionizer.setMolecule(mol);
        ionizer.setMspHCalc(true);
        ionizer.calculatepKa(0.0);
        int ionCount = ionizer.getIonizableAtomCount();
        if (ionCount != 0 && ionizer.isTrueZwitterIon()) {
            mol = molCopy;
            return true;
        }
        mol = molCopy;
        return false;
    }

    protected boolean isArOHVinil(int Oxigen) {
        int nb = this.cHtab[Oxigen][0];
        if (this.ionizer.getCarboxy(nb) != -1) {
            return false;
        }
        boolean cond1 = false;
        boolean cond2 = false;
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int nnb = this.cHtab[nb][i];
            if (nnb >= this.atomArray.length) continue;
            if (this.isArA(nnb)) {
                cond1 = true;
                continue;
            }
            int bondOrder = this.mol.getBond(this.bHtab[nb][nnb]).getType();
            if (bondOrder != 2) continue;
            cond2 = true;
        }
        return cond1 && cond2;
    }
}

