/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.FutureCalculation;
import chemaxon.calculations.training.LongRunningTask;
import chemaxon.calculations.training.Postprocessor;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.Predictor;
import chemaxon.calculations.training.Preprocessor;
import chemaxon.calculations.training.TrainingModel;
import java.beans.PropertyChangeSupport;

public class FuturePredictor<TT, CT>
extends FutureCalculation<Double>
implements Predictor<TT, CT> {
    protected Preprocessor<TT> preprocessor = null;
    protected Postprocessor<TT> postprocessor = null;

    public FuturePredictor(PredictionAlgorithm<CT> algorithm, TrainingModel<TT> model) {
        this(new Prediction<TT, CT>(algorithm, model));
    }

    protected FuturePredictor(Prediction<TT, CT> prediction) {
        this.longRunningTask = prediction;
    }

    @Override
    public double predict(TT item) {
        this.result = null;
        TT preprocessedItem = this.preprocessor != null ? this.preprocessor.preprocess(item) : item;
        ((Prediction)this.longRunningTask).item = preprocessedItem;
        double result = (Double)this.getAndWait();
        if (this.postprocessor != null) {
            result = this.postprocessor.postprocess(preprocessedItem, result);
        }
        return result;
    }

    @Override
    public void setTrainingResults(CT results) {
        ((Prediction)this.longRunningTask).trainingResults = results;
    }

    public void setPreprocessor(Preprocessor<TT> preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Preprocessor<TT> getPreprocessor() {
        return this.preprocessor;
    }

    public void setPosprocessor(Postprocessor<TT> postprocessor) {
        this.postprocessor = postprocessor;
    }

    public Postprocessor<TT> getPostprocessor() {
        return this.postprocessor;
    }

    public PredictionAlgorithm<CT> getPredictionAlgorithm() {
        return ((Prediction)this.longRunningTask).algorithm;
    }

    @Override
    public void setPredictOnlyTrainables(boolean predictOnlyTrainables) {
        ((Prediction)this.longRunningTask).predictOnlytrainables = predictOnlyTrainables;
    }

    @Override
    public boolean isPredictOnlyTrainables() {
        return ((Prediction)this.longRunningTask).predictOnlytrainables;
    }

    protected static class Prediction<TT, CT>
    implements LongRunningTask<Double> {
        protected boolean predictOnlytrainables = false;
        protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        protected final PredictionAlgorithm<CT> algorithm;
        protected final TrainingModel<TT> model;
        protected TT item = null;
        protected CT trainingResults = null;

        public Prediction(PredictionAlgorithm<CT> algorithm, TrainingModel<TT> model) {
            this.algorithm = algorithm;
            this.model = model;
        }

        @Override
        public Double call() throws Exception {
            this.algorithm.setCoefficients(this.trainingResults);
            double[] descriptors = this.model.getDescriptors(this.item, !this.predictOnlytrainables);
            return this.predictOnlytrainables && descriptors.length == 0 ? Double.NaN : this.algorithm.predict(descriptors);
        }

        @Override
        public float getProgress() {
            return this.algorithm.getProgress();
        }
    }
}

