/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.FutureCalculation;
import chemaxon.calculations.training.LongRunningTask;
import chemaxon.calculations.training.Preprocessor;
import chemaxon.calculations.training.Trainer;
import chemaxon.calculations.training.TrainingModel;
import java.util.ArrayList;
import java.util.List;

public class FutureTrainer<TT, CT>
extends FutureCalculation<CT>
implements Trainer<TT, CT> {
    protected final TrainingModel<TT> model;
    protected final DescriptorMatrix descriptorMatrix;
    protected Preprocessor<TT> preprocessor = null;

    public FutureTrainer(FittingAlgorithm<CT> algorithm, TrainingModel<TT> model, DescriptorMatrix descriptorMatrix) {
        this.model = model;
        this.descriptorMatrix = descriptorMatrix;
        this.longRunningTask = new FittingCalculation<CT>(algorithm, descriptorMatrix);
    }

    @Override
    public void add(TT data, double value) {
        TT processedData = this.preprocessor != null ? this.preprocessor.preprocess(data) : data;
        if (this.descriptorMatrix.insertRow(this.descriptorMatrix.getRowCount(), this.model.getDescriptors(processedData, false))) {
            this.result = null;
            ((FittingCalculation)this.longRunningTask).experimentalValues.add(value);
        }
    }

    public void setPreprocessor(Preprocessor<TT> preprocessor) {
        this.preprocessor = preprocessor;
    }

    public Preprocessor<TT> getPreprocessor() {
        return this.preprocessor;
    }

    @Override
    public CT getResults() {
        return this.getAndWait();
    }

    @Override
    public boolean add(double[] descriptors, double value) {
        if (this.descriptorMatrix.insertRow(this.descriptorMatrix.getRowCount(), descriptors)) {
            this.result = null;
            ((FittingCalculation)this.longRunningTask).experimentalValues.add(value);
            return true;
        }
        return false;
    }

    protected static class FittingCalculation<CT>
    implements LongRunningTask<CT> {
        protected final FittingAlgorithm<CT> algorithm;
        protected final DescriptorMatrix matrix;
        protected final List<Double> experimentalValues = new ArrayList<Double>();

        public FittingCalculation(FittingAlgorithm<CT> algorithm, DescriptorMatrix matrix) {
            this.algorithm = algorithm;
            this.matrix = matrix;
        }

        @Override
        public CT call() throws Exception {
            double[] val = new double[this.experimentalValues.size()];
            for (int i = 0; i < val.length; ++i) {
                val[i] = this.experimentalValues.get(i);
            }
            this.algorithm.setExperimentalValues(val);
            this.algorithm.setDescriptorMatrix(this.matrix);
            return this.algorithm.getResult();
        }

        @Override
        public float getProgress() {
            return this.algorithm.getProgress();
        }
    }
}

