/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import java.util.ArrayList;
import java.util.Collections;

public class MatrixWrapper
implements DescriptorMatrix {
    private DescriptorMatrix matrix;
    private ArrayList<Integer> excludedRows = new ArrayList();
    private static final String errorMessage = "Matrix can't be modified.";

    public MatrixWrapper(DescriptorMatrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public boolean insertRow(int rowIndex, double[] data) {
        throw new IllegalStateException(errorMessage);
    }

    @Override
    public double[] removeRow(int rowIndex) throws IndexOutOfBoundsException {
        throw new IllegalStateException(errorMessage);
    }

    @Override
    public double[] getRow(int rowIndex) throws IndexOutOfBoundsException {
        int realIndex = rowIndex;
        for (int i = 0; i < this.excludedRows.size() && this.excludedRows.get(i) <= rowIndex; ++i) {
            ++realIndex;
        }
        return this.matrix.getRow(realIndex);
    }

    @Override
    public double getValueAt(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        return this.getRow(rowIndex)[colIndex];
    }

    @Override
    public void setValueAt(int rowIndex, int colIndex, double value) throws IndexOutOfBoundsException {
        throw new IllegalStateException(errorMessage);
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.matrix.getRowCount() - this.excludedRows.size();
    }

    @Override
    public void transpose() {
        throw new IllegalStateException(errorMessage);
    }

    public void setState(int rowIndex, boolean available) {
        if (available) {
            this.excludedRows.remove(new Integer(rowIndex));
        } else if (!this.excludedRows.contains(rowIndex)) {
            this.excludedRows.add(rowIndex);
            Collections.sort(this.excludedRows);
        }
    }

    public ArrayList<Integer> getExcludedRowIndexes() {
        return this.excludedRows;
    }
}

