/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.FuturePredictor;
import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.Predictor;
import chemaxon.calculations.training.TrainingModel;
import java.util.ArrayList;
import java.util.List;

public class ParallelPredictor<TT, CT>
implements Predictor<TT, CT> {
    protected final List<Predictor<TT, CT>> predictors;

    public ParallelPredictor(PredictionAlgorithm<CT> algorithm, TrainingModel<TT>[] models) {
        this.predictors = new ArrayList<Predictor<TT, CT>>(models.length);
        for (int i = 0; i < models.length; ++i) {
            this.predictors.add(new FuturePredictor<TT, CT>(algorithm, models[i]));
        }
    }

    public ParallelPredictor(Predictor<TT, CT>[] predictors) {
        this.predictors = new ArrayList<Predictor<TT, CT>>(predictors.length);
        for (int i = 0; i < predictors.length; ++i) {
            this.predictors.add(predictors[i]);
        }
    }

    public ParallelPredictor(List<Predictor<TT, CT>> predictors) {
        this.predictors = predictors;
    }

    @Override
    public void setTrainingResults(CT results) {
        for (Predictor<TT, CT> predictor : this.predictors) {
            predictor.setTrainingResults(results);
        }
    }

    @Override
    public double predict(TT item) {
        return this.predictors.get(0).predict(item);
    }

    public double[] predict(TT ... item) {
        return this.predictAll(item);
    }

    protected double[] predictAll(final TT ... item) {
        final double[] result = new double[item.length];
        int count = 0;
        while (count < result.length) {
            int i;
            int threadCount = Math.min(this.predictors.size(), result.length - count);
            Thread[] threads = new Thread[threadCount];
            for (i = 0; i < threads.length; ++i) {
                final int innerIndex = i;
                final int outerIndex = count++;
                threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result[outerIndex] = ParallelPredictor.this.predictors.get(innerIndex).predict(item[outerIndex]);
                        }
                        catch (Exception e) {
                            result[outerIndex] = Double.NaN;
                        }
                    }
                });
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                try {
                    threads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public int getThreadCount() {
        return this.predictors.size();
    }

    @Override
    public void setPredictOnlyTrainables(boolean predictOnlyTrainables) {
        for (int i = 0; i < this.predictors.size(); ++i) {
            this.predictors.get(i).setPredictOnlyTrainables(predictOnlyTrainables);
        }
    }

    @Override
    public boolean isPredictOnlyTrainables() {
        return this.predictors.get(0).isPredictOnlyTrainables();
    }
}

