/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.FullMatrix;
import chemaxon.calculations.training.SVDTrainingResult;
import java.util.BitSet;

public class SVDFitting
implements FittingAlgorithm<SVDTrainingResult> {
    double[][] a;
    double[][] mX;
    double[][] v;
    double[] w;
    double[] b;
    double[] Y;
    double[] res;
    double[][] cov;
    double[] afunc;
    double[] sig;
    int m;
    int n;
    double[][] T;
    double[][] P;
    double confL = 95.0;
    double se;
    double[][] bounds;
    double[] pStd;
    double[] yStdError;
    boolean testCase = false;
    double SSY;
    double SSYp;
    double SSE;
    double pve;
    double pvne;
    final int COVMATRIX = 1;
    final int FUNLU = 2;
    int errorPredMethod = 1;
    private BitSet columnFilter;
    private int parameterCount;

    public SVDFitting() {
        if (this.testCase) {
            // empty if block
        }
    }

    public void setErrorPredicitionMethod(int errorpm) {
        this.errorPredMethod = errorpm;
    }

    public SVDFitting(DescriptorMatrix matrix, double[] expData) {
        this.setDescriptorMatrix(matrix);
        this.setExperimentalValues(expData);
    }

    private int[] toInt(double[] arr) {
        int[] intarr = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            intarr[i] = (int)arr[i];
        }
        return intarr;
    }

    @Override
    public float getProgress() {
        return -1.0f;
    }

    @Override
    public SVDTrainingResult getResult() {
        this.runMultyRegression();
        double[] params = this.getFittedParameters();
        SVDTrainingResult result = new SVDTrainingResult(null);
        result.setCoefficient(this.getOriginalByMap(params, this.columnFilter, this.parameterCount));
        result.setMatrix(this.cov);
        result.setStandardError(this.se);
        return result;
    }

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        this.columnFilter = new BitSet(matrix.getColumnCount());
        this.parameterCount = matrix.getColumnCount();
        DescriptorMatrix redMatrix = this.getReducedMatrixAndMap(matrix, this.columnFilter);
        this.clearMatrix(redMatrix.getRowCount(), redMatrix.getColumnCount());
        for (int i = 0; i < redMatrix.getRowCount(); ++i) {
            this.setMultyXValue(i, this.toInt(redMatrix.getRow(i)));
        }
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.clearExpValues(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.setYValue(i, values[i]);
        }
    }

    public void setStandardErrorOfExperimentalValue(double[] yerror) {
        this.clearYError(yerror.length);
        for (int i = 0; i < yerror.length; ++i) {
            this.setYError(i, yerror[i]);
        }
    }

    public void setConfidenceLevelValue(int conf) {
        this.confL = conf;
    }

    private DescriptorMatrix getReducedMatrixAndMap(DescriptorMatrix matrix, BitSet map) {
        FullMatrix redMatrix = new FullMatrix(matrix.getRowCount());
        matrix.transpose();
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (!this.isEmpty(matrix.getRow(i))) {
                redMatrix.insertRow(-1, matrix.getRow(i));
                map.set(i, true);
                continue;
            }
            map.set(i, false);
        }
        matrix.transpose();
        redMatrix.transpose();
        return redMatrix;
    }

    private boolean isEmpty(double[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    private double[] getOriginalByMap(double[] redVector, BitSet map, int size) {
        double[] vector = new double[size];
        int offset = 0;
        for (int i = 0; i < vector.length; ++i) {
            if (map.get(i)) {
                vector[i] = redVector[i - offset];
                continue;
            }
            ++offset;
            vector[i] = Double.NaN;
        }
        return vector;
    }

    private void clearMatrix(int rowCount, int columnCount) {
        this.m = rowCount;
        this.n = columnCount;
        this.afunc = new double[this.n];
        this.mX = new double[this.m][this.n];
        this.sig = new double[this.m];
        this.cov = new double[this.n][this.n];
        for (int i = 0; i < this.m; ++i) {
            this.sig[i] = 1.0;
        }
    }

    private void clearExpValues(int dataLenght) {
        this.Y = new double[this.m == 0 ? dataLenght : this.m];
    }

    private void clearYError(int dataLenght) {
        this.sig = new double[this.m == 0 ? dataLenght : this.m];
    }

    private void svdcmp() {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int l = 0;
        int nm = 0;
        double[] rv1 = new double[this.n];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        for (i = 0; i < this.n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < this.m) {
                for (k = i; k < this.m; ++k) {
                    scale += Math.abs(this.a[k][i]);
                }
                if (scale != 0.0) {
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = i;
                        dArray[n] = dArray[n] / scale;
                        s += this.a[k][i] * this.a[k][i];
                    }
                    f = this.a[i][i];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.a[i][i] = f - g;
                    for (j = l - 1; j < this.n; ++j) {
                        s = 0.0;
                        for (k = i; k < this.m; ++k) {
                            s += this.a[k][i] * this.a[k][j];
                        }
                        f = s / h;
                        for (k = i; k < this.m; ++k) {
                            double[] dArray = this.a[k];
                            int n = j;
                            dArray[n] = dArray[n] + f * this.a[k][i];
                        }
                    }
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = i;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            this.w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= this.m && i + 1 != this.n) {
                for (k = l - 1; k < this.n; ++k) {
                    scale += Math.abs(this.a[i][k]);
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < this.n; ++k) {
                        double[] dArray = this.a[i];
                        int n = k;
                        dArray[n] = dArray[n] / scale;
                        s += this.a[i][k] * this.a[i][k];
                    }
                    f = this.a[i][l - 1];
                    g = -this.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    this.a[i][l - 1] = f - g;
                    for (k = l - 1; k < this.n; ++k) {
                        rv1[k] = this.a[i][k] / h;
                    }
                    for (j = l - 1; j < this.m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < this.n; ++k) {
                            s += this.a[j][k] * this.a[i][k];
                        }
                        for (k = l - 1; k < this.n; ++k) {
                            double[] dArray = this.a[j];
                            int n = k;
                            dArray[n] = dArray[n] + s * rv1[k];
                        }
                    }
                    k = l - 1;
                    while (k < this.n) {
                        double[] dArray = this.a[i];
                        int n = k++;
                        dArray[n] = dArray[n] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(this.w[i]) + Math.abs(rv1[i]));
        }
        i = this.n - 1;
        while (i >= 0) {
            if (i < this.n - 1) {
                if (g != 0.0) {
                    for (j = l; j < this.n; ++j) {
                        this.v[j][i] = this.a[i][j] / this.a[i][l] / g;
                    }
                    for (j = l; j < this.n; ++j) {
                        s = 0.0;
                        for (k = l; k < this.n; ++k) {
                            s += this.a[i][k] * this.v[k][j];
                        }
                        for (k = l; k < this.n; ++k) {
                            double[] dArray = this.v[k];
                            int n = j;
                            dArray[n] = dArray[n] + s * this.v[k][i];
                        }
                    }
                }
                for (j = l; j < this.n; ++j) {
                    this.v[j][i] = 0.0;
                    this.v[i][j] = 0.0;
                }
            }
            this.v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = Math.min(this.m, this.n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = this.w[i];
            for (j = l; j < this.n; ++j) {
                this.a[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < this.n; ++j) {
                    s = 0.0;
                    for (k = l; k < this.m; ++k) {
                        s += this.a[k][i] * this.a[k][j];
                    }
                    f = s / this.a[i][i] * g;
                    for (k = i; k < this.m; ++k) {
                        double[] dArray = this.a[k];
                        int n = j;
                        dArray[n] = dArray[n] + f * this.a[k][i];
                    }
                }
                for (j = i; j < this.m; ++j) {
                    double[] dArray = this.a[j];
                    int n = i;
                    dArray[n] = dArray[n] * g;
                }
            } else {
                for (j = i; j < this.m; ++j) {
                    this.a[j][i] = 0.0;
                }
            }
            double[] dArray = this.a[i];
            int n = i--;
            dArray[n] = dArray[n] + 1.0;
        }
        block27: for (k = this.n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm || nm < 0) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(this.w[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = this.w[i];
                        this.w[i] = h = this.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < this.m; ++j) {
                            y = this.a[j][nm];
                            z = this.a[j][i];
                            this.a[j][nm] = y * c + z * s;
                            this.a[j][i] = z * c - y * s;
                        }
                    }
                }
                z = this.w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    this.w[k] = -z;
                    for (j = 0; j < this.n; ++j) {
                        this.v[j][k] = -this.v[j][k];
                    }
                    continue block27;
                }
                if (its == 29) {
                    System.err.println("no convergence in 30 svdcmp iterations");
                }
                double x = this.w[l];
                nm = k - 1;
                y = this.w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + this.sign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = this.w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < this.n; ++jj) {
                        x = this.v[jj][j];
                        z = this.v[jj][i];
                        this.v[jj][j] = x * c + z * s;
                        this.v[jj][i] = z * c - x * s;
                    }
                    this.w[j] = z = this.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < this.m; ++jj) {
                        y = this.a[jj][j];
                        z = this.a[jj][i];
                        this.a[jj][j] = y * c + z * s;
                        this.a[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                this.w[k] = x;
            }
        }
    }

    private double sign(double a1, double a2) {
        a1 = a2 < 0.0 ? -1.0 * Math.abs(a1) : 1.0 * Math.abs(a1);
        return a1;
    }

    private double pythag(double a, double b) {
        double abs_a = Math.abs(a);
        double abs_b = Math.abs(b);
        double res = 0.0;
        if (abs_a > abs_b) {
            double c = abs_b / abs_a;
            c *= c;
            res = abs_a * Math.sqrt(1.0 + c);
        } else if (abs_b == 0.0) {
            res = 0.0;
        } else {
            double c = abs_a / abs_b;
            c *= c;
            res = abs_b * Math.sqrt(1.0 + c);
        }
        return res;
    }

    private void svbksb(double[][] u, double[] w, double[][] v, int m, int n) {
        double s;
        int j;
        double[] tmp = new double[n];
        for (j = 0; j < n; ++j) {
            s = 0.0;
            if (w[j] != 0.0) {
                for (int i = 0; i < m; ++i) {
                    s += u[i][j] * this.b[i];
                }
                s /= w[j];
            }
            tmp[j] = s;
        }
        for (j = 0; j < n; ++j) {
            s = 0.0;
            for (int jj = 0; jj < n; ++jj) {
                s += v[j][jj] * tmp[jj];
            }
            this.res[j] = s;
        }
    }

    private void svdfit() {
        int j;
        int i;
        double TOL = 1.0E-5;
        this.res = new double[this.n];
        this.a = new double[this.m][this.n];
        this.v = new double[this.n][this.n];
        this.w = new double[this.n];
        int ndata = this.m;
        int ma = this.n;
        this.b = new double[this.m];
        for (i = 0; i < ndata; ++i) {
            this.funcs(i);
            double tmp = 1.0 / this.sig[i];
            for (j = 0; j < ma; ++j) {
                this.a[i][j] = this.afunc[j] * tmp;
            }
            this.b[i] = this.Y[i] * tmp;
        }
        this.svdcmp();
        double wmax = 0.0;
        for (j = 0; j < ma; ++j) {
            if (!(this.w[j] > wmax)) continue;
            wmax = this.w[j];
        }
        double thresh = TOL * wmax;
        for (j = 0; j < ma; ++j) {
            if (!(this.w[j] < thresh)) continue;
            this.w[j] = 0.0;
        }
        this.svbksb(this.a, this.w, this.v, this.m, this.n);
        double chisq = 0.0;
        for (i = 0; i < ndata; ++i) {
            this.funcs(i);
            double sum = 0.0;
            for (j = 0; j < ma; ++j) {
                sum += this.res[j] * this.afunc[j];
            }
            double p = (this.Y[i] - sum) / this.sig[i];
            p *= p;
            chisq += p;
        }
    }

    private void funcs(int ind) {
        if (this.testCase) {
            // empty if block
        }
        for (int i = 0; i < this.n; ++i) {
            this.afunc[i] = this.mX[ind][i];
        }
    }

    private void setYValue(int indx, double yValue) {
        this.Y[indx] = yValue;
    }

    private void setYError(int indx, double yError) {
        this.sig[indx] = yError;
    }

    private void setMultyXValue(int rowIndx, int[] xValues) {
        for (int i = 0; i < this.n; ++i) {
            this.mX[rowIndx][i] = xValues[i];
        }
    }

    private void runMultyRegression() {
        this.svdfit();
        this.calcCovMatrix();
        this.se = this.calcStandardResidualError(this.m, this.n);
        this.calcErrorBoundsOfParameters(this.n, this.se);
        this.calcYStandardErrorOfModel(this.se);
    }

    public double[] getErrorVector() {
        return this.yStdError;
    }

    private double[] getFittedParameters() {
        return this.res;
    }

    public double getCovij(int i, int j) {
        return this.cov[i][j];
    }

    private void calcCovMatrix() {
        int i;
        double[] wti = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            wti[i] = 0.0;
            if (this.w[i] == 0.0) continue;
            wti[i] = 1.0 / (this.w[i] * this.w[i]);
        }
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double sum = 0.0;
                for (int k = 0; k < this.n; ++k) {
                    sum += this.v[i][k] * this.v[j][k] * wti[k];
                }
                this.cov[i][j] = sum;
                this.cov[j][i] = sum;
            }
        }
    }

    private void calcErrorBoundsOfParameters(int size, double se) {
        this.bounds = new double[size][2];
        this.pStd = new double[size];
        for (int i = 0; i < size; ++i) {
            this.pStd[i] = this.calcParameterStandarddError(i, se);
            this.bounds[i][0] = this.calcParameterLowerBound(this.res[i], this.pStd[i], size);
            this.bounds[i][1] = this.calcParameterUpperBound(this.res[i], this.pStd[i], size);
        }
    }

    private void calcYStandardErrorOfModel(double se) {
        this.yStdError = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.yStdError[i] = this.errorPredMethod == 1 ? SVDFitting.calcPredictionError(this.mX[i], se, this.cov, this.confL) : this.calcYStdError(this.mX[i]);
        }
    }

    private double getYpredicted(int indx) {
        double yp = 0.0;
        for (int i = 0; i < this.n; ++i) {
            yp += this.res[i] * this.mX[indx][i];
        }
        return yp;
    }

    private void printOutBasicInfo() {
        System.err.println(this.n + " " + this.m);
        System.err.println("SSY= " + this.SSY + " SSYp= " + this.SSYp + " SSE= " + this.SSE);
        System.err.println("Proportion of variation explained =    " + this.pve);
        System.err.println("Proportion of variation unexplained =    " + this.pvne);
    }

    private void printOut() {
        int i;
        System.err.println("SSY= " + this.SSY + " SSYp= " + this.SSYp + " SSE= " + this.SSE);
        System.err.println("Proportion of variation explained =    " + this.pve);
        System.err.println("Proportion of variation unexplained =    " + this.pvne);
        System.err.println("i\tpi\t\t\tsi\t\t\t\tpL\t\t\t\tpU");
        for (i = 0; i < this.n; ++i) {
            System.err.println(i + "\t" + this.res[i] + "\t" + this.pStd[i] + "\t" + this.bounds[i][0] + "\t" + this.bounds[i][1]);
        }
        System.err.println("i\tYexp\tYpred\tstandard error of prediction");
        for (i = 0; i < this.m; ++i) {
            System.err.println(i + "\t" + this.Y[i] + "\t" + this.getYpredicted(i) + "\t" + this.yStdError[i]);
        }
    }

    public static double calcPredictionError(double[] coefs, double se, double[][] cov, double confL) {
        double sum;
        int i;
        int size = coefs.length;
        double[] e = new double[size];
        for (i = 0; i < size; ++i) {
            sum = 0.0;
            for (int j = 0; j < size; ++j) {
                sum += coefs[j] * cov[j][i];
            }
            e[i] = sum;
        }
        sum = 0.0;
        for (i = 0; i < size; ++i) {
            sum += e[i] * coefs[i];
        }
        return SVDFitting.getStValue(size, confL) * se * Math.sqrt(1.0 + sum);
    }

    public int getErrorQuality(double[] coefs, double se, double ypred) {
        double q = SVDFitting.calcPredictionError(coefs, se, this.cov, this.confL);
        int size = coefs.length;
        double a = SVDFitting.getStValue(size, this.confL);
        double y = a * q / ypred;
        if (y <= 0.1) {
            return 10;
        }
        if (y > 0.1 && y <= 0.25) {
            return 9;
        }
        if (y > 0.25 && y <= 0.5) {
            return 6;
        }
        if (y > 0.5 && y <= 0.8) {
            return 4;
        }
        if (y > 0.8 && y <= 0.95) {
            return 2;
        }
        if (y > 0.95 && y <= 1.0) {
            return 1;
        }
        return 0;
    }

    private double calcYStdError(double[] coefs) {
        int size = coefs.length;
        double ystde = 0.0;
        double fL = 0.0;
        for (int i = 0; i < size; ++i) {
            fL += this.bounds[i][0] * coefs[i];
        }
        double fU = 0.0;
        for (int i = 0; i < size; ++i) {
            fU += this.bounds[i][1] * coefs[i];
        }
        double diff = fU - fL;
        ystde = 0.5 * diff / SVDFitting.getStValue(size, this.confL);
        return ystde;
    }

    private double calcParameterStandarddError(int pindx, double se) {
        return se * Math.sqrt(this.cov[pindx][pindx]);
    }

    private double calcParameterLowerBound(double pi, double si, int size) {
        double pL = pi - si * SVDFitting.getStValue(size, this.confL);
        return pL;
    }

    private double calcParameterUpperBound(double pi, double si, int size) {
        double pU = pi + si * SVDFitting.getStValue(size, this.confL);
        return pU;
    }

    private static double getStValue(int l, double confL) {
        if (confL == 90.0) {
            if (l > 121) {
                return 1.645;
            }
        } else if (confL == 95.0) {
            if (l > 121) {
                return 1.96;
            }
        } else if (confL == 98.0) {
            if (l > 121) {
                return 2.32;
            }
        } else if (confL == 99.0) {
            if (l > 121) {
                return 2.576;
            }
        } else if (confL == 99.9 && l > 121) {
            return 3.291;
        }
        return 2.0;
    }

    private double calcStandardResidualError(int rowCount, int columnCount) {
        double d;
        int j;
        double yp;
        int i;
        double s = 0.0;
        double meanY = 0.0;
        double meanYp = 0.0;
        for (i = 0; i < rowCount; ++i) {
            yp = 0.0;
            for (j = 0; j < columnCount; ++j) {
                yp += this.res[j] * this.mX[i][j];
            }
            d = this.Y[i] - yp;
            s += d * d;
            meanY += this.Y[i];
            meanYp += yp;
        }
        this.SSE = s;
        s /= (double)(rowCount - columnCount);
        s = Math.sqrt(s);
        meanY /= (double)rowCount;
        meanYp /= (double)rowCount;
        this.SSY = 0.0;
        for (i = 0; i < rowCount; ++i) {
            d = this.Y[i] - meanY;
            this.SSY += d * d;
        }
        this.SSYp = 0.0;
        for (i = 0; i < rowCount; ++i) {
            yp = 0.0;
            for (j = 0; j < columnCount; ++j) {
                yp += this.res[j] * this.mX[i][j];
            }
            d = yp - meanYp;
            this.SSYp += d * d;
        }
        this.pve = this.SSYp / this.SSY;
        this.pvne = this.SSE / this.SSY;
        return s;
    }
}

