/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.SVDFitting;

public class Stat {
    public static double pearsonR2(double[] x, double[] y) {
        double xMean = Stat.mean(x);
        double sSD = 0.0;
        double preSS = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sSD += (x[i] - xMean) * (x[i] - xMean);
            preSS += (y[i] - x[i]) * (y[i] - x[i]);
        }
        double r2 = 1.0 - preSS / sSD;
        return r2;
    }

    public static double pearsonR(double[] x, double[] y) {
        double meanX = Stat.mean(x);
        double meanY = Stat.mean(y);
        return Stat.pearsonR(x, meanX, y, meanY);
    }

    public static double pearsonR(double[] x, double meanX, double[] y, double meanY) {
        return Stat.covariance(x, meanX, y, meanY) / (Stat.variance(x, meanX) * Stat.variance(y, meanY));
    }

    public static double covariance(double[] v1, double[] v2) {
        return Stat.covariance(v1, Stat.mean(v1), v2, Stat.mean(v2));
    }

    public static double covariance(double[] v1, double mean1, double[] v2, double mean2) {
        int l = Math.min(v1.length, v2.length);
        double res = 0.0;
        for (int i = 0; i < l; ++i) {
            res += (v1[i] - mean1) * (v2[i] - mean2);
        }
        return res /= (double)(l - 1);
    }

    public static void autoScale(double[] v, double mean, double var) {
        if (Double.isNaN(mean)) {
            mean = Stat.mean(v);
        }
        if (Double.isNaN(var)) {
            var = Stat.variance(v, mean);
        }
        if (var == 0.0) {
            var = 1.0;
        }
        for (int i = 0; i < v.length; ++i) {
            v[i] = (v[i] - mean) / var;
        }
    }

    public static void autoScale(double[] v) {
        Stat.autoScale(v, Double.NaN, Double.NaN);
    }

    public static void central(double[] v) {
        double m = Stat.mean(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] - m;
        }
    }

    public static void scale(double[] v, double mean) {
        double s = Stat.variance(v, mean);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / s;
        }
    }

    public static double variance(double[] v) {
        return Stat.variance(v, Double.NaN);
    }

    public static double variance(double[] v, double mean) {
        if (v.length == 1) {
            return 0.0;
        }
        if (v.length == 0) {
            throw new UnsupportedOperationException("Calculating variance of a zero length vector.");
        }
        if (Double.isNaN(mean)) {
            mean = Stat.mean(v);
        }
        double s = 0.0;
        for (int i = 0; i < v.length; ++i) {
            s += (v[i] - mean) * (v[i] - mean);
        }
        return Math.sqrt(s /= (double)(v.length - 1));
    }

    public static double mean(double[] v) {
        if (v.length == 0) {
            throw new UnsupportedOperationException("Calculating mean of a zero length vector.");
        }
        double r = 0.0;
        for (int i = 0; i < v.length; ++i) {
            r += v[i];
        }
        return r /= (double)v.length;
    }

    public static double rMSDev(double[] x, double[] y) {
        double sD = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sD += (x[i] - y[i]) * (x[i] - y[i]);
        }
        sD = Math.sqrt(sD / (double)x.length);
        return sD;
    }

    public static double multiply(double[] vec1, double[] vec2) {
        return Stat.multiply(vec1, vec2, false);
    }

    public static double multiply(double[] vec1, double[] vec2, boolean ignoreNaN) {
        double[] fitted1 = vec1;
        double[] fitted2 = vec2;
        if (vec1.length < vec2.length) {
            fitted1 = Stat.fitToSize(vec1, vec2.length);
        } else if (vec2.length < vec1.length) {
            fitted2 = Stat.fitToSize(vec2, vec1.length);
        }
        double multiplication = 0.0;
        for (int i = 0; i < fitted1.length && (ignoreNaN || !Double.isNaN(multiplication)); ++i) {
            double mul = fitted1[i] * fitted2[i];
            boolean skip = ignoreNaN ? Double.isNaN(mul) : fitted1[i] == 0.0 || fitted2[i] == 0.0;
            multiplication += skip ? 0.0 : mul;
        }
        return multiplication;
    }

    public static double[] multiply(double[] vector, double scalar) {
        double[] result = new double[vector.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = vector[i] * scalar;
        }
        return result;
    }

    public static double[] sum(double[] vec1, double[] vec2) {
        double[] result = new double[vec1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = vec1[i] + vec2[i];
        }
        return result;
    }

    private static double[] fitToSize(double[] vec, int length) {
        if (vec.length >= length) {
            return vec;
        }
        double[] tmpVec = new double[length];
        System.arraycopy(vec, 0, tmpVec, 0, vec.length);
        return tmpVec;
    }

    public static double calcPredictionError(double[] coefs, double se, double confL, double[][] cov) {
        return SVDFitting.calcPredictionError(coefs, se, cov, confL);
    }
}

