/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training;

import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.Trainer;
import chemaxon.util.ConfigUtils;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TrainerUtils {
    public static final String BASE_PARAMETER_FOLDER_NAME = "calculations/training/";
    public static final String CONFIG_FOLDER_NAME = "config/";
    public static final String BASE_PARAMETER_FILE_SUFFIX = "data";
    private static final String STDERROR = "-- standard error --";
    private static final String COVMATRIX = "-- covariance matrix --";

    private TrainerUtils() {
    }

    public static final String[] getTrainingIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (File dir : TrainerUtils.getParameterFileFolders()) {
            list.addAll(TrainerUtils.getTrainingIds(dir, null));
        }
        return list.toArray(new String[list.size()]);
    }

    private static File[] getParameterFileFolders() {
        File[] fileArray;
        String mpath = ConfigUtils.searchFileInMarvinPackageDir("config/calculations/training/");
        if (mpath != null) {
            File[] fileArray2 = new File[2];
            fileArray2[0] = DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME);
            fileArray = fileArray2;
            fileArray2[1] = new File(mpath);
        } else {
            File[] fileArray3 = new File[1];
            fileArray = fileArray3;
            fileArray3[0] = DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME);
        }
        return fileArray;
    }

    private static final List<String> getTrainingIds(File baseParameterFolder, String location) {
        File[] directories;
        ArrayList<String> list = new ArrayList<String>();
        if (baseParameterFolder == null || !baseParameterFolder.isDirectory()) {
            return list;
        }
        File[] files = baseParameterFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && f.getName().contains(".") && f.getName().endsWith(TrainerUtils.BASE_PARAMETER_FILE_SUFFIX);
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                int index = files[i].getName().lastIndexOf(".");
                String name = files[i].getName().substring(0, index);
                String type = files[i].getName().replaceFirst("data$", "").substring(index + 1);
                list.add((type.equals("") ? "" : type + ":") + (location == null ? "" : location + "/") + name);
            }
        }
        if ((directories = baseParameterFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (int i = 0; i < directories.length; ++i) {
                list.addAll(TrainerUtils.getTrainingIds(directories[i], (location == null ? "" : location + "/") + directories[i].getName()));
            }
        }
        return list;
    }

    public static final File[] getParameterFiles(String trainingType) {
        File[] IJCFiles = TrainerUtils.getIJCParameterFiles(trainingType);
        File[] nonIJCFiles = TrainerUtils.getNonIJCParameterFiles(trainingType);
        File[] result = new File[IJCFiles.length + nonIJCFiles.length];
        System.arraycopy(IJCFiles, 0, result, 0, IJCFiles.length);
        System.arraycopy(nonIJCFiles, 0, result, IJCFiles.length, nonIJCFiles.length);
        return result;
    }

    public static final File[] getIJCParameterFiles(String trainingType) {
        return TrainerUtils.getIJCParameterFiles(trainingType, null);
    }

    public static final File[] getIJCParameterFiles(String trainingType, final String projectName) {
        final String type = trainingType == null ? null : trainingType.toLowerCase();
        ArrayList<File> list = new ArrayList<File>();
        File[] projectDirectories = DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return projectName == null || name.endsWith(projectName.toLowerCase());
            }
        });
        if (projectDirectories != null) {
            for (int i = 0; i < projectDirectories.length; ++i) {
                if (!projectDirectories[i].isDirectory()) continue;
                File[] parameterFiles = projectDirectories[i].listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(type == null ? TrainerUtils.BASE_PARAMETER_FILE_SUFFIX : "." + type + TrainerUtils.BASE_PARAMETER_FILE_SUFFIX);
                    }
                });
                for (int j = 0; j < parameterFiles.length; ++j) {
                    list.add(parameterFiles[j]);
                }
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static final File[] getNonIJCParameterFiles(String trainingType) {
        String type = trainingType == null ? null : trainingType.toLowerCase();
        ArrayList<File> list = new ArrayList<File>();
        for (File dir : TrainerUtils.getParameterFileFolders()) {
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory() || !files[i].getName().endsWith(type == null ? BASE_PARAMETER_FILE_SUFFIX : "." + type + BASE_PARAMETER_FILE_SUFFIX)) continue;
                list.add(files[i]);
            }
        }
        return list.toArray(new File[list.size()]);
    }

    public static final SVDTrainingResult loadParameters(String trainingId) throws IOException {
        String projectName = trainingId.lastIndexOf("[") != -1 && trainingId.lastIndexOf("]") != -1 ? trainingId.substring(trainingId.lastIndexOf("[") + 1, trainingId.lastIndexOf("]")) : "";
        String[] sa = trainingId.split(":");
        String trainingType = sa.length == 2 ? sa[0] : "";
        String trainingName = sa.length == 2 ? sa[1] : sa[0];
        return TrainerUtils.loadParameters(trainingType, projectName + File.separator + trainingName);
    }

    public static final SVDTrainingResult loadParameters(String trainingType, String projectName, String trainingName) throws IOException {
        return TrainerUtils.loadParameters(trainingType, projectName + File.separator + trainingName);
    }

    public static final SVDTrainingResult loadParameters(String trainingType, String trainingName) throws IOException {
        int i;
        File baseParameterFolder;
        File[] directories;
        String type = trainingType.toLowerCase();
        File parameterFile = new File(DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME).getAbsolutePath() + File.separator + trainingName.toLowerCase() + "." + type + BASE_PARAMETER_FILE_SUFFIX);
        if (!parameterFile.exists() && (directories = (baseParameterFolder = DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) != null) {
            for (int i2 = 0; i2 < directories.length && !(parameterFile = new File(DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME).getAbsolutePath() + File.separator + directories[i2].getName() + File.separator + trainingName.toLowerCase() + "." + type + BASE_PARAMETER_FILE_SUFFIX)).exists(); ++i2) {
            }
        }
        if (!parameterFile.exists()) {
            File baseParameterFolder2;
            File[] directories2;
            String baseParameterFolderName;
            String parameterFileName = ConfigUtils.searchFileInMarvinPackageDir("config/calculations/training//" + trainingName.toLowerCase() + "." + type + BASE_PARAMETER_FILE_SUFFIX);
            if (parameterFileName != null) {
                parameterFile = new File(parameterFileName);
            }
            if (!parameterFile.exists() && (baseParameterFolderName = ConfigUtils.searchFileInMarvinPackageDir("config/calculations/training/")) != null && (directories2 = (baseParameterFolder2 = new File(baseParameterFolderName)).listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) != null) {
                for (i = 0; i < directories2.length; ++i) {
                    parameterFileName = ConfigUtils.searchFileInMarvinPackageDir("config/calculations/training//" + directories2[i].getName() + "/" + trainingName.toLowerCase() + "." + type + BASE_PARAMETER_FILE_SUFFIX);
                    if (parameterFileName != null) {
                        parameterFile = new File(parameterFileName);
                    }
                    if (parameterFile.exists()) break;
                }
            }
        }
        if (parameterFile.canRead()) {
            ArrayList<Double> list = new ArrayList<Double>();
            BufferedReader reader = new BufferedReader(new FileReader(parameterFile));
            String line = reader.readLine();
            while (line != null && !line.startsWith("--")) {
                double data = Double.NaN;
                try {
                    data = Double.parseDouble(line);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                list.add(data);
                line = reader.readLine();
            }
            double[] coefficient = new double[list.size()];
            for (i = 0; i < list.size(); ++i) {
                coefficient[i] = (Double)list.get(i);
            }
            SVDTrainingResult result = new SVDTrainingResult(coefficient);
            if (line != null && line.equalsIgnoreCase(STDERROR)) {
                line = reader.readLine();
                try {
                    double data = Double.parseDouble(line);
                    result.setStandardError(data);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                line = reader.readLine();
            }
            if (line != null && line.equalsIgnoreCase(COVMATRIX)) {
                ArrayList<double[]> matrix = new ArrayList<double[]>();
                line = reader.readLine();
                while (line != null) {
                    String[] data = line.split(" ");
                    double[] row = new double[data.length];
                    for (int i3 = 0; i3 < row.length; ++i3) {
                        double num = Double.NaN;
                        try {
                            num = Double.parseDouble(data[i3]);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        row[i3] = num;
                    }
                    matrix.add(row);
                    line = reader.readLine();
                }
                double[][] covMatrix = new double[matrix.size()][];
                for (int i4 = 0; i4 < matrix.size(); ++i4) {
                    covMatrix[i4] = (double[])matrix.get(i4);
                }
                result.setMatrix(covMatrix);
            }
            reader.close();
            return result;
        }
        throw new IOException("Can not open parameter file: " + parameterFile.getAbsolutePath());
    }

    public static final void saveParameters(String trainingType, String projectName, String trainingName, Trainer<?, double[]> trainer) throws IOException {
        TrainerUtils.saveParameters(trainingType, projectName + File.separator + trainingName, trainer.getResults());
    }

    public static final void saveParameters(String trainingType, String trainingName, Trainer<?, SVDTrainingResult> trainer) throws IOException {
        TrainerUtils.saveParameters(trainingType, trainingName, trainer.getResults().getCoefficient(), trainer.getResults().getMatrix(), trainer.getResults().getStandardError());
    }

    public static final void saveParameters(String trainingType, String projectName, String trainingName, double[] parameters) throws IOException {
        TrainerUtils.saveParameters(trainingType, projectName + File.separator + trainingName, parameters);
    }

    public static final void saveParameters(String trainingType, String trainingName, double[] parameters) throws IOException {
        TrainerUtils.saveParameters(trainingType, trainingName, parameters, null, Double.NaN);
    }

    public static final void saveParameters(String trainingType, String trainingName, double[] parameters, double[][] covarianceMatrix, double stdError) throws IOException {
        String type = trainingType.toLowerCase();
        File parameterFile = new File(DotfileUtil.getDotFile(BASE_PARAMETER_FOLDER_NAME).getAbsolutePath() + File.separator + trainingName.toLowerCase() + "." + type + BASE_PARAMETER_FILE_SUFFIX);
        parameterFile.getParentFile().mkdirs();
        parameterFile.createNewFile();
        if (parameters != null) {
            int i;
            PrintWriter writer = new PrintWriter(parameterFile);
            for (i = 0; i < parameters.length; ++i) {
                writer.println(parameters[i]);
            }
            if (!Double.isNaN(stdError)) {
                writer.println(STDERROR);
                writer.println(stdError);
            }
            if (covarianceMatrix != null) {
                writer.println(COVMATRIX);
                for (i = 0; i < covarianceMatrix.length; ++i) {
                    for (int j = 0; j < covarianceMatrix.length; ++j) {
                        writer.print(covarianceMatrix[i][j] + " ");
                    }
                    writer.println();
                }
            }
            writer.close();
        }
    }
}

