/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.Tautomerization;
import chemaxon.calculations.pka.Ionizer;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.logp.LogPPredictor;
import chemaxon.calculations.training.logp.LogPPredictorImpl;
import chemaxon.struc.Molecule;

public class LogDPredictor {
    private Molecule mol;
    private Molecule molCopy = null;
    private Tautomerization tautomer;
    private LogPPredictorImpl atomiclogP;
    public double pHLower = 0.0;
    public double pHUpper = 14.0;
    public double pHStepSize = 1.0;
    private double[] pHPoints = null;
    private double ln10 = 2.302585092994046;
    public double[] pHlogD = null;
    public int pHStepCount;
    private boolean newCalc;
    private int ionCount;
    private double cAnion = 0.1;
    private double cKation = 0.1;
    boolean aromaticAzaError;
    int[] io;
    double[] bpKa = null;
    double[] apKa = null;
    boolean takeTautomers = false;
    private String pKaCorrectionLibraryId = null;
    double weightVG = 0.3333333333333333;
    double weightKLOP = 0.3333333333333333;
    double weightPHYS = 0.3333333333333333;
    double weightUSER = 0.0;
    double[] msplogP;
    boolean newMspSetDefined;
    protected Ionizer ionizer = null;
    SVDTrainingResult userResults = null;

    public LogDPredictor() {
    }

    public LogDPredictor(Molecule m) {
        this.setMolecule(m);
    }

    public void setMolecule(Molecule m) {
        this.mol = m;
        this.newCalc = true;
    }

    public void setpKaCorrectionLibrary(String pKaCorrectionLibraryId) {
        this.pKaCorrectionLibraryId = pKaCorrectionLibraryId;
    }

    public void setWeightOflogPMethods(double wVG, double wKLOP, double wPHYS, double wUSER) {
        this.weightVG = wVG;
        this.weightKLOP = wKLOP;
        this.weightPHYS = wPHYS;
        this.weightUSER = wUSER;
    }

    public void setTakeTautomerizaiton(boolean logdTau) {
        this.takeTautomers = logdTau;
    }

    public boolean getCriticalErrorFlag() {
        return this.ionizer != null && this.ionizer.getCriticalErrorFlag();
    }

    public void setCloridIonConcentration(double anion) {
        this.cAnion = anion;
    }

    public void setNaKIonConcentration(double kation) {
        this.cKation = kation;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    public void setpHLowerLimit(double pHL) {
        this.pHLower = pHL;
    }

    public void setpHUpperLimit(double pHU) {
        this.pHUpper = pHU;
    }

    public void setpHStepSize(double Step) {
        this.pHStepSize = Step;
    }

    public double getpHLowerLimit() {
        return this.pHLower;
    }

    public double getpHUpperLimit() {
        return this.pHUpper;
    }

    public double getpHStepSize() {
        return this.pHStepSize;
    }

    public int getpHStepCount() {
        return this.pHStepCount;
    }

    public double[] getpH() {
        return this.pHPoints;
    }

    private void setpH() {
        double dpH = this.pHUpper - this.pHLower;
        this.pHStepCount = this.pHStepSize > dpH || this.pHStepSize == 0.0 ? 0 : (int)Math.round(dpH / this.pHStepSize);
        this.pHPoints = new double[this.pHStepCount + 1];
        for (int i = 0; i <= this.pHStepCount; ++i) {
            this.pHPoints[i] = this.pHLower + (double)i * this.pHStepSize;
        }
    }

    public double[] getlogD() {
        return this.pHlogD;
    }

    public boolean getAromaticAzaError() {
        return this.aromaticAzaError;
    }

    public void calclogD() {
        this.setpH();
        this.pHlogD = new double[this.pHStepCount + 1];
        if (this.takeTautomers) {
            for (int i = 0; i <= this.pHStepCount; ++i) {
                this.pHlogD[i] = this.calcTautomericLogD(this.pHPoints[i]);
            }
            return;
        }
        if (this.newCalc) {
            this.atomiclogP = new LogPPredictorImpl();
            this.atomiclogP.setTrainingResults(this.userResults);
            this.atomiclogP.setWeightOfMethods(this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER);
            this.ionizer = new Ionizer();
            this.atomiclogP.setIonizer(this.ionizer);
            this.ionizer.setpKaPrefixType(1);
            this.molCopy = this.mol.cloneMoleculeWithDocument();
            this.ionizer.setMolecule(this.molCopy);
            this.ionizer.setCorrectionLibrary(this.pKaCorrectionLibraryId);
            this.ionizer.calcMicroSpecies();
            this.ionCount = this.ionizer.getIonizableAtomCount();
            this.aromaticAzaError = this.ionizer.getAromaticAzaError();
            this.newCalc = false;
            this.atomiclogP.setCloridIonConcentration(this.cAnion);
            this.atomiclogP.setNaKIonConcentration(this.cKation);
        } else {
            this.atomiclogP.setIonizer(this.ionizer);
        }
        if (this.ionCount != 0) {
            this.ionizer.setlogDFlag(true);
            this.ionizer.calcMsDistribution(this.pHLower);
            this.calcNewMicroSpecSet(this.pHLower);
            this.storeMslogP();
            this.setpHlogDPoint(0);
            for (int j = 1; j <= this.pHStepCount; ++j) {
                this.calcNewMicroSpecSet(this.pHPoints[j]);
                if (this.newMspSetDefined) {
                    this.storeMslogP();
                }
                this.ionizer.recalcSpeciesOrder(this.pHPoints[j]);
                this.ionizer.calcMsDistribution(this.pHPoints[j]);
                this.setpHlogDPoint(j);
            }
            this.ionizer.setDefaultMajpH();
            this.ionizer.setlogDFlag(false);
        } else if (this.ionCount == 0) {
            this.atomiclogP.setIonizer(this.ionizer);
            this.atomiclogP.setLogPMethod(LogPPredictor.MethodType.IONIC);
            double logP = this.atomiclogP.predict(this.molCopy);
            for (int j = 0; j <= this.pHStepCount; ++j) {
                this.pHlogD[j] = logP;
            }
        }
    }

    public double[] predict(Molecule molecule) {
        this.setMolecule(molecule);
        this.calclogD();
        return this.getlogD();
    }

    public double predict(Molecule molecule, double pH) {
        this.setMolecule(molecule);
        return this.calclogDatFixpH(pH);
    }

    public void setLogPTrainingResults(SVDTrainingResult results) {
        this.userResults = results;
    }

    private void storeMslogP() {
        int msCount = this.ionizer.getMicroSpeciesCount();
        this.msplogP = new double[msCount];
        for (int i = 0; i < msCount; ++i) {
            double logP;
            Molecule microSpecies = this.ionizer.getMicroSpecies(i);
            this.atomiclogP.setIonizer(this.ionizer);
            this.atomiclogP.setLogPMethod(LogPPredictor.MethodType.IONIC);
            this.msplogP[i] = logP = this.atomiclogP.predict(microSpecies);
        }
    }

    public double calclogDatFixpH(double pH) {
        double logD = 0.0;
        if (this.takeTautomers) {
            logD = this.calcTautomericLogD(pH);
            return logD;
        }
        if (this.newCalc) {
            this.pHLower = pH;
            this.atomiclogP = new LogPPredictorImpl();
            this.atomiclogP.setTrainingResults(this.userResults);
            this.atomiclogP.setWeightOfMethods(this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER);
            this.ionizer = new Ionizer();
            this.atomiclogP.setIonizer(this.ionizer);
            this.ionizer.setpKaPrefixType(1);
            this.molCopy = this.mol.cloneMoleculeWithDocument();
            this.ionizer.setMolecule(this.molCopy);
            this.ionizer.setCorrectionLibrary(this.pKaCorrectionLibraryId);
            this.ionizer.calcMicroSpecies();
            this.ionCount = this.ionizer.getIonizableAtomCount();
            this.aromaticAzaError = this.ionizer.getAromaticAzaError();
            this.newCalc = false;
            this.atomiclogP.setCloridIonConcentration(this.cAnion);
            this.atomiclogP.setNaKIonConcentration(this.cKation);
        } else {
            this.atomiclogP.setIonizer(this.ionizer);
        }
        if (this.ionCount != 0) {
            this.ionizer.setlogDFlag(true);
            if (!this.ionizer.speciesDistribution) {
                this.ionizer.calcMsDistribution(pH);
                this.calcNewMicroSpecSet(pH);
                this.storeMslogP();
            } else {
                this.calcNewMicroSpecSet(pH);
                if (this.newMspSetDefined) {
                    this.storeMslogP();
                }
                this.ionizer.recalcSpeciesOrder(pH);
                this.ionizer.calcMsDistribution(pH);
            }
            logD = this.computelogD();
            this.ionizer.setlogDFlag(false);
        } else if (this.ionCount == 0) {
            this.atomiclogP.setIonizer(this.ionizer);
            this.atomiclogP.setLogPMethod(LogPPredictor.MethodType.IONIC);
            logD = this.atomiclogP.predict(this.molCopy);
        }
        return logD;
    }

    private void setpHlogDPoint(int count) {
        this.pHlogD[count] = this.computelogD();
    }

    private double computelogD() {
        int msCount = this.ionizer.getMicroSpeciesCount();
        double N = 0.0;
        double D = 0.0;
        for (int i = 0; i < msCount; ++i) {
            double logP = this.msplogP[i];
            double P = Math.pow(10.0, logP);
            double msdist = this.ionizer.getMsDist(i);
            N += P * msdist;
            D += msdist;
        }
        double lD = Math.log(N / D);
        return lD /= this.ln10;
    }

    private boolean isNewpKaCalc(double actpH) {
        int i;
        if (actpH == this.pHLower) {
            this.io = new int[this.ionCount];
            this.io = this.ionizer.getIonizableAtoms();
            this.ionizer.calcpKa(0.0);
            this.ionizer.recalcSpeciesOrder(actpH);
            this.ionizer.calcMsDistribution(actpH);
            this.bpKa = new double[this.ionCount];
            this.apKa = new double[this.ionCount];
            for (i = 0; i < this.ionCount; ++i) {
                this.bpKa[i] = Double.NaN;
                this.apKa[i] = Double.NaN;
                this.bpKa[i] = this.ionizer.getpKa(this.io[i], 1);
                this.apKa[i] = this.ionizer.getpKa(this.io[i], -1);
            }
        }
        for (i = 0; i < this.ionCount; ++i) {
            double d2;
            double d1;
            if (Double.isNaN(this.bpKa[i]) || Double.isNaN(this.apKa[i]) || !((d1 = 2.0 * actpH - (this.bpKa[i] + this.apKa[i])) * (d2 = 2.0 * this.ionizer.getMajorpH() - (this.bpKa[i] + this.apKa[i])) < 0.0) || !(Math.abs(this.bpKa[i] - this.apKa[i]) < 12.0)) continue;
            this.ionizer.setMajorpH(actpH);
            return true;
        }
        return false;
    }

    private void calcNewMicroSpecSet(double pH) {
        this.newMspSetDefined = false;
        if (this.isNewpKaCalc(pH)) {
            this.molCopy = this.mol.cloneMoleculeWithDocument();
            this.ionizer.setMolecule(this.molCopy);
            this.ionizer.calcMicroSpecies();
            this.ionizer.calcMsDistribution(pH);
            this.newMspSetDefined = true;
        }
    }

    private double calcTautomericLogD(double ph) {
        this.tautomer = new Tautomerization();
        this.molCopy = this.mol.cloneMoleculeWithDocument();
        this.molCopy.dearomatize();
        this.molCopy.aromatize(2);
        this.tautomer.setMolecule(this.molCopy);
        this.tautomer.setTakeDominantTautomers(true);
        this.tautomer.setpH(ph);
        this.tautomer.calcDominantTautomerDistribution();
        int msCount = this.tautomer.getTCount();
        double logP = 0.0;
        double P = 0.0;
        this.atomiclogP = new LogPPredictorImpl();
        this.atomiclogP.setTrainingResults(this.userResults);
        this.atomiclogP.setWeightOfMethods(this.weightVG, this.weightKLOP, this.weightPHYS, this.weightUSER);
        double N = 0.0;
        double D = 0.0;
        double lD = Double.NaN;
        for (int i = 0; i < msCount; ++i) {
            Molecule msp = this.tautomer.getTMolecule(i);
            double msdist = this.tautomer.getTauDistribution(i);
            msp.aromatize(1);
            if (!(msdist > 0.1)) continue;
            this.atomiclogP.setLogPMethod(LogPPredictor.MethodType.IONIC);
            logP = this.atomiclogP.predict(msp);
            P = Math.pow(10.0, logP);
            N += P * msdist;
            D += msdist;
        }
        lD = Math.log(N / D);
        return lD /= this.ln10;
    }
}

