/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.logp;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.FullMatrix;
import chemaxon.calculations.training.SVDFitting;
import chemaxon.calculations.training.SVDTrainingResult;
import chemaxon.calculations.training.logp.LogPTrainer;
import chemaxon.calculations.training.logp.LogPUserModel;
import java.beans.PropertyChangeListener;

public class LogPTrainerFactory {
    public static final LogPTrainer createLogPTrainer() {
        return LogPTrainerFactory.createLogPTrainer((PropertyChangeListener)null);
    }

    public static final LogPTrainer createLogPTrainer(int threads) {
        SVDFitting algorithm = new SVDFitting();
        FullMatrix matrix = new FullMatrix(300);
        return LogPTrainerFactory.createLogPTrainer(algorithm, matrix, null, threads);
    }

    public static final LogPTrainer createLogPTrainer(PropertyChangeListener progressListener) {
        return LogPTrainerFactory.createLogPTrainer((FittingAlgorithm<SVDTrainingResult>)new SVDFitting(), progressListener);
    }

    public static final LogPTrainer createLogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm) {
        return LogPTrainerFactory.createLogPTrainer(algorithm, (PropertyChangeListener)null);
    }

    public static final LogPTrainer createLogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, PropertyChangeListener progressListener) {
        return LogPTrainerFactory.createLogPTrainer(algorithm, new FullMatrix(300), progressListener);
    }

    public static final LogPTrainer createLogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix matrix) {
        return LogPTrainerFactory.createLogPTrainer(algorithm, matrix, null);
    }

    public static final LogPTrainer createLogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix matrix, PropertyChangeListener progressListener) {
        return LogPTrainerFactory.createLogPTrainer(algorithm, matrix, progressListener, Runtime.getRuntime().availableProcessors());
    }

    public static final LogPTrainer createLogPTrainer(FittingAlgorithm<SVDTrainingResult> algorithm, DescriptorMatrix matrix, PropertyChangeListener progressListener, int threads) {
        LogPUserModel[] models = new LogPUserModel[Math.max(threads, 1)];
        for (int i = 0; i < models.length; ++i) {
            models[i] = new LogPUserModel();
        }
        LogPTrainer trainer = new LogPTrainer(algorithm, matrix, models);
        if (progressListener != null) {
            trainer.addPropertyChangeListener("Progress", progressListener);
        }
        return trainer;
    }
}

