/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pflr;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.pflr.PFLRResult;

public class PFLRFittingAlgorithm
implements FittingAlgorithm<PFLRResult> {
    double[][] descriptors;
    double[] expValues;
    private float prog;
    private int verbose;
    private boolean calcNeeded;
    private PFLRResult result;

    public PFLRFittingAlgorithm() {
        this.prog = 0.0f;
        this.verbose = 0;
        this.calcNeeded = false;
    }

    public PFLRFittingAlgorithm(DescriptorMatrix m, double[] values) {
        this.setDescriptorMatrix(m);
        this.setExperimentalValues(values);
        this.prog = 0.0f;
        this.verbose = 0;
        this.calcNeeded = true;
    }

    public void setVerboseLevel(int v) {
        this.verbose = v;
    }

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        this.descriptors = new double[matrix.getRowCount()][];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = new double[matrix.getColumnCount()];
            System.arraycopy(matrix.getRow(i), 0, this.descriptors[i], 0, matrix.getColumnCount());
            this.prog = (float)i / (float)this.descriptors.length;
        }
        this.calcNeeded = true;
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.expValues = new double[values.length];
        System.arraycopy(values, 0, this.expValues, 0, values.length);
        this.calcNeeded = true;
    }

    @Override
    public PFLRResult getResult() {
        if (this.calcNeeded) {
            this.result = new PFLRResult(this.descriptors, this.expValues);
        }
        return this.result;
    }

    @Override
    public float getProgress() {
        return this.prog;
    }
}

