/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pflr;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.Stat;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import java.util.BitSet;

public class PFLRUtil {
    protected static void findClosestVectors(double[][] vectorSet, double[] currentVector, double[][] closestVectors, int[] closestVectorsIndexes, boolean leaveSelfOut, BitSet selected) {
        double[] distances = new double[vectorSet.length];
        int[] indexes = new int[vectorSet.length];
        for (int i = 0; i < vectorSet.length; ++i) {
            double[] distVect = selected == null ? JLinAlg.vectSubtract(currentVector, vectorSet[i]) : JLinAlg.vectSubtract(currentVector, vectorSet[i], selected);
            distances[i] = JLinAlg.VDot(distVect, distVect);
            indexes[i] = i;
        }
        int len = leaveSelfOut ? closestVectors.length + 1 : closestVectors.length;
        for (int i = 0; i < len; ++i) {
            int index_of_min = i;
            for (int y = i; y < distances.length; ++y) {
                if (!(distances[index_of_min] > distances[y])) continue;
                index_of_min = y;
            }
            double temp = distances[i];
            distances[i] = distances[index_of_min];
            distances[index_of_min] = temp;
            int ttmp = indexes[i];
            indexes[i] = indexes[index_of_min];
            indexes[index_of_min] = ttmp;
        }
        int shift = 0;
        for (int i = 0; i < closestVectors.length; ++i) {
            if (leaveSelfOut && distances[i] == 0.0) {
                ++shift;
            }
            closestVectors[i] = vectorSet[indexes[i + shift]];
            closestVectorsIndexes[i] = indexes[i + shift];
        }
    }

    public static void scaleTestMatrixWithTrainMatrix(DescriptorMatrix train, DescriptorMatrix test) {
        for (int col = 0; col < train.getColumnCount(); ++col) {
            double[] v = new double[train.getRowCount()];
            for (int row = 0; row < train.getRowCount(); ++row) {
                v[row] = train.getValueAt(row, col);
            }
            double mean = Stat.mean(v);
            double var = Stat.variance(v, mean);
            for (int row = 0; row < test.getRowCount(); ++row) {
                double scaled = (test.getValueAt(row, col) - mean) / var;
                test.setValueAt(row, col, scaled);
            }
        }
    }
}

