/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pls;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.Stat;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import java.util.BitSet;

public class PLSFittingAlgorithm
implements FittingAlgorithm<double[]> {
    private JLinAlg.Matrix X;
    private double[] Y;
    private boolean calcneeded;
    private double[] result;
    private float progress;
    private int maxComponents;
    private double stopVal;

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void setMaxComponents(int maxComponents) {
        this.maxComponents = maxComponents;
    }

    public double getStopVal() {
        return this.stopVal;
    }

    public void setStopVal(double stopVal) {
        this.stopVal = stopVal;
    }

    public PLSFittingAlgorithm() {
        this.calcneeded = true;
        this.result = null;
        this.progress = 0.0f;
        this.stopVal = 1.0E-4;
    }

    public PLSFittingAlgorithm(double[][] desc, double[] expVal) {
        this.X = new JLinAlg.Matrix(desc);
        this.setExperimentalValues(expVal);
        this.calcneeded = true;
        this.maxComponents = this.X.nCols;
        this.stopVal = 1.0E-4;
    }

    private void regress() {
        int stop;
        double[] Xmean = new double[this.X.getRow(0).length];
        double[] Xvar = new double[this.X.getRow(0).length];
        for (int i = 0; i < this.X.nCols; ++i) {
            double[] v = this.X.getCol(i);
            Xmean[i] = Stat.mean(this.X.getCol(i));
            Xvar[i] = Stat.variance(this.X.getCol(i));
            Stat.autoScale(v, Xmean[i], Xvar[i]);
            for (int j = 0; j < v.length; ++j) {
                this.X.setElement(j, i, v[j]);
            }
        }
        double Ymean = Stat.mean(this.Y);
        double Yvar = Stat.variance(this.Y);
        Stat.autoScale(this.Y, Ymean, Yvar);
        JLinAlg.Matrix S = JLinAlg.mtMMultiply(this.X, this.X);
        S.reDiagonalize(1.0E-10);
        S.checkRank();
        JLinAlg.Matrix Score = JLinAlg.mMtMultiply(this.X, S.aREV);
        double[] yl = JLinAlg.VectCopy(this.Y);
        double[] a = new double[Score.nCols];
        int l = 0;
        BitSet bs = new BitSet(Score.nCols);
        double origSqrtVDot = Math.sqrt(JLinAlg.VDot(this.Y, this.Y));
        double runingSqrtVDot = Math.sqrt(JLinAlg.VDot(yl, yl));
        int[] descriptorPref = new int[Score.nCols];
        int n = stop = this.maxComponents < Score.nCols ? this.maxComponents : Score.nCols - 1;
        while (runingSqrtVDot / origSqrtVDot > this.stopVal && l <= stop) {
            double max = -1.0;
            int maxi = -1;
            for (int i = 0; i < Score.nCols; ++i) {
                if (bs.get(i)) continue;
                double bottom = Math.sqrt(JLinAlg.VDot(Score.getCol(i), Score.getCol(i)) * JLinAlg.VDot(yl, yl));
                double top = JLinAlg.VDot(Score.getCol(i), yl);
                double x = Math.abs(top / bottom);
                if (!(x > max)) continue;
                max = x;
                maxi = i;
            }
            if (maxi > -1) {
                descriptorPref[l] = maxi;
                bs.set(maxi);
                double[] xi = Score.getCol(maxi);
                a[maxi] = JLinAlg.VDot(xi, yl) / JLinAlg.VDot(xi, xi);
                for (int i = 0; i < yl.length; ++i) {
                    yl[i] = yl[i] - a[maxi] * xi[i];
                }
                ++l;
                runingSqrtVDot = Math.sqrt(JLinAlg.VDot(yl, yl));
                continue;
            }
            l = Score.nCols;
        }
        double[][] rev = JLinAlg.cpMatrixDB(S.aREV);
        double[] coeff = JLinAlg.VLinComb(a, rev, null);
        this.calcneeded = false;
        this.result = new double[coeff.length + 1];
        double constant = 0.0;
        for (int i = 0; i < coeff.length; ++i) {
            if (Xvar[i] == 0.0) {
                this.result[i] = 0.0;
                continue;
            }
            this.result[i] = coeff[i] * Yvar / Xvar[i];
            if (!Double.isNaN(this.result[i]) && !Double.isNaN(constant += Xmean[i] * coeff[i] / Xvar[i])) continue;
            throw new RuntimeException(i + " " + coeff[i] + " " + Xvar[i]);
        }
        constant *= -Yvar;
        this.result[this.result.length - 1] = constant += Ymean;
    }

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        double[][] t = new double[matrix.getRowCount()][matrix.getColumnCount()];
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[i].length; ++j) {
                t[i][j] = matrix.getValueAt(i, j);
            }
        }
        this.X = new JLinAlg.Matrix(t);
        this.calcneeded = true;
    }

    protected void setMatrix(JLinAlg.Matrix matrix) {
        this.X = matrix;
        this.calcneeded = true;
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.Y = JLinAlg.VectCopy(values);
        this.calcneeded = true;
    }

    @Override
    public double[] getResult() {
        if (this.calcneeded) {
            this.regress();
        }
        return this.result;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }
}

