/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.pls;

import chemaxon.calculations.training.Stat;
import chemaxon.calculations.training.pls.PLSFittingAlgorithm;
import chemaxon.calculations.training.pls.PLSPredictionAlgorithm;
import java.util.BitSet;

public class PLSUtil {
    public static double[] predict(PLSPredictionAlgorithm predictor, double[][] descriptorMatrix) {
        double[] result = new double[descriptorMatrix.length];
        for (int i = 0; i < descriptorMatrix.length; ++i) {
            result[i] = predictor.predict(descriptorMatrix[i]);
        }
        return result;
    }

    public static double calculateQ2(double[][] descriptorMatrix, double[] activity) {
        return PLSUtil.calculateQ2(descriptorMatrix, activity, false);
    }

    protected static double calculateQ2(double[][] descriptorMatrix, double[] activity, boolean debug) {
        if (descriptorMatrix.length < 2) {
            throw new IllegalArgumentException("DescriptorMatrix should contain at least 2 rows.");
        }
        if (descriptorMatrix.length != activity.length) {
            throw new IllegalArgumentException("DescriptorMatrix and Activity array length differs.");
        }
        double[][] runningDescriptorMatrix = new double[descriptorMatrix.length - 1][descriptorMatrix[0].length];
        double[] runningActivity = new double[activity.length - 1];
        System.arraycopy(activity, 1, runningActivity, 0, runningActivity.length);
        double[] predictions = new double[activity.length];
        int maxComponents = (int)((double)descriptorMatrix[0].length * 0.6);
        for (int i = 0; i < descriptorMatrix.length; ++i) {
            double[] runningVector = descriptorMatrix[i];
            PLSUtil.copyLeaveI(descriptorMatrix, i, runningDescriptorMatrix);
            System.arraycopy(activity, 0, runningActivity, 0, i);
            PLSFittingAlgorithm pls = new PLSFittingAlgorithm(runningDescriptorMatrix, runningActivity);
            pls.setMaxComponents(maxComponents);
            PLSPredictionAlgorithm plsPred = new PLSPredictionAlgorithm();
            plsPred.setCoefficients(pls.getResult());
            if (debug) {
                System.err.print(",");
            }
            predictions[i] = plsPred.predict(runningVector);
        }
        if (debug) {
            System.err.print("\n");
        }
        double q2 = Stat.pearsonR2(predictions, activity);
        return q2;
    }

    private static void copyLeaveI(double[][] sourceMatrix, int rowIndexToLeave, double[][] targetMatrix) {
        if (sourceMatrix.length - 1 != targetMatrix.length) {
            throw new IllegalArgumentException("Target matrix size error.");
        }
        int shift = 0;
        for (int i = 0; i < targetMatrix.length; ++i) {
            if (i == rowIndexToLeave) {
                ++shift;
            }
            System.arraycopy(sourceMatrix[i + shift], 0, targetMatrix[i], 0, sourceMatrix[i + shift].length);
        }
    }

    public static void copySelectedColoumns(double[][] source, BitSet bs, double[][] target) {
        if (source.length != target.length) {
            throw new IllegalArgumentException("Target matrix size error.");
        }
        for (int i = 0; i < source.length; ++i) {
            int col = 0;
            int j = bs.nextSetBit(0);
            while (j > -1) {
                target[i][col] = source[i][j];
                ++col;
                j = bs.nextSetBit(j + 1);
            }
        }
    }
}

