/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

import chemaxon.calculations.training.solubility.HistogramValue;
import chemaxon.marvin.plugin.PluginException;
import java.util.PriorityQueue;

public class Histogram {
    private boolean ready;
    private PriorityQueue<HistogramValue> vals = null;
    private HistogramValue[] hist = null;
    private int increment;
    private double incSize;
    private double minC = Double.MAX_VALUE;
    private double maxC = -1.7976931348623157E308;
    private double allAmount;
    private final double SMALL = 1.0E-8;

    private void init() {
        this.vals = new PriorityQueue();
        this.ready = false;
        this.increment = 0;
        this.incSize = 0.01;
        this.allAmount = 0.0;
    }

    public Histogram() {
        this.init();
    }

    public Histogram(double incS) {
        this.init();
        this.incSize = incS;
    }

    public Histogram(double[] d, double incS) {
        this.init();
        this.incSize = incS;
        for (int i = 0; i < d.length; ++i) {
            this.add(new HistogramValue(d[i], 1.0));
        }
        this.ready();
    }

    Histogram(HistogramValue[] hvs, double iS, double allA, double min, double max) {
        this.init();
        this.increment = hvs.length;
        this.incSize = iS;
        this.allAmount = allA;
        this.hist = hvs;
        this.ready = true;
        this.minC = min;
        this.maxC = max;
    }

    public Histogram(PriorityQueue<HistogramValue> pq, double incSize2, double min, double max) {
        this.init();
        this.vals = pq;
        this.incSize = incSize2;
        this.ready = true;
        this.minC = min;
        this.maxC = max;
        this.calcHist();
    }

    public boolean add(HistogramValue ca) {
        if (!this.ready) {
            if (ca.X() < this.minC) {
                this.minC = ca.X();
            }
            if (ca.X() > this.maxC) {
                this.maxC = ca.X();
            }
            this.vals.add(ca);
        }
        return !this.ready;
    }

    public void ready() {
        if (!this.ready) {
            this.ready = true;
            this.calcHist();
        }
    }

    private void calcHist() {
        double min;
        double max = 0.0;
        if (this.minC < 0.0) {
            for (min = 0.0; this.minC <= min; min -= this.incSize) {
            }
        } else {
            while (this.minC >= min) {
                min += this.incSize;
            }
            min -= this.incSize;
        }
        if (this.maxC > 0.0) {
            while (this.maxC >= max) {
                max += this.incSize;
            }
        } else {
            while (this.maxC <= max) {
                max -= this.incSize;
            }
            max += this.incSize;
        }
        this.minC = min;
        this.maxC = max;
        if (this.equals(min, max)) {
            max = min + (double)this.increment;
        }
        this.increment = (int)((max - min) / this.incSize);
        if (this.increment == 0) {
            ++this.increment;
        }
        this.hist = new HistogramValue[this.increment];
        for (int i = 0; i < this.increment; ++i) {
            double n = min + (double)(i + 1) * this.incSize;
            this.hist[i] = new HistogramValue(n, 0.0);
            HistogramValue ca = this.vals.poll();
            while (ca != null && this.smallerEqual(ca.X(), n)) {
                this.hist[i].add(ca.Y());
                this.allAmount += ca.Y();
                ca = this.vals.poll();
            }
            if (ca == null) continue;
            this.vals.add(ca);
        }
    }

    public boolean mirror() {
        if (!this.ready) {
            return false;
        }
        HistogramValue[] newhist = new HistogramValue[this.hist.length];
        for (int i = 0; i < this.hist.length; ++i) {
            newhist[i] = new HistogramValue(-this.hist[this.hist.length - i - 1].X(), this.hist[this.hist.length - i - 1].Y());
        }
        double tmp = this.minC;
        this.minC = -this.maxC;
        this.maxC = -tmp;
        this.hist = newhist;
        return true;
    }

    public boolean normalize() {
        if (!this.ready) {
            return false;
        }
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i].setY(this.hist[i].Y() / this.allAmount);
        }
        this.allAmount = 1.0;
        return true;
    }

    public boolean euklNorm() {
        if (!this.ready) {
            return false;
        }
        double eukl = 0.0;
        for (HistogramValue hv : this.hist) {
            eukl += Math.pow(hv.Y(), 2.0);
        }
        eukl = Math.sqrt(eukl);
        double amount = 0.0;
        for (HistogramValue hv : this.hist) {
            double newy = hv.Y() / eukl;
            hv.setY(newy);
            amount += newy;
        }
        this.allAmount = amount;
        return true;
    }

    public double scalar(Histogram h) {
        int oi;
        int i;
        if (!this.ready || !h.ready) {
            return Double.NaN;
        }
        double result = 0.0;
        PriorityQueue pq = new PriorityQueue();
        if (this.smallerEqual(this.hist[0].X(), h.hist[0].X())) {
            for (i = 0; i < this.hist.length && this.smaller(this.hist[i].X(), h.hist[oi].X()); ++i) {
            }
        } else {
            for (oi = 0; oi < h.hist.length && this.smaller(h.hist[oi].X(), this.hist[i].X()); ++oi) {
            }
        }
        while (oi < h.hist.length && i < this.hist.length) {
            if (!this.equals(h.hist[oi].X(), this.hist[i].X())) {
                System.err.println("X error in scalar!");
            }
            result += h.hist[oi].Y() * this.hist[i].Y();
            ++i;
            ++oi;
        }
        return result;
    }

    public boolean multiply(double d) {
        if (!this.ready) {
            return false;
        }
        for (HistogramValue hv : this.hist) {
            hv.setY(hv.Y() * d);
        }
        this.allAmount *= d;
        return true;
    }

    public boolean smooth() {
        int i;
        if (!this.ready) {
            return false;
        }
        this.allAmount = 0.0;
        HistogramValue[] nhw = new HistogramValue[this.increment];
        double[] coeff = new double[]{-36.0, 9.0, 44.0, 69.0, 84.0, 89.0, 84.0, 69.0, 44.0, 9.0, -36.0};
        if (this.hist.length < 11) {
            System.err.println(this);
            return false;
        }
        for (i = 0; i < 5; ++i) {
            nhw[i] = new HistogramValue(this.hist[i].X(), this.hist[i].Y());
            this.allAmount += this.hist[i].Y();
        }
        for (i = this.increment - 5; i < this.increment; ++i) {
            nhw[i] = new HistogramValue(this.hist[i].X(), this.hist[i].Y());
            this.allAmount += this.hist[i].Y();
        }
        for (i = 5; i < this.increment - 5; ++i) {
            nhw[i] = new HistogramValue(this.hist[i].X(), (-36.0 * this.hist[i - 5].Y() + 9.0 * this.hist[i - 4].Y() + 44.0 * this.hist[i - 3].Y() + 69.0 * this.hist[i - 2].Y() + 84.0 * this.hist[i - 1].Y() + 89.0 * this.hist[i].Y() + 84.0 * this.hist[i + 1].Y() + 69.0 * this.hist[i + 2].Y() + 44.0 * this.hist[i + 3].Y() + 9.0 * this.hist[i + 4].Y() - 36.0 * this.hist[i + 5].Y()) / 429.0);
            this.allAmount += nhw[i].Y();
        }
        this.hist = nhw;
        return true;
    }

    public String toString() {
        if (!this.ready) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (HistogramValue hv : this.hist) {
            sb.append(hv.X() + " " + hv.Y() + "\n");
        }
        return sb.toString();
    }

    public Histogram di(Histogram h) throws PluginException {
        int oi;
        int i;
        if (this.incSize != h.incSize) {
            return null;
        }
        if (!this.ready || !h.ready) {
            return null;
        }
        double min = Math.min(this.minC, h.minC);
        double max = Math.max(this.maxC, h.maxC);
        double allA = 0.0;
        PriorityQueue<HistogramValue> result = new PriorityQueue<HistogramValue>();
        int r = 0;
        if (this.smaller(this.minC, h.minC)) {
            for (i = 0; i < this.hist.length && this.smaller(this.hist[i].X(), h.hist[0].X()); ++i) {
                result.add(new HistogramValue(this.hist[i].X(), this.hist[i].Y()));
                allA += this.hist[i].Y();
                ++r;
            }
        } else {
            for (oi = 0; oi < h.hist.length && this.smaller(h.hist[oi].X(), this.hist[0].X()); ++oi) {
                result.add(new HistogramValue(h.hist[oi].X(), h.hist[oi].Y()));
                allA += h.hist[oi].Y();
                ++r;
            }
        }
        if (i < this.hist.length && oi < h.hist.length && this.smaller(this.hist[i].X(), h.hist[oi].X())) {
            ++i;
        }
        while (i < this.hist.length && oi < h.hist.length) {
            if (!this.equals(this.hist[i].X(), h.hist[oi].X())) {
                System.err.println("ERROR: " + this.hist[i].X() + " " + h.hist[oi].X());
                throw new PluginException("Error in histogram X values.");
            }
            double diff = this.hist[i].Y() - h.hist[oi].Y();
            if (diff == 0.0) {
                System.err.println("NULLDIFF " + i + " " + oi);
                System.err.println(this.hist[i].Y() + " " + h.hist[oi].Y() + " " + diff);
            }
            result.add(new HistogramValue(this.hist[i].X(), diff));
            allA += diff;
            ++i;
            ++oi;
            ++r;
        }
        while (i < this.hist.length) {
            result.add(new HistogramValue(this.hist[i].X(), this.hist[i].Y()));
            allA += this.hist[i].Y();
            ++r;
            ++i;
        }
        while (oi < h.hist.length) {
            result.add(new HistogramValue(h.hist[oi].X(), h.hist[oi].Y()));
            allA += h.hist[oi].Y();
            ++r;
            ++oi;
        }
        Histogram res = new Histogram(result, h.incSize, min, max);
        return res;
    }

    public Histogram clone() {
        return new Histogram((HistogramValue[])this.hist.clone(), this.incSize, this.allAmount, this.minC, this.maxC);
    }

    public double squareInt() {
        double result = 0.0;
        for (HistogramValue hv : this.hist) {
            result += hv.Y() * hv.Y();
        }
        return result;
    }

    public double integral() {
        double result = 0.0;
        for (HistogramValue hv : this.hist) {
            result += hv.Y();
        }
        return result;
    }

    private boolean smaller(double a, double b) {
        return a + 1.0E-8 < b;
    }

    private boolean smallerEqual(double a, double b) {
        return a + 1.0E-8 < b;
    }

    private boolean equals(double a, double b) {
        double diff = Math.abs(a - b);
        return diff < 1.0E-8;
    }
}

