/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

import chemaxon.calculations.Charge;
import chemaxon.calculations.training.solubility.Histogram;
import chemaxon.calculations.training.solubility.HistogramValue;
import chemaxon.calculations.training.solubility.SpiralOnSphere;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class HistogramCreator {
    private Molecule mol = null;
    private double[] charges = null;
    private double[][] points = null;
    private final int pointNum = 10000;

    public HistogramCreator() {
    }

    public HistogramCreator(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
    }

    public void setPoints(double[][] p) {
        this.points = p;
    }

    public boolean setCharges(double[] charges) {
        if (this.mol.hasImplicitH()) {
            return false;
        }
        int g = 0;
        if (this.mol.getAtomCount() != charges.length) {
            return false;
        }
        if (g == 0) {
            ++g;
        }
        this.charges = charges;
        return true;
    }

    public boolean setMolecule(Molecule m) {
        this.mol = m.cloneMoleculeWithDocument();
        return true;
    }

    public Histogram create() {
        if (this.mol.hasImplicitH()) {
            // empty if block
        }
        Histogram hist = new Histogram(0.001);
        Charge c = new Charge();
        c.setMolecule(this.mol);
        c.setCriticalErrorFlag(false);
        c.calcCharges();
        this.charges = new double[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.charges[i] = c.getTotalCharge(i);
        }
        if (this.points == null) {
            SpiralOnSphere sos = new SpiralOnSphere(10000);
            this.points = sos.getPoints();
        }
        int[][] neigbourAtoms = this.setNeighbourAtoms();
        MolAtom[] mas = this.mol.getAtomArray();
        for (int i = 0; i < mas.length; ++i) {
            MolAtom ma = mas[i];
            double x = ma.getX();
            double y = ma.getY();
            double z = ma.getZ();
            MolAtom probe = new MolAtom(0);
            double radius = PeriodicSystem.getVanDerWaalsRadius(ma.getAtno());
            double surfacePerPoint = Math.PI * 4 * Math.pow(radius, 3.0) / 3.0 / 10000.0;
            for (int j = 0; j < this.points.length; ++j) {
                probe.setXYZ(x + this.points[j][0] * radius, y + this.points[j][1] * radius, z + this.points[j][2] * radius);
                if (!this.surfacePoint(probe, i, neigbourAtoms)) continue;
                double surfaceCharge = this.surfaceCharge(probe, this.charges);
                HistogramValue ca = new HistogramValue(surfaceCharge, surfacePerPoint);
                hist.add(ca);
            }
        }
        hist.ready();
        return hist;
    }

    private boolean surfacePoint(MolAtom probe, int atom, int[][] neighbourAtoms) {
        MolAtom[] mas = this.mol.getAtomArray();
        for (int i = 0; i < neighbourAtoms[atom].length && neighbourAtoms[atom][i] >= 0; ++i) {
            MolAtom ma = mas[neighbourAtoms[atom][i]];
            double dist = PeriodicSystem.getVanDerWaalsRadius(ma.getAtno());
            if (!(this.distance(ma, probe) < dist)) continue;
            return false;
        }
        return true;
    }

    private double surfaceCharge(MolAtom probe, double[] charges) {
        double cPot = 0.0;
        MolAtom[] mas = this.mol.getAtomArray();
        for (int i = 0; i < mas.length; ++i) {
            MolAtom ma = mas[i];
            if (charges[i] == Double.NaN) {
                System.err.println(i + "th atom has nan charge in " + this.mol.toFormat("smi"));
            }
            cPot += charges[i] / this.distance(probe, ma);
        }
        if (cPot == Double.NaN) {
            System.err.println("an atom has nan cpot in " + this.mol.toFormat("smi"));
        }
        return cPot;
    }

    private int[][] setNeighbourAtoms() {
        MolAtom[] mas = this.mol.getAtomArray();
        int[][] neighbourAtoms = new int[mas.length][];
        for (int i = 0; i < mas.length; ++i) {
            neighbourAtoms[i] = new int[mas.length + 1];
            MolAtom ma = mas[i];
            int nNum = 0;
            for (int j = 0; j < mas.length; ++j) {
                if (i == j) continue;
                MolAtom ma2 = mas[j];
                double vdW = PeriodicSystem.getVanDerWaalsRadius(ma2.getAtno()) + PeriodicSystem.getVanDerWaalsRadius(ma.getAtno()) * 1.1;
                if (!(this.distance(ma, ma2) <= vdW)) continue;
                neighbourAtoms[i][nNum] = j;
                ++nNum;
            }
            neighbourAtoms[i][nNum] = -1;
        }
        return neighbourAtoms;
    }

    private double distance(MolAtom ma1, MolAtom ma2) {
        double x = ma1.getX() - ma2.getX();
        double y = ma1.getY() - ma2.getY();
        double z = ma1.getZ() - ma2.getZ();
        return Math.sqrt(x * x + y * y + z * z);
    }
}

