/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

import chemaxon.calculations.VanDerWaalsVolume;
import chemaxon.calculations.training.solubility.Histogram;
import chemaxon.calculations.training.solubility.HistogramCreator;
import chemaxon.calculations.training.solubility.SpiralOnSphere;
import chemaxon.calculations.training.solubility.Water;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.calculations.ChargePlugin;
import chemaxon.marvin.calculations.HBDAPlugin;
import chemaxon.marvin.calculations.MSAPlugin;
import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.calculations.PolarizabilityPlugin;
import chemaxon.marvin.calculations.TopologyAnalyserPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.Molecule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Solubility {
    private double[] descriptors;
    private boolean calcNeeded;
    private double nCharge = 0.0;
    private double oCharge = 0.0;
    private double hCharge = 0.0;
    private double cCharge = 0.0;
    private double noCharge = 0.0;
    private double otherCharge = 0.0;
    private double charge = 0.0;
    private double chargeNeg = 0.0;
    private double chargePos = 0.0;
    private double nPol = 0.0;
    private double oPol = 0.0;
    private double hPol = 0.0;
    private double cPol = 0.0;
    private double volume = 0.0;
    private double mw = 0.0;
    private double pol = 0.0;
    private double hAcc = 0.0;
    private double hDon = 0.0;
    private double bondC = 0.0;
    private double rotBondC = 0.0;
    private double chainBonds = 0.0;
    private double aliphaticBonds = 0.0;
    private double szegedIndex = 0.0;
    private double hararyIndex = 0.0;
    private double atomCount = 0.0;
    private double ringAtoms = 0.0;
    private double aliphaticAtoms = 0.0;
    private double vdwarea;
    private double sas;
    private double sasp;
    private double sasn;
    private double sash;
    private double surface_volume;
    private int microspecies;
    private Molecule origMol = null;
    private Molecule mol = null;
    private Histogram water = null;
    private double[] charges = null;
    private double[][] pointsOnSphere = null;
    private double selfIntegral = 0.0;
    private double waterIntegral = 0.0;

    public Solubility() {
        this.init();
    }

    public Solubility(Molecule mol) {
        this.init();
        this.setMolecule(mol);
    }

    private void init() {
        this.water = Water.water;
        SpiralOnSphere sos = new SpiralOnSphere(7000);
        this.pointsOnSphere = sos.getPoints();
        this.calcNeeded = true;
        this.descriptors = new double[41];
    }

    private boolean calcDescriptors() throws PluginException, AlignmentException {
        if (this.mol == null) {
            return false;
        }
        this.descriptors = new double[36];
        this.mol.hydrogenize(true);
        this.descriptors[0] = this.mol.getTotalCharge();
        ChargePlugin cp = new ChargePlugin();
        cp.setMolecule(this.mol);
        cp.run();
        PolarizabilityPlugin pp = new PolarizabilityPlugin();
        pp.setMolecule(this.mol);
        pp.run();
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            double icharge = cp.getTotalCharge(i);
            double ipol = pp.getPolarizability(i);
            if (Double.isNaN(icharge)) {
                icharge = this.mol.getAtom(i).getCharge();
            }
            if (this.mol.getAtom(i).getAtno() == 6) {
                this.descriptors[1] = this.descriptors[1] + Math.abs(icharge);
                this.descriptors[2] = this.descriptors[2] + Math.abs(ipol);
            } else if (this.mol.getAtom(i).getAtno() == 7) {
                this.descriptors[3] = this.descriptors[3] + Math.abs(icharge);
                this.descriptors[4] = this.descriptors[4] + Math.abs(ipol);
            } else if (this.mol.getAtom(i).getAtno() == 8) {
                this.descriptors[5] = this.descriptors[5] + Math.abs(icharge);
                this.descriptors[6] = this.descriptors[6] + Math.abs(ipol);
            } else if (this.mol.getAtom(i).getAtno() == 1) {
                this.descriptors[7] = this.descriptors[7] + Math.abs(icharge);
                this.descriptors[8] = this.descriptors[8] + Math.abs(ipol);
            } else {
                this.descriptors[9] = this.descriptors[9] + Math.abs(icharge);
            }
            if (icharge < 0.0) {
                this.descriptors[10] = this.descriptors[10] + icharge;
                continue;
            }
            this.descriptors[11] = this.descriptors[11] + icharge;
        }
        this.descriptors[12] = this.descriptors[3] + this.descriptors[5];
        this.descriptors[13] = pp.getMolPolarizability();
        this.descriptors[14] = this.mol.getMass();
        TopologyAnalyserPlugin tap = new TopologyAnalyserPlugin();
        tap.setMolecule(this.mol);
        tap.run();
        this.descriptors[15] = tap.getBondCount();
        this.descriptors[16] = (double)tap.getRotatableBondCount() / this.descriptors[15];
        this.descriptors[17] = (double)tap.getChainBondCount() / this.descriptors[15];
        this.descriptors[18] = (double)tap.getAliphaticBondCount() / this.descriptors[15];
        this.descriptors[19] = tap.getSzegedIndex();
        this.descriptors[20] = tap.getHararyIndex();
        this.descriptors[21] = tap.getAtomCount();
        this.descriptors[22] = (double)tap.getRingAtomCount() / this.descriptors[21];
        this.descriptors[23] = (double)tap.getAliphaticAtomCount() / this.descriptors[21];
        HBDAPlugin hbda = new HBDAPlugin();
        hbda.setMolecule(this.mol);
        hbda.run();
        this.descriptors[24] = hbda.getAcceptorAtomCount();
        this.descriptors[25] = hbda.getDonorAtomCount();
        MSAPlugin msa = new MSAPlugin();
        msa.setMolecule(this.mol);
        msa.setSurfaceAreaType(0);
        msa.run();
        this.descriptors[26] = msa.getSurfaceArea();
        msa = new MSAPlugin();
        msa.setMolecule(this.mol);
        msa.setSurfaceAreaType(1);
        msa.run();
        this.descriptors[27] = msa.getASA();
        this.descriptors[28] = msa.getASAPlus() / this.descriptors[27];
        this.descriptors[29] = msa.getASANegative() / this.descriptors[27];
        this.descriptors[30] = msa.getASAHydrophobic() / this.descriptors[27];
        VanDerWaalsVolume mv = new VanDerWaalsVolume();
        mv.setMolecule(this.mol);
        mv.run();
        this.descriptors[31] = mv.getVolume();
        this.descriptors[32] = this.descriptors[26] / this.descriptors[31];
        MajorMicrospeciesPlugin mmp = new MajorMicrospeciesPlugin();
        mmp.setMolecule(this.mol);
        mmp.run();
        this.descriptors[33] = mmp.getMicrospeciesCount();
        HistogramCreator hc = new HistogramCreator();
        hc.setMolecule(this.mol);
        hc.setPoints(this.pointsOnSphere);
        if (this.charges != null && this.charges.length != this.mol.getAtomCount()) {
            hc.setCharges(this.charges);
        }
        try {
            Histogram molHist = hc.create();
            molHist.smooth();
            molHist.euklNorm();
            Histogram molHist2 = molHist.clone();
            Histogram mirror = molHist.clone();
            double scalar = molHist.scalar(this.water);
            molHist.multiply(scalar);
            Histogram diff = molHist.di(this.water);
            mirror.mirror();
            scalar = molHist2.scalar(mirror);
            mirror.multiply(scalar);
            Histogram selfDiff = mirror.di(molHist2);
            this.descriptors[34] = diff.squareInt();
            this.descriptors[35] = selfDiff.squareInt();
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        this.calcNeeded = false;
        return true;
    }

    public void setMolecule(Molecule m) {
        this.origMol = m;
        this.mol = m.cloneMoleculeWithDocument();
        this.mol.hydrogenize(true);
        if (this.mol.getDim() < 3) {
            this.mol.clean(3, null);
        }
        this.calcNeeded = true;
    }

    public double[] getDescriptors(Molecule m) {
        this.setMolecule(m);
        return this.getDescriptors();
    }

    public double[] getDescriptors() {
        if (this.calcNeeded) {
            try {
                this.calcDescriptors();
            }
            catch (PluginException ex) {
                Logger.getLogger(Solubility.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
            catch (AlignmentException ex) {
                Logger.getLogger(Solubility.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        return this.descriptors;
    }
}

