/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

import chemaxon.calculations.training.PredictionAlgorithm;
import chemaxon.calculations.training.pls.PLSPredictionAlgorithm;
import chemaxon.calculations.training.solubility.SolubilityTrainingResult;
import java.util.BitSet;

class SolubilityPredictionAlgorithm
implements PredictionAlgorithm<SolubilityTrainingResult> {
    PLSPredictionAlgorithm pred = null;
    BitSet selected = null;
    float prog = -1.0f;

    @Override
    public double predict(double[] descriptors) {
        double[] selectedDescriptors;
        if (this.selected == null) {
            selectedDescriptors = descriptors;
        } else {
            selectedDescriptors = new double[this.selected.cardinality()];
            int j = 0;
            this.prog = 0.0f;
            int i = this.selected.nextSetBit(0);
            while (i >= 0) {
                selectedDescriptors[j] = descriptors[i];
                ++j;
                this.prog = i / descriptors.length;
                i = this.selected.nextSetBit(i + 1);
            }
        }
        return this.pred.predict(selectedDescriptors);
    }

    @Override
    public void setCoefficients(SolubilityTrainingResult results) {
        this.pred = new PLSPredictionAlgorithm();
        this.pred.setCoefficients(results.getPLSResult());
        this.selected = results.getSelection();
        this.prog = 1.0f;
    }

    @Override
    public float getProgress() {
        return this.prog;
    }
}

