/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.solubility;

import chemaxon.calculations.training.DescriptorMatrix;
import chemaxon.calculations.training.FittingAlgorithm;
import chemaxon.calculations.training.pflr.PFLRFittingAlgorithm;
import chemaxon.calculations.training.pflr.PFLRResult;
import chemaxon.calculations.training.pls.PLSFittingAlgorithm;
import chemaxon.calculations.training.solubility.SolubilityTrainingResult;
import java.util.BitSet;

public class SolubilityTrainingAlgorithm
implements FittingAlgorithm<SolubilityTrainingResult> {
    float prog = 0.0f;
    int verbose = 0;
    PFLRFittingAlgorithm pflr = new PFLRFittingAlgorithm();

    @Override
    public void setDescriptorMatrix(DescriptorMatrix matrix) {
        this.pflr.setDescriptorMatrix(matrix);
    }

    @Override
    public void setExperimentalValues(double[] values) {
        this.pflr.setExperimentalValues(values);
    }

    @Override
    public SolubilityTrainingResult getResult() {
        PFLRResult results = this.pflr.getResult();
        double[][] x = results.getTraningXData();
        BitSet selected = results.getSelection();
        Object selectedX = null;
        if (selected == null) {
            selectedX = x;
        } else {
            selectedX = new double[x.length][];
            for (int i = 0; i < x.length; ++i) {
                int j = 0;
                selectedX[i] = new double[selected.cardinality()];
                int k = selected.nextSetBit(0);
                while (k >= 0) {
                    selectedX[i][j] = x[i][k];
                    ++j;
                    k = selected.nextSetBit(k + 1);
                }
                this.prog = i / 2 / x.length;
            }
        }
        PLSFittingAlgorithm pls = new PLSFittingAlgorithm((double[][])selectedX, results.getTrainingYData());
        return new SolubilityTrainingResult(pls.getResult(), selected);
    }

    @Override
    public float getProgress() {
        return this.prog;
    }

    public void setVerboseLevel(int v) {
        this.verbose = v;
        this.pflr.setVerboseLevel(v);
    }
}

