/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.training.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TrainingResultChart
extends JComponent
implements Cloneable {
    private static final long serialVersionUID = -7370698532012470420L;
    private static DecimalFormat formatter = new DecimalFormat("0.00");
    private static Stroke dashedStroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
    private static final Comparator<double[]> comparator = new Comparator<double[]>(){

        @Override
        public int compare(double[] o1, double[] o2) {
            if (o1.length > 0 && o2.length > 0) {
                if (o1[0] < o2[0]) {
                    return -1;
                }
                if (o1[0] > o2[0]) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private final List<double[]> values = new ArrayList<double[]>();
    private double minExp = Double.POSITIVE_INFINITY;
    private double maxExp = Double.NEGATIVE_INFINITY;
    private double minPred = Double.POSITIVE_INFINITY;
    private double maxPred = Double.NEGATIVE_INFINITY;
    private BufferedImage cachedImage = null;
    private int margin = 50;
    private int radius = 5;
    private Color dotColor = Color.BLUE;
    private Color hiDotColor = Color.LIGHT_GRAY;
    private double[] hoverCoord = null;
    private boolean showLinesOnHover = true;
    private boolean showMedianLine = true;
    private boolean valid = false;

    public TrainingResultChart() {
        this.setToolTipText("");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrainingResultChart.this.valid = false;
                        TrainingResultChart.this.repaint();
                    }
                });
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                double[] value = TrainingResultChart.this.getValuesAt(e.getX(), e.getY());
                if (TrainingResultChart.this.hoverCoord != value) {
                    TrainingResultChart.access$202(TrainingResultChart.this, value);
                    TrainingResultChart.this.repaint();
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.valid) {
            this.updateCachedImage();
        }
        super.paintComponent(g);
        if (this.cachedImage != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.drawImage((Image)this.cachedImage, 0, 0, null);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.showMedianLine) {
                Graphics2D gLn = (Graphics2D)g2.create();
                gLn.clipRect(this.margin, 0, this.getWidth(), this.getHeight() - this.margin);
                gLn.setColor(Color.BLACK);
                double min = Math.min(this.minExp, this.minPred);
                double max = Math.max(this.maxExp, this.maxPred);
                gLn.drawLine(this.transX(min), this.transY(min), this.transX(max), this.transY(max));
                gLn.dispose();
            }
            if (this.hoverCoord != null) {
                int r = this.radius * 2;
                int x = this.transX(this.hoverCoord[0]);
                int y = this.transY(this.hoverCoord[1]);
                if (this.showLinesOnHover) {
                    Graphics2D gLn = (Graphics2D)g2.create();
                    gLn.setColor(this.getBackground());
                    gLn.setColor(Color.BLACK);
                    gLn.setStroke(dashedStroke);
                    gLn.drawLine(this.margin, y, x, y);
                    gLn.drawLine(x, y, x, this.getHeight() - this.margin);
                    gLn.dispose();
                }
                g2.setColor(this.hiDotColor);
                g2.fillOval(x - r / 2, y - r / 2, r, r);
            }
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(double experimentalValue, double predictedValue) {
        List<double[]> list = this.values;
        synchronized (list) {
            this.values.add(new double[]{experimentalValue, predictedValue});
        }
        if (experimentalValue < this.minExp) {
            this.minExp = experimentalValue;
        }
        if (experimentalValue > this.maxExp) {
            this.maxExp = experimentalValue;
        }
        if (predictedValue < this.minPred) {
            this.minPred = predictedValue;
        }
        if (predictedValue > this.maxPred) {
            this.maxPred = predictedValue;
        }
        this.valid = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<double[]> list = this.values;
        synchronized (list) {
            this.values.clear();
        }
        this.minExp = Double.POSITIVE_INFINITY;
        this.maxExp = Double.NEGATIVE_INFINITY;
        this.minPred = Double.POSITIVE_INFINITY;
        this.maxPred = Double.NEGATIVE_INFINITY;
        this.hoverCoord = null;
        this.valid = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCachedImage() {
        int w = this.getWidth();
        int h = this.getHeight();
        int m = this.margin = this.getOptimalMarginWidth(this.minExp, this.maxExp, this.minPred, this.maxPred);
        int r = this.radius * 2;
        if (w > 0 && h > 0) {
            this.cachedImage = new BufferedImage(w, h, 5);
            Graphics2D g2 = (Graphics2D)this.cachedImage.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, w, h);
            g2.setColor(Color.BLACK);
            g2.drawLine(m, m / 2, m, h - m / 2);
            g2.drawLine(m / 2, h - m, w - m / 2, h - m);
            g2.fillPolygon(new int[]{m, m - 4, m + 4}, new int[]{m / 2 - 1, m / 2 + 7, m / 2 + 7}, 3);
            g2.fillPolygon(new int[]{w - m / 2 + 1, w - m / 2 - 7, w - m / 2 - 7}, new int[]{h - m, h - m - 4, h - m + 4}, 3);
            g2.drawString(formatter.format(this.minExp), m + 5, h - m + 5 + g2.getFontMetrics().getHeight());
            g2.drawString(formatter.format(this.maxExp), w - m / 2 - 5 - SwingUtilities.computeStringWidth(g2.getFontMetrics(), formatter.format(this.maxExp)), h - m + 5 + g2.getFontMetrics().getHeight());
            g2.drawLine(this.transX(this.minExp), h - m - 3, this.transX(this.minExp), h - m + 3);
            g2.drawLine(this.transX(this.maxExp), h - m - 3, this.transX(this.maxExp), h - m + 3);
            g2.drawString(formatter.format(this.minPred), m - SwingUtilities.computeStringWidth(g2.getFontMetrics(), formatter.format(this.minPred)) - 5, this.transY(this.minPred) + g2.getFontMetrics().getAscent() / 2 - 1);
            g2.drawString(formatter.format(this.maxPred), m - SwingUtilities.computeStringWidth(g2.getFontMetrics(), formatter.format(this.maxPred)) - 5, this.transY(this.maxPred) + g2.getFontMetrics().getAscent() / 2 - 1);
            g2.drawLine(m - 3, this.transY(this.minPred), m + 3, this.transY(this.minPred));
            g2.drawLine(m - 3, this.transY(this.maxPred), m + 3, this.transY(this.maxPred));
            g2.setColor(this.dotColor);
            List<double[]> list = this.values;
            synchronized (list) {
                for (int i = 0; i < this.values.size(); ++i) {
                    int x = this.transX(this.values.get(i)[0]);
                    int y = this.transY(this.values.get(i)[1]);
                    g2.fillOval(x - r / 2, y - r / 2, r, r);
                }
            }
            g2.dispose();
        }
        List<double[]> list = this.values;
        synchronized (list) {
            Collections.sort(this.values, comparator);
        }
        this.valid = true;
    }

    private int transX(double value) {
        return this.margin + 3 * this.radius + (int)((double)((float)this.getWidth() - 1.5f * (float)this.margin - (float)(6 * this.radius)) * (value - this.minExp) / (this.maxExp - this.minExp));
    }

    private int transY(double value) {
        return this.getHeight() - (this.margin + 3 * this.radius + (int)((double)((float)this.getHeight() - 1.5f * (float)this.margin - (float)(6 * this.radius)) * (value - this.minPred) / (this.maxPred - this.minPred)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getValuesAt(int x, int y) {
        List<double[]> list = this.values;
        synchronized (list) {
            int i;
            for (i = 0; i < this.values.size() && x > this.transX(this.values.get(i)[0]) + this.radius; ++i) {
            }
            while (i < this.values.size() && x >= this.transX(this.values.get(i)[0]) - this.radius) {
                if (y <= this.transY(this.values.get(i)[1]) + this.radius && y >= this.transY(this.values.get(i)[1]) - this.radius) {
                    return this.values.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        double[] value = this.getValuesAt(event.getX(), event.getY());
        if (value != null) {
            return "<html><body><b>&nbsp;Experimental:&nbsp;</b>" + formatter.format(value[0]) + "&nbsp;<br><b>&nbsp;Predicted:&nbsp;</b>" + formatter.format(value[1]) + "&nbsp;</b><br></body></html>";
        }
        return null;
    }

    private int getOptimalMarginWidth(double ... values) {
        int max = 50;
        if (this.getFont() != null) {
            for (double d : values) {
                int w = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), formatter.format(d)) + 10;
                if (w <= max) continue;
                max = w;
            }
        }
        return max;
    }

    public int getDotRadius() {
        return this.radius;
    }

    public void setDotRadius(int radius) {
        this.radius = radius;
    }

    public Color getDotColor() {
        return this.dotColor;
    }

    public void setDotColor(Color dotColor) {
        this.dotColor = dotColor;
    }

    public Color getHiDotColor() {
        return this.hiDotColor;
    }

    public void setHiDotColor(Color hiDotColor) {
        this.hiDotColor = hiDotColor;
    }

    public boolean isLinesOnHoverVisible() {
        return this.showLinesOnHover;
    }

    public void setLinesOnHoverVisible(boolean visible) {
        this.showLinesOnHover = visible;
        this.repaint();
    }

    public boolean isMedianLineVisible() {
        return this.showMedianLine;
    }

    public void setMedianLineVisible(boolean visible) {
        this.showMedianLine = visible;
        this.repaint();
    }

    public Object clone() {
        return this.cloneGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrainingResultChart cloneGraph() {
        TrainingResultChart clone = new TrainingResultChart();
        List<double[]> list = this.values;
        synchronized (list) {
            for (double[] data : this.values) {
                clone.values.add(new double[]{data[0], data[1]});
            }
        }
        if (this.cachedImage != null) {
            clone.cachedImage = new BufferedImage(this.cachedImage.getWidth(), this.cachedImage.getHeight(), this.cachedImage.getType());
            clone.cachedImage.getGraphics().drawImage(this.cachedImage, 0, 0, null);
        }
        clone.minExp = this.minExp;
        clone.maxExp = this.maxExp;
        clone.minPred = this.minPred;
        clone.maxPred = this.maxPred;
        clone.margin = this.margin;
        clone.radius = this.radius;
        clone.dotColor = new Color(this.dotColor.getRed(), this.dotColor.getGreen(), this.dotColor.getBlue(), this.dotColor.getAlpha());
        clone.hiDotColor = new Color(this.hiDotColor.getRed(), this.hiDotColor.getGreen(), this.hiDotColor.getBlue(), this.hiDotColor.getAlpha());
        clone.valid = this.valid;
        clone.showLinesOnHover = this.showLinesOnHover;
        clone.showMedianLine = this.showMedianLine;
        if (this.hoverCoord != null) {
            clone.hoverCoord = new double[]{this.hoverCoord[0], this.hoverCoord[1]};
        }
        return clone;
    }

    static /* synthetic */ double[] access$202(TrainingResultChart x0, double[] x1) {
        x0.hoverCoord = x1;
        return x1;
    }
}

