/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.chart.dataset.DataSet;
import chemaxon.chart.dataset.DataSetEntry;
import chemaxon.chart.dataset.DefaultDataSet;
import chemaxon.chart.dataset.Function;
import chemaxon.chart.dataset.Interval;
import chemaxon.chart.model.HighlightModel;
import chemaxon.chart.model.PointHighlightModel;
import java.util.Arrays;

public class MultipletDataSource
implements Function {
    private Multiplet base;

    public MultipletDataSource(Multiplet base) {
        this.base = base;
    }

    public Interval<Double> getDomain() {
        return new Interval((Comparable)Double.valueOf(this.base.getDomainMin()), (Comparable)Double.valueOf(this.base.getDomainMax()));
    }

    public Interval<Double> getRange() {
        return new Interval((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(0.1));
    }

    public DataSet<?> getDataSet(double samplingDistance, Interval<Double> domain) {
        int maxIndex;
        double max;
        DefaultDataSet result = new DefaultDataSet();
        result.setValueType(DataSet.ValueType.LINE);
        double min = (Double)this.getDomain().getMin();
        if (min < (Double)domain.getMin()) {
            min = (Double)domain.getMin();
        }
        if ((max = ((Double)this.getDomain().getMax()).doubleValue()) > (Double)domain.getMax()) {
            max = (Double)domain.getMax();
        }
        double[] maxLocations = this.base.getLocalMaximumPlaces();
        Arrays.sort(maxLocations);
        for (maxIndex = 0; maxIndex < maxLocations.length && min > maxLocations[maxIndex]; ++maxIndex) {
        }
        for (double i = min; i <= max; i += samplingDistance) {
            if (maxIndex < maxLocations.length && i <= maxLocations[maxIndex] && i + samplingDistance > maxLocations[maxIndex]) {
                double location = maxLocations[maxIndex];
                double value = this.base.getValueAt(location);
                while (maxIndex < maxLocations.length && i + samplingDistance > maxLocations[maxIndex]) {
                    if (value < this.base.getValueAt(maxLocations[maxIndex])) {
                        location = maxLocations[maxIndex];
                        value = this.base.getValueAt(location);
                    }
                    ++maxIndex;
                }
                result.add(new DataSetEntry(location, value, (Object)value));
                continue;
            }
            result.add(new DataSetEntry(i, this.base.getValueAt(i), (Object)this.base.getValueAt(i)));
        }
        if (result.size() > 1 && result.size() < 5) {
            result.add(0, new DataSetEntry(result.get(0).getLocation(), 0.0, null));
            result.add(new DataSetEntry(result.get(result.size() - 1).getLocation(), 0.0, null));
        }
        if (result.size() == 1) {
            DataSetEntry entry = new DataSetEntry();
            entry.setLocation(result.get(0).getLocation());
            entry.setValue(this.base.getDefaultValue());
            result.add(entry);
        }
        if (result.isEmpty()) {
            result.add(new DataSetEntry(0.0, 0.0, null));
        }
        return result;
    }

    public HighlightModel getHighlightModel() {
        return new PointHighlightModel();
    }

    public double getValueAt(double location) {
        return this.base.getValueAt(location);
    }
}

