/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr;

import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.prediction.NMRChartColorPicker;
import chemaxon.calculations.ui.nmr.prediction.NMRChartComponent;
import chemaxon.calculations.ui.nmr.prediction.NMRResultView;
import chemaxon.calculations.ui.nmr.prediction.QuickHelp;
import chemaxon.calculations.ui.nmr.report.ReportPageFormatAccessory;
import chemaxon.chart.dataset.DataSet;
import chemaxon.chart.gui.GuidelineChartComponent;
import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.modules.MolFileFilter;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;

public class NMRPrediction {
    private final NMRResultView nmrView;
    private JFileChooser fileChooser;
    private JFileChooser spectrumFileChooser;
    private JMenu unitMenu;
    private JFrame nmrFrame;
    private static Properties properties;
    private static final File PROPERTY_FILE;
    private static final String DEFAULT_PROPERTY_PATH = "/chemaxon/calculations/ui/nmr/nmr.properties";
    private static final String HELP_URL = "http://www.chemaxon.com/marvin/help/calculations/nmr.html";
    private boolean valid = true;
    private QuickHelp quickHelp = new QuickHelp();
    private JFileChooser pdfFileChooser;
    private Rectangle reportPageSize = PageSize.A4;
    private boolean keepSettingsInReport = false;

    public NMRPrediction(Molecule molecule, NMRSpectrum.Nucleus type) {
        this.nmrView = new NMRResultView();
        this.valid = this.nmrView.setMolecule(molecule.cloneMoleculeWithDocument(), type);
        if (this.valid && properties == null) {
            properties = new Properties();
            try {
                if (!PROPERTY_FILE.exists()) {
                    properties.load(NMRPrediction.class.getResourceAsStream(DEFAULT_PROPERTY_PATH));
                } else {
                    properties.load(new FileInputStream(PROPERTY_FILE));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public JFrame getFrame() {
        if (!this.valid) {
            return null;
        }
        if (this.nmrFrame == null) {
            this.nmrFrame = new JFrame((NMRSpectrum.Nucleus.C13.equals((Object)this.nmrView.getNucleusType()) ? "C" : "H") + "NMR Prediction (BETA)");
            this.nmrFrame.setSize(1024, 768);
            this.nmrFrame.setMinimumSize(new Dimension(800, 600));
            this.nmrFrame.setLayout(new BorderLayout());
            this.nmrFrame.setJMenuBar(this.getMenuBar());
            this.nmrFrame.setIconImage(new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_16.png")).getImage());
            this.nmrFrame.add((Component)this.nmrView, "Center");
            this.nmrFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    try {
                        File nmrDirectory = DotfileUtil.getDotFile("/calculations/nmr");
                        if (!nmrDirectory.exists()) {
                            nmrDirectory.mkdirs();
                        }
                        properties.store(new FileOutputStream(PROPERTY_FILE), "NMR Prediction properties");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.nmrFrame;
    }

    private JMenuBar getMenuBar() {
        JMenuBar result = new JMenuBar();
        result.add(this.getFileMenu());
        result.add(this.getOptionsMenu());
        result.add(this.getViewMenu());
        result.add(this.getHelpMenu());
        result.add(Box.createHorizontalGlue());
        AbstractAction quickAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.quickHelp.setVisible(true);
            }
        };
        quickAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/help24.png")));
        quickAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/help16.png")));
        JMenuItem quickItem = new JMenuItem(quickAction);
        quickItem.setMinimumSize(quickItem.getPreferredSize());
        quickItem.setMaximumSize(quickItem.getPreferredSize());
        quickItem.setActionCommand("ActionText");
        quickItem.setOpaque(false);
        result.add(quickItem);
        return result;
    }

    private JMenu getHelpMenu() {
        JMenu result = new JMenu("Help");
        AbstractAction quickAction = new AbstractAction("Quick Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.quickHelp.setVisible(true);
            }
        };
        quickAction.putValue("MnemonicKey", 81);
        result.add(quickAction);
        AbstractAction helpAction = new AbstractAction("Help Contents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(NMRPrediction.HELP_URL);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        helpAction.putValue("MnemonicKey", 72);
        result.add(helpAction);
        return result;
    }

    private JMenu getOptionsMenu() {
        JMenu result = new JMenu("Options");
        if (NMRSpectrum.Nucleus.H1 == this.nmrView.getNucleusType()) {
            AbstractAction couplingAction = new AbstractAction("Proton Coupling"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    properties.setProperty("coupling", this.getValue("SwingSelectedKey").toString());
                    NMRPrediction.this.nmrView.setCoupling(Boolean.parseBoolean(properties.getProperty("coupling")));
                }
            };
            this.nmrView.setCoupling(Boolean.parseBoolean(properties.getProperty("coupling")));
            couplingAction.putValue("SwingSelectedKey", Boolean.parseBoolean(properties.getProperty("coupling")));
            couplingAction.putValue("MnemonicKey", 67);
            couplingAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_couple_24.png")));
            couplingAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_couple_16.png")));
            result.add(new JCheckBoxMenuItem(couplingAction));
            AbstractAction implicitHAction = new AbstractAction("Implicit Hydrogen Mode"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    properties.setProperty("implicitHmode", this.getValue("SwingSelectedKey").toString());
                    NMRPrediction.this.nmrView.setImplicitHMode(Boolean.parseBoolean(properties.getProperty("implicitHmode")));
                }
            };
            this.nmrView.setImplicitHMode(Boolean.parseBoolean(properties.getProperty("implicitHmode")));
            implicitHAction.putValue("SwingSelectedKey", Boolean.parseBoolean(properties.getProperty("implicitHmode")));
            implicitHAction.putValue("MnemonicKey", 72);
            result.add(new JCheckBoxMenuItem(implicitHAction));
        }
        result.add(this.getFrequencyMenu());
        return result;
    }

    private JMenu getViewMenu() {
        JMenu result = new JMenu("View");
        result.add(this.getRenderMenu());
        AbstractAction integralDisplayAction = new AbstractAction("Integral Curve"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("integral", this.getValue("SwingSelectedKey").toString());
                NMRPrediction.this.nmrView.setIntegralFunctionVisible(Boolean.parseBoolean(properties.getProperty("integral")));
            }
        };
        this.nmrView.setIntegralFunctionVisible(Boolean.parseBoolean(properties.getProperty("integral")));
        integralDisplayAction.putValue("SwingSelectedKey", Boolean.parseBoolean(properties.getProperty("integral")));
        integralDisplayAction.putValue("MnemonicKey", 67);
        integralDisplayAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_integral_2_24.png")));
        integralDisplayAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_integral_2_16.png")));
        result.add(new JCheckBoxMenuItem(integralDisplayAction));
        result.add(this.getUnitMenu());
        result.add(this.getDisplayInfromationMenu());
        result.add(this.getReferenceSpectrumMenu());
        AbstractAction selectionMultiplet = new AbstractAction("Select Individual Multiplets"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("multipletSelection", this.getValue("SwingSelectedKey").toString());
                NMRPrediction.this.nmrView.setMultipletSelection(Boolean.parseBoolean(properties.getProperty("multipletSelection")));
            }
        };
        this.nmrView.setMultipletSelection(Boolean.parseBoolean(properties.getProperty("multipletSelection")));
        selectionMultiplet.putValue("SwingSelectedKey", Boolean.parseBoolean(properties.getProperty("multipletSelection")));
        selectionMultiplet.putValue("MnemonicKey", 83);
        selectionMultiplet.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_selection_24.png")));
        selectionMultiplet.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_selection_16.png")));
        result.add(new JCheckBoxMenuItem(selectionMultiplet));
        AbstractAction setColorAction = new AbstractAction("Set Chart Colors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRChartColorPicker picker = new NMRChartColorPicker(NMRPrediction.this.nmrView);
                JOptionPane.showInputDialog(NMRPrediction.this.getFrame(), picker, "Chart color selector", 1);
            }
        };
        setColorAction.putValue("MnemonicKey", 79);
        setColorAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/color24.png")));
        setColorAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/color16.png")));
        result.add(setColorAction);
        AbstractAction selectionFollowingAction = new AbstractAction("Zoom Follows Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("following", this.getValue("SwingSelectedKey").toString());
                NMRPrediction.this.nmrView.setHighlightFollowing(Boolean.parseBoolean(properties.getProperty("following")));
            }
        };
        this.nmrView.setHighlightFollowing(Boolean.parseBoolean(properties.getProperty("following")));
        selectionFollowingAction.putValue("SwingSelectedKey", Boolean.parseBoolean(properties.getProperty("following")));
        selectionFollowingAction.putValue("MnemonicKey", 90);
        selectionFollowingAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_zoom_24.png")));
        selectionFollowingAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_zoom_16.png")));
        result.add(new JCheckBoxMenuItem(selectionFollowingAction));
        result.add(this.getZoomTypeMenu());
        AbstractAction zoomInAction = new AbstractAction("Zoom In"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.zoomIn();
            }
        };
        zoomInAction.putValue("MnemonicKey", 73);
        zoomInAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-in24.png")));
        zoomInAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-in16.png")));
        result.add(zoomInAction);
        AbstractAction zoomOutAction = new AbstractAction("Zoom Out"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.zoomOut();
            }
        };
        zoomOutAction.putValue("MnemonicKey", 79);
        zoomOutAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-out24.png")));
        zoomOutAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-out16.png")));
        result.add(zoomOutAction);
        AbstractAction resetZoomAction = new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.resetZoom();
            }
        };
        resetZoomAction.putValue("MnemonicKey", 82);
        resetZoomAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-all24.png")));
        resetZoomAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-all16.png")));
        result.add(resetZoomAction);
        return result;
    }

    private JMenu getFrequencyMenu() {
        final double[] freqs = NMRSpectrum.getMeaningfulFrequencies();
        JMenu result = new JMenu("NMR Prediction Frequency");
        result.setIcon(new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_hz_16.png")));
        ButtonGroup itemGroup = new ButtonGroup();
        for (int i = 0; i < freqs.length; ++i) {
            final int index = i;
            final JRadioButtonMenuItem item = new JRadioButtonMenuItem(freqs[i] + " MHz");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    item.setSelected(true);
                    properties.setProperty("frequency", Double.toString(freqs[index]));
                    NMRPrediction.this.nmrView.setFrequency(Double.valueOf(properties.getProperty("frequency")));
                }
            });
            result.add(item);
            itemGroup.add(item);
            if (!Double.valueOf(properties.getProperty("frequency")).equals(freqs[i])) continue;
            item.setSelected(true);
            this.nmrView.setFrequency(Double.valueOf(properties.getProperty("frequency")));
        }
        return result;
    }

    private JMenu getUnitMenu() {
        if (this.unitMenu == null) {
            this.unitMenu = new JMenu("Measurement Unit");
            ButtonGroup itemGroup = new ButtonGroup();
            AbstractAction hzAction = new AbstractAction("Hz"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    properties.setProperty("measurementUnit", NMRSpectrum.Unit.Hz.toString());
                    NMRPrediction.this.nmrView.setMeasurementUnit(NMRSpectrum.Unit.Hz);
                    if (NMRPrediction.this.nmrView.getReferenceSpectrum() != null) {
                        NMRPrediction.this.nmrView.getReferenceSpectrum().setUnit(NMRSpectrum.Unit.Hz);
                    }
                }
            };
            hzAction.putValue("SwingSelectedKey", NMRSpectrum.Unit.valueOf(properties.getProperty("measurementUnit")) == NMRSpectrum.Unit.Hz);
            hzAction.putValue("MnemonicKey", 72);
            JRadioButtonMenuItem hz = new JRadioButtonMenuItem(hzAction);
            AbstractAction ppmAction = new AbstractAction("ppm"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    properties.setProperty("measurementUnit", NMRSpectrum.Unit.ppm.toString());
                    NMRPrediction.this.nmrView.setMeasurementUnit(NMRSpectrum.Unit.ppm);
                    if (NMRPrediction.this.nmrView.getReferenceSpectrum() != null) {
                        NMRPrediction.this.nmrView.getReferenceSpectrum().setUnit(NMRSpectrum.Unit.ppm);
                    }
                }
            };
            ppmAction.putValue("SwingSelectedKey", NMRSpectrum.Unit.valueOf(properties.getProperty("measurementUnit")) == NMRSpectrum.Unit.ppm);
            ppmAction.putValue("MnemonicKey", 80);
            JRadioButtonMenuItem ppm = new JRadioButtonMenuItem(ppmAction);
            itemGroup.add(hz);
            itemGroup.add(ppm);
            this.unitMenu.add(hz);
            this.unitMenu.add(ppm);
            this.nmrView.setMeasurementUnit(NMRSpectrum.Unit.valueOf(properties.getProperty("measurementUnit")));
        }
        return this.unitMenu;
    }

    private JMenu getRenderMenu() {
        JMenu result = new JMenu("Spectrum Display");
        ButtonGroup itemGroup = new ButtonGroup();
        AbstractAction realAction = new AbstractAction("Realistic Spectrum"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.setRenderMode(DataSet.ValueType.LINE);
                properties.setProperty("renderMode", DataSet.ValueType.LINE.toString());
            }
        };
        realAction.putValue("SwingSelectedKey", DataSet.ValueType.valueOf((String)properties.getProperty("renderMode")) == DataSet.ValueType.LINE);
        realAction.putValue("MnemonicKey", 82);
        realAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_realistic_24_2.png")));
        realAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_realistic_16_2.png")));
        JRadioButtonMenuItem real = new JRadioButtonMenuItem(realAction);
        AbstractAction peaksAction = new AbstractAction("Line Spectrum"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.setRenderMode(DataSet.ValueType.LINEPEAKS);
                properties.setProperty("renderMode", DataSet.ValueType.LINEPEAKS.toString());
            }
        };
        peaksAction.putValue("SwingSelectedKey", DataSet.ValueType.valueOf((String)properties.getProperty("renderMode")) == DataSet.ValueType.LINEPEAKS);
        peaksAction.putValue("MnemonicKey", 76);
        peaksAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_realistic_24_1.png")));
        peaksAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_realistic_16_1.png")));
        JRadioButtonMenuItem peaks = new JRadioButtonMenuItem(peaksAction);
        result.add(real);
        result.add(peaks);
        itemGroup.add(real);
        itemGroup.add(peaks);
        this.nmrView.setRenderMode(DataSet.ValueType.valueOf((String)properties.getProperty("renderMode")));
        return result;
    }

    private JMenu getFileMenu() {
        JMenu result = new JMenu("File");
        AbstractAction export = new AbstractAction("Export to Molfile"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.exportMolecule();
            }
        };
        export.putValue("MnemonicKey", 69);
        export.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save24.png")));
        export.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save16.png")));
        result.add(export);
        AbstractAction exportJCAMP = new AbstractAction("Export to JCAMP-DX"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.exportSpectrum();
            }
        };
        exportJCAMP.putValue("MnemonicKey", 80);
        exportJCAMP.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save24.png")));
        exportJCAMP.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save16.png")));
        result.add(exportJCAMP);
        AbstractAction importJCAMP = new AbstractAction("Import from JCAMP-DX"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.importSpectrum();
            }
        };
        importJCAMP.putValue("MnemonicKey", 73);
        importJCAMP.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/open24.png")));
        importJCAMP.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/open16.png")));
        result.add(importJCAMP);
        AbstractAction clear = new AbstractAction("Remove Imported Spectrum"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.removeReferenceSpectrum();
                NMRPrediction.this.getUnitMenu().setEnabled(true);
            }
        };
        clear.putValue("MnemonicKey", 82);
        clear.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_delete_24.png")));
        clear.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_delete_16.png")));
        result.add(clear);
        AbstractAction exportDefaultPDF = new AbstractAction("Export Prediction to PDF"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.exportPDF();
            }
        };
        exportDefaultPDF.putValue("MnemonicKey", 68);
        exportDefaultPDF.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save24.png")));
        exportDefaultPDF.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/save16.png")));
        result.add(exportDefaultPDF);
        result.add(this.getCopyMenu());
        AbstractAction exit = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrFrame.setVisible(false);
            }
        };
        exit.putValue("MnemonicKey", 88);
        exit.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_close_app_16.png")));
        exit.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_close_app_16.png")));
        result.add(exit);
        return result;
    }

    private void importSpectrum() {
        this.getSpectrumFileChooser().setDialogTitle("Import spectrum");
        int result = this.getSpectrumFileChooser().showOpenDialog(this.nmrFrame);
        if (result == 0) {
            File target = this.getSpectrumFileChooser().getSelectedFile();
            if (!target.exists()) {
                JOptionPane.showMessageDialog(this.nmrFrame, "The target file dose not exist!", "Warning", 2);
            } else {
                this.nmrView.importJCAMP(target.getAbsolutePath());
            }
        }
    }

    private void exportMolecule() {
        FileFilter filter;
        this.getMoleculeFileChooser().setDialogTitle("Export molecule and spectrum data");
        int result = this.getMoleculeFileChooser().showSaveDialog(this.nmrFrame);
        if (result == 0 && (filter = this.getMoleculeFileChooser().getFileFilter()) instanceof MolFileFilter) {
            int action;
            MolFileFilter mfilter = (MolFileFilter)filter;
            String fileName = this.getMoleculeFileChooser().getSelectedFile().getAbsolutePath();
            String ext = mfilter.getExtension();
            File file = fileName.lastIndexOf("." + ext) == -1 ? new File(fileName + "." + ext) : this.getMoleculeFileChooser().getSelectedFile();
            boolean save = true;
            if (file.exists() && (action = JOptionPane.showConfirmDialog(this.nmrFrame, "The target file exists already! Do you want to override?", "Warning", 0)) != 0) {
                save = false;
            }
            if (save) {
                this.nmrView.export(file.getAbsolutePath(), ext, "NMR Spectrum");
            }
        }
    }

    private void exportSpectrum() {
        this.getSpectrumFileChooser().setDialogTitle("Export spectrum");
        int result = this.getSpectrumFileChooser().showSaveDialog(this.nmrFrame);
        if (result == 0) {
            int action;
            String path = this.getSpectrumFileChooser().getSelectedFile().getAbsolutePath();
            if (!path.endsWith(".jdx")) {
                path = path + ".jdx";
            }
            File target = new File(path);
            boolean save = true;
            if (target.exists() && (action = JOptionPane.showConfirmDialog(this.nmrFrame, "The target file exists already! Do you want to override?", "Warning", 0)) != 0) {
                save = false;
            }
            if (save) {
                this.nmrView.exportJCAMP(target.getAbsolutePath());
            }
        }
    }

    private void exportPDF() {
        this.getPDFFileChooser().setDialogTitle("Export prediction");
        int result = this.getPDFFileChooser().showSaveDialog(this.nmrFrame);
        if (result == 0) {
            int action;
            String path = this.getPDFFileChooser().getSelectedFile().getAbsolutePath();
            if (!path.endsWith(".pdf")) {
                path = path + ".pdf";
            }
            File target = new File(path);
            boolean save = true;
            if (target.exists() && (action = JOptionPane.showConfirmDialog(this.nmrFrame, "The target file exists already! Do you want to override?", "Warning", 0)) != 0) {
                save = false;
            }
            if (save) {
                this.nmrView.exportPDF(target.getAbsolutePath(), this.reportPageSize, this.keepSettingsInReport);
            }
        }
    }

    private JFileChooser getMoleculeFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileFilter[] filters = NMRPrediction.createSaveFileFilters();
            FileFilter mrvFilter = null;
            for (FileFilter filter : filters) {
                this.fileChooser.addChoosableFileFilter(filter);
                if (!filter.getDescription().contains("mrv")) continue;
                mrvFilter = filter;
            }
            this.fileChooser.setFileFilter(mrvFilter);
        }
        return this.fileChooser;
    }

    private JFileChooser getSpectrumFileChooser() {
        if (this.spectrumFileChooser == null) {
            this.spectrumFileChooser = new JFileChooser();
            this.spectrumFileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "JCAMP-DX spectrum files (*.jdx)";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String filename = f.getName();
                    return filename.endsWith(".jdx");
                }
            });
        }
        return this.spectrumFileChooser;
    }

    private JFileChooser getPDFFileChooser() {
        if (this.pdfFileChooser == null) {
            this.pdfFileChooser = new JFileChooser();
            this.pdfFileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "Portable Document Format files (*.pdf)";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String filename = f.getName();
                    return filename.endsWith(".pdf");
                }
            });
            ReportPageFormatAccessory rpfa = new ReportPageFormatAccessory(this.pdfFileChooser);
            this.pdfFileChooser.setAccessory(rpfa);
            rpfa.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(ReportPageFormatAccessory.PROPERTY_KEY_PAGE_SIZE)) {
                        NMRPrediction.this.reportPageSize = ((ReportPageFormatAccessory.PageInfo)evt.getNewValue()).getSize();
                    }
                    if (evt.getPropertyName().equals(ReportPageFormatAccessory.PROPERTY_KEY_KEEP_VIEW)) {
                        NMRPrediction.this.keepSettingsInReport = (Boolean)evt.getNewValue();
                    }
                }
            });
        }
        return this.pdfFileChooser;
    }

    private JMenu getZoomTypeMenu() {
        JMenu result = new JMenu("Zoom Mode");
        ButtonGroup itemGroup = new ButtonGroup();
        AbstractAction domainAction = new AbstractAction("X-Axis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.setZoomType(GuidelineChartComponent.ZoomType.DOMAIN);
            }
        };
        domainAction.putValue("SwingSelectedKey", true);
        domainAction.putValue("MnemonicKey", 88);
        JRadioButtonMenuItem domainItem = new JRadioButtonMenuItem(domainAction);
        AbstractAction bothAction = new AbstractAction("Both Axes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.setZoomType(GuidelineChartComponent.ZoomType.BOTH);
            }
        };
        bothAction.putValue("SwingSelectedKey", false);
        bothAction.putValue("MnemonicKey", 66);
        JRadioButtonMenuItem bothItem = new JRadioButtonMenuItem(bothAction);
        result.add(domainItem);
        result.add(bothItem);
        itemGroup.add(domainItem);
        itemGroup.add(bothItem);
        return result;
    }

    private JMenu getDisplayInfromationMenu() {
        NMRChartComponent.InformationType current = NMRChartComponent.InformationType.valueOf(properties.getProperty("infoType"));
        this.nmrView.setInformationType(current);
        JMenu result = new JMenu("Spectrum Labels");
        ButtonGroup itemGroup = new ButtonGroup();
        AbstractAction numberDisplayAction = new AbstractAction("Atom Numbers"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("infoType", NMRChartComponent.InformationType.ATOM_NUMBER.toString());
                NMRPrediction.this.nmrView.setInformationType(NMRChartComponent.InformationType.ATOM_NUMBER);
            }
        };
        numberDisplayAction.putValue("SwingSelectedKey", current == NMRChartComponent.InformationType.ATOM_NUMBER);
        numberDisplayAction.putValue("MnemonicKey", 65);
        AbstractAction displayShiftAction = new AbstractAction("Chemical Shifts"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("shift", NMRChartComponent.InformationType.SHIFT.toString());
                NMRPrediction.this.nmrView.setInformationType(NMRChartComponent.InformationType.SHIFT);
            }
        };
        displayShiftAction.putValue("SwingSelectedKey", current == NMRChartComponent.InformationType.SHIFT);
        displayShiftAction.putValue("MnemonicKey", 83);
        AbstractAction noneAction = new AbstractAction("None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("infoType", NMRChartComponent.InformationType.NONE.toString());
                NMRPrediction.this.nmrView.setInformationType(NMRChartComponent.InformationType.NONE);
            }
        };
        noneAction.putValue("SwingSelectedKey", current == NMRChartComponent.InformationType.NONE);
        noneAction.putValue("MnemonicKey", 77);
        JRadioButtonMenuItem numberItem = new JRadioButtonMenuItem(numberDisplayAction);
        JRadioButtonMenuItem shiftItem = new JRadioButtonMenuItem(displayShiftAction);
        JRadioButtonMenuItem noneItem = new JRadioButtonMenuItem(noneAction);
        result.add(numberItem);
        result.add(shiftItem);
        result.add(noneItem);
        itemGroup.add(numberItem);
        itemGroup.add(shiftItem);
        itemGroup.add(noneItem);
        return result;
    }

    private JMenu getReferenceSpectrumMenu() {
        NMRChartComponent.InformationType current = NMRChartComponent.InformationType.valueOf(properties.getProperty("referenceInfoType"));
        this.nmrView.setReferenceInformationType(current);
        JMenu result = new JMenu("Reference Spectrum");
        ButtonGroup itemGroup = new ButtonGroup();
        AbstractAction shiftAction = new AbstractAction("Display Shifts"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("referenceInfoType", NMRChartComponent.InformationType.REFERENCE_MAXIMUMS.toString());
                NMRPrediction.this.nmrView.setReferenceInformationType(NMRChartComponent.InformationType.REFERENCE_MAXIMUMS);
            }
        };
        shiftAction.putValue("SwingSelectedKey", current == NMRChartComponent.InformationType.REFERENCE_MAXIMUMS);
        shiftAction.putValue("MnemonicKey", 83);
        AbstractAction noneAction = new AbstractAction("None"){

            @Override
            public void actionPerformed(ActionEvent e) {
                properties.setProperty("referenceInfoType", NMRChartComponent.InformationType.NONE.toString());
                NMRPrediction.this.nmrView.setReferenceInformationType(NMRChartComponent.InformationType.NONE);
            }
        };
        noneAction.putValue("SwingSelectedKey", current == NMRChartComponent.InformationType.NONE);
        noneAction.putValue("MnemonicKey", 77);
        JRadioButtonMenuItem shiftItem = new JRadioButtonMenuItem(shiftAction);
        JRadioButtonMenuItem noneItem = new JRadioButtonMenuItem(noneAction);
        result.add(shiftItem);
        result.add(noneItem);
        itemGroup.add(shiftItem);
        itemGroup.add(noneItem);
        return result;
    }

    public static final FileFilter[] createSaveFileFilters() {
        MFileFormat[] formats = MFileFormatUtil.findFormats(null, 1L, 385L);
        ArrayList<MolFileFilter> filters = new ArrayList<MolFileFilter>(formats.length);
        for (int i = 0; i < formats.length; ++i) {
            filters.add(new MolFileFilter(formats[i]));
        }
        Collections.sort(filters, new Comparator<FileFilter>(){

            @Override
            public int compare(FileFilter o1, FileFilter o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
        return filters.toArray(new FileFilter[filters.size()]);
    }

    private JMenu getCopyMenu() {
        JMenu result = new JMenu("Copy to Clipboard");
        AbstractAction spectrumAction = new AbstractAction("Spectrum Display"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.SPECTRUM);
            }
        };
        spectrumAction.putValue("MnemonicKey", 83);
        AbstractAction moleculeAction = new AbstractAction("Molecule"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.MOLECULE);
            }
        };
        moleculeAction.putValue("MnemonicKey", 77);
        AbstractAction couplingAction = new AbstractAction("Coupling Table"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.COUPLINGINFO);
            }
        };
        couplingAction.putValue("MnemonicKey", 67);
        AbstractAction atomAction = new AbstractAction("Atom Table"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.ATOMINFO);
            }
        };
        atomAction.putValue("MnemonicKey", 65);
        AbstractAction multipletAction = new AbstractAction("Multiplet Table"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.MULTIPLET);
            }
        };
        multipletAction.putValue("MnemonicKey", 85);
        AbstractAction guideAction = new AbstractAction("Spectrum Preview"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRPrediction.this.nmrView.copyToClipBoard(NMRResultView.ComponentType.MULTIPLET);
            }
        };
        guideAction.putValue("MnemonicKey", 71);
        result.add(new JMenuItem(spectrumAction));
        result.add(new JMenuItem(guideAction));
        result.add(new JMenuItem(moleculeAction));
        result.add(new JMenuItem(multipletAction));
        result.add(new JMenuItem(atomAction));
        result.add(new JMenuItem(couplingAction));
        return result;
    }

    static {
        PROPERTY_FILE = DotfileUtil.getDotFile("/calculations/nmr/nmr.properties");
    }
}

