/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.nmr.Multiplet;
import chemaxon.calculations.ui.nmr.prediction.Drawable;
import chemaxon.calculations.ui.nmr.prediction.NMRMoleculeViewer;
import chemaxon.marvin.modules.datatransfer.ClipboardHandler;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MarkController;
import chemaxon.marvin.swing.moleculeview.MarkableMoleculeViewComponent;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DefaultNMRMoleculeViewer
extends NMRMoleculeViewer
implements Drawable {
    private MarkableMoleculeViewComponent moleculeViewer;
    private MolPainterCommon painter = new MolPainterCommon();
    private Molecule molecule;

    public DefaultNMRMoleculeViewer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMoleculeViewer(), "Center");
    }

    private MarkableMoleculeViewComponent getMoleculeViewer() {
        if (this.moleculeViewer == null) {
            this.moleculeViewer = new MarkableMoleculeViewComponent();
            this.moleculeViewer.setRelativeScaleFactor(0.9);
            this.moleculeViewer.setMarkController(new MarkController(true, 1, true));
            this.moleculeViewer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 3) {
                        DefaultNMRMoleculeViewer.this.getPopUpMenu().show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
        }
        return this.moleculeViewer;
    }

    @Override
    public void removeColorMarks() {
        this.getMoleculeViewer().removeColorMarks();
    }

    @Override
    public void markAtoms(Multiplet multiplet, Color color) {
        if (multiplet != null) {
            int[] atomIndexes = multiplet.getAtomIndices();
            HashSet<Integer> toHighlight = new HashSet<Integer>();
            for (int index : atomIndexes) {
                toHighlight.add(index);
            }
            this.getMoleculeViewer().markAtoms(toHighlight, color);
        }
    }

    @Override
    public void setAtomNumbersVisible(boolean visible) {
        this.painter.setAtomNumbersVisible(visible);
        this.repaintMolecule();
    }

    private void repaintMolecule() {
        this.getMoleculeViewer().setDisplayOptions(this.painter.getDispopts(), this.painter.getDispoptsExt());
    }

    @Override
    public void setMolecule(Molecule molecule) {
        Molecule last = this.molecule;
        this.molecule = molecule;
        this.getMoleculeViewer().removeColorMarks();
        this.getMoleculeViewer().setMolecule(molecule);
        this.revalidate();
        this.repaint();
        this.firePropertyChange("molecule", last, molecule);
    }

    @Override
    public void removeColorMark(Color hoverColor) {
        this.getMoleculeViewer().removeColorMark(hoverColor);
    }

    @Override
    public Molecule getMolecule() {
        return this.molecule;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.getMoleculeViewer().addPropertyChangeListener(listener);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.getMoleculeViewer().setToolTipText(toolTipText);
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.paint(image.getGraphics());
        return image;
    }

    private JPopupMenu getPopUpMenu() {
        JPopupMenu menu = new JPopupMenu("Menu");
        AbstractAction copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardHandler.putImageToClipboard(DefaultNMRMoleculeViewer.this.getImage());
            }
        };
        copyAction.putValue("Name", "Copy to clipboard");
        menu.add(new JMenuItem(copyAction));
        return menu;
    }
}

