/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.prediction;

import chemaxon.calculations.ui.nmr.prediction.NMRResultView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NMRChartColorPicker
extends JPanel {
    private JColorChooser chooser;
    private JPanel selectionColorPanel;
    private JPanel spectrumColorPanel;
    private JPanel referenceColorPanel;
    private final NMRResultView resultView;

    public NMRChartColorPicker(NMRResultView resultView) {
        this.resultView = resultView;
        this.chooser = new JColorChooser();
        this.setSize(400, 450);
        this.setPreferredSize(new Dimension(400, 450));
        this.setLayout(new BorderLayout());
        JPanel selectedColorPanel = new JPanel(new GridLayout(4, 1));
        selectedColorPanel.add(this.getSpectrumColorPanel());
        selectedColorPanel.add(this.getReferenceColorPanel());
        selectedColorPanel.add(this.getSelectionColorPanel());
        this.add((Component)selectedColorPanel, "North");
        this.add((Component)this.chooser, "Center");
    }

    private JPanel getSelectionColorPanel() {
        if (this.selectionColorPanel == null) {
            this.selectionColorPanel = new JPanel();
            this.selectionColorPanel.setLayout(new BoxLayout(this.selectionColorPanel, 0));
            final ColorRectangle colorLabel = new ColorRectangle();
            colorLabel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.selectionColorPanel.add(Box.createHorizontalStrut(5));
            this.selectionColorPanel.add(colorLabel);
            this.selectionColorPanel.add(Box.createHorizontalStrut(5));
            this.selectionColorPanel.add(new JLabel("Selection color"));
            this.selectionColorPanel.add(Box.createHorizontalGlue());
            JButton colorPickerButton = new JButton("Select");
            colorLabel.setBackground(this.resultView.getHighlightColor());
            colorPickerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor() != null) {
                        colorLabel.setBackground(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                        NMRChartColorPicker.this.resultView.setHighlightColor(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                    }
                }
            });
            this.selectionColorPanel.add(colorPickerButton);
        }
        return this.selectionColorPanel;
    }

    private JPanel getReferenceColorPanel() {
        if (this.referenceColorPanel == null) {
            this.referenceColorPanel = new JPanel();
            this.referenceColorPanel.setLayout(new BoxLayout(this.referenceColorPanel, 0));
            final ColorRectangle colorLabel = new ColorRectangle();
            colorLabel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.referenceColorPanel.add(Box.createHorizontalStrut(5));
            this.referenceColorPanel.add(colorLabel);
            this.referenceColorPanel.add(Box.createHorizontalStrut(5));
            this.referenceColorPanel.add(new JLabel("Reference spectrum color"));
            this.referenceColorPanel.add(Box.createHorizontalGlue());
            JButton colorPickerButton = new JButton("Select");
            colorLabel.setBackground(this.resultView.getReferenceColor());
            colorLabel.setOpaque(true);
            colorPickerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor() != null) {
                        colorLabel.setBackground(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                        NMRChartColorPicker.this.resultView.setReferenceColor(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                    }
                }
            });
            this.referenceColorPanel.add(colorPickerButton);
        }
        return this.referenceColorPanel;
    }

    private JPanel getSpectrumColorPanel() {
        if (this.spectrumColorPanel == null) {
            this.spectrumColorPanel = new JPanel();
            this.spectrumColorPanel.setLayout(new BoxLayout(this.spectrumColorPanel, 0));
            final ColorRectangle colorLabel = new ColorRectangle();
            colorLabel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.spectrumColorPanel.add(Box.createHorizontalStrut(5));
            this.spectrumColorPanel.add(colorLabel);
            this.spectrumColorPanel.add(Box.createHorizontalStrut(5));
            this.spectrumColorPanel.add(new JLabel("Predicted spectrum color"));
            this.spectrumColorPanel.add(Box.createHorizontalGlue());
            JButton colorPickerButton = new JButton("Select");
            colorLabel.setBackground(this.resultView.getSpectrumColor());
            colorLabel.setOpaque(true);
            colorPickerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor() != null) {
                        colorLabel.setBackground(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                        NMRChartColorPicker.this.resultView.setSpectrumColor(NMRChartColorPicker.this.chooser.getSelectionModel().getSelectedColor());
                    }
                }
            });
            this.spectrumColorPanel.add(colorPickerButton);
        }
        return this.spectrumColorPanel;
    }

    private class ColorRectangle
    extends JPanel {
        private static final int SIZE = 12;

        public ColorRectangle() {
            this.setSize(24, 12);
            this.setPreferredSize(this.getSize());
            this.setMaximumSize(this.getSize());
            this.setMinimumSize(this.getSize());
            this.setOpaque(true);
        }
    }
}

