/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.report;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReportPageFormatAccessory
extends JPanel {
    public static String PROPERTY_KEY_PAGE_SIZE = "pageSize";
    public static String PROPERTY_KEY_KEEP_VIEW = "keepView";
    private JComboBox pageSizeBox;
    private JCheckBox keepViewSettingsBox;
    private static final PageInfo[] PAGE_SIZES = new PageInfo[]{new PageInfo("11 X 17", PageSize._11X17), new PageInfo("A0", PageSize.A0), new PageInfo("A1", PageSize.A1), new PageInfo("A2", PageSize.A2), new PageInfo("A3", PageSize.A3), new PageInfo("A4", PageSize.A4), new PageInfo("A5", PageSize.A5), new PageInfo("B0", PageSize.B0), new PageInfo("B1", PageSize.B1), new PageInfo("B2", PageSize.B2), new PageInfo("B3", PageSize.B3), new PageInfo("B4", PageSize.B4), new PageInfo("B5", PageSize.B5), new PageInfo("B6", PageSize.B6), new PageInfo("Executive", PageSize.EXECUTIVE), new PageInfo("Half letter", PageSize.HALFLETTER), new PageInfo("Ledger", PageSize.LEDGER), new PageInfo("Legal", PageSize.LEGAL), new PageInfo("Letter", PageSize.LETTER), new PageInfo("Postcard", PageSize.POSTCARD), new PageInfo("Tabloid", PageSize.TABLOID)};

    public ReportPageFormatAccessory(JFileChooser chooser) {
        DefaultComboBoxModel<PageInfo> model = new DefaultComboBoxModel<PageInfo>(PAGE_SIZES);
        this.pageSizeBox = new JComboBox<PageInfo>(model);
        this.pageSizeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReportPageFormatAccessory.this.firePropertyChange(PROPERTY_KEY_PAGE_SIZE, null, ReportPageFormatAccessory.this.pageSizeBox.getSelectedItem());
            }
        });
        this.keepViewSettingsBox = new JCheckBox("Keep view settings");
        this.keepViewSettingsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReportPageFormatAccessory.this.firePropertyChange(PROPERTY_KEY_KEEP_VIEW, !ReportPageFormatAccessory.this.keepViewSettingsBox.isSelected(), ReportPageFormatAccessory.this.keepViewSettingsBox.isSelected());
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.pageSizeBox.setSelectedItem(PAGE_SIZES[5]);
        this.setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel("Page Size:");
        label.setAlignmentX(0.0f);
        content.add((Component)label, "North");
        content.add((Component)this.pageSizeBox, "Center");
        content.add((Component)this.keepViewSettingsBox, "South");
        this.add((Component)content, "North");
    }

    public static class PageInfo {
        private String text;
        private Rectangle size;

        public PageInfo(String text, Rectangle size) {
            this.text = text;
            this.size = size;
        }

        public String toString() {
            return this.text;
        }

        public Rectangle getSize() {
            return this.size;
        }
    }
}

