/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculations.ui.nmr.viewer;

import chemaxon.calculations.nmr.MeasuredNMRSpectrum;
import chemaxon.calculations.nmr.NMRSpectrum;
import chemaxon.calculations.ui.nmr.NMRPrediction;
import chemaxon.calculations.ui.nmr.SpectrumUtility;
import chemaxon.calculations.ui.nmr.TextStatusBar;
import chemaxon.chart.dataset.DataSet;
import chemaxon.chart.dataset.DataSource;
import chemaxon.chart.dataset.DataSourceFactory;
import chemaxon.chart.dataset.Interval;
import chemaxon.chart.gui.GuidelineChartComponent;
import chemaxon.chart.gui.ZoomableChartComponent;
import chemaxon.chart.model.Chart;
import chemaxon.chart.model.ChartEntry;
import chemaxon.edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class NMRSpectrumView {
    private JFrame mainFrame;
    private GuidelineChartComponent guide;
    private ZoomableChartComponent zoomed;
    private GuidelineChartComponent.ZoomType zoomType = GuidelineChartComponent.ZoomType.DOMAIN;
    private JFileChooser spectrumFileChooser;
    private MeasuredNMRSpectrum base;
    private JMenuBar menuBar;
    private JMenu viewMenu;
    private JMenu unitMenu;
    private TextStatusBar statusBar;
    private static final String HELP_URL = "http://www.chemaxon.com/marvin/help/calculations/nmrview.html";
    private boolean displayMaxPlaces = true;
    private Action hzAction;
    private Action ppmAction;

    public NMRSpectrumView() {
        Border border = BorderFactory.createBevelBorder(1);
        this.getZoomed().setBorder(border);
        this.getGuide().setBorder(border);
    }

    public void setSpectrum(MeasuredNMRSpectrum spectrum) {
        this.base = spectrum;
        Chart chart1 = this.createChart(spectrum);
        Chart chart2 = this.createChart(spectrum);
        chart2.setAxisXName(spectrum.getXLabel() == null ? "Frequency (" + spectrum.getUnit().toString() + ")" : spectrum.getXLabel());
        chart2.setAxisYName(spectrum.getYLabel() == null ? "Intensity" : spectrum.getYLabel());
        if (this.displayMaxPlaces && spectrum.getLocalMaximumPlaces() != null && spectrum.getLocalMaximumPlaces().length != 0) {
            chart2.add(SpectrumUtility.createLocalMaxChart(spectrum));
        }
        this.getZoomed().setChart(chart2);
        this.getGuide().setChart(chart1);
        this.viewMenu.setEnabled(true);
        if (this.base.getNucleus() != null) {
            this.getStatusBar().setComponentAt(0, "Nucleus: " + this.base.getNucleus().toString());
        }
        if (!Double.valueOf(this.base.getFrequency()).equals(0.0)) {
            this.getStatusBar().setComponentAt(1, "Frequency: " + SpectrumUtility.FORMATTER.format(this.base.getFrequency()));
        }
        if (this.base.getOwner() != null) {
            this.getStatusBar().setComponentAt(2, "Owner: " + this.base.getOwner());
        }
        this.getZoomed().repaint();
        this.getGuide().repaint();
    }

    private Chart createChart(MeasuredNMRSpectrum spectrum) {
        Chart chart = new Chart();
        DataSource source = DataSourceFactory.createSource((double[])spectrum.getXValues(), (double[])spectrum.getYValues(), (DataSet.ValueType)DataSet.ValueType.LINE);
        chart.add(new ChartEntry(source, false, Color.black));
        return chart;
    }

    private ZoomableChartComponent getZoomed() {
        if (this.zoomed == null) {
            this.zoomed = new ZoomableChartComponent();
            this.zoomed.setType(this.zoomType);
            this.zoomed.setMinimumDomain(0.01);
            this.zoomed.setMinimumRange(0.01);
            this.zoomed.getTransformer().setReverseDomain(true);
            this.zoomed.getOptions().setGridlineColor(new Color(220, 220, 220));
            this.zoomed.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("domain")) {
                        NMRSpectrumView.this.getGuide().setArea((Interval)evt.getNewValue(), NMRSpectrumView.this.getGuide().getRange());
                    }
                    if (evt.getPropertyName().equals("range")) {
                        NMRSpectrumView.this.getGuide().setArea(NMRSpectrumView.this.getGuide().getDomain(), (Interval)evt.getNewValue());
                    }
                }
            });
            this.zoomed.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    if (NMRSpectrumView.this.zoomed.getOptions().isValid()) {
                        StringBuilder builder = new StringBuilder("X = ");
                        builder.append(SpectrumUtility.FORMATTER.format(NMRSpectrumView.this.zoomed.getTransformer().getDomainElement(event.getPoint().x)));
                        builder.append(" ");
                        builder.append(NMRSpectrumView.this.base.getUnit().toString());
                        builder.append("; Y = ");
                        builder.append(SpectrumUtility.FORMATTER.format(NMRSpectrumView.this.zoomed.getTransformer().getRangeElement(event.getPoint().y)));
                        NMRSpectrumView.this.getStatusBar().setComponentAt(4, builder.toString());
                    }
                }
            });
        }
        return this.zoomed;
    }

    private GuidelineChartComponent getGuide() {
        if (this.guide == null) {
            this.guide = new GuidelineChartComponent();
            this.guide.setType(this.zoomType);
            this.guide.setMinimumDomain(0.01);
            this.guide.setMinimumRange(0.01);
            this.guide.getTransformer().setReverseDomain(true);
            this.guide.getPropertyChangeSupport().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("domain")) {
                        NMRSpectrumView.this.zoomed.setVisibleArea((Interval)evt.getNewValue(), NMRSpectrumView.this.getZoomed().getVisibleRange());
                    }
                    if (evt.getPropertyName().equals("range")) {
                        NMRSpectrumView.this.zoomed.setVisibleArea(NMRSpectrumView.this.getZoomed().getVisibleDomain(), (Interval)evt.getNewValue());
                    }
                }
            });
            this.guide.setPreferredSize(new Dimension(150, 100));
        }
        return this.guide;
    }

    private void setZoomType(GuidelineChartComponent.ZoomType type) {
        this.getGuide().setType(type);
        this.getZoomed().setType(type);
    }

    public JFrame getFrame() {
        if (this.mainFrame == null) {
            this.mainFrame = new JFrame("NMR Spectrum Viewer");
            this.mainFrame.setSize(640, 480);
            this.mainFrame.setIconImage(new ImageIcon(NMRSpectrumView.class.getResource("/chemaxon/icons/marvin/calculations/nmr/predictor_48.png")).getImage());
            this.mainFrame.setLayout(new BorderLayout());
            JPanel chartPanel = new JPanel(new BorderLayout());
            chartPanel.add((Component)this.getGuide(), "North");
            chartPanel.add((Component)this.getZoomed(), "Center");
            this.mainFrame.add((Component)this.getStatusBar(), "South");
            this.mainFrame.add((Component)this.getMenuBar(), "North");
            this.mainFrame.add((Component)chartPanel, "Center");
            this.viewMenu.setEnabled(false);
        }
        return this.mainFrame;
    }

    private TextStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new TextStatusBar(new int[]{0, 20, 20, 20, -1, 0});
        }
        return this.statusBar;
    }

    private JMenuBar getMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.getFileMenu());
        this.menuBar.add(this.getViewMenu());
        this.menuBar.add(this.getHelpMenu());
        return this.menuBar;
    }

    private JMenu getHelpMenu() {
        JMenu result = new JMenu("Help");
        AbstractAction helpContent = new AbstractAction("Help Contents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(NMRSpectrumView.HELP_URL);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        helpContent.putValue("MnemonicKey", 72);
        helpContent.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/help24.png")));
        helpContent.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/help16.png")));
        result.add(helpContent);
        return result;
    }

    private JMenu getFileMenu() {
        JMenu result = new JMenu("File");
        AbstractAction importJCAMP = new AbstractAction("Import from JCAMP-DX"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.importSpectrum();
            }
        };
        importJCAMP.putValue("ShortDescription", "Import a spectrum from JCAMP-DX file.");
        importJCAMP.putValue("MnemonicKey", 73);
        importJCAMP.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/open24.png")));
        importJCAMP.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/open16.png")));
        result.add(importJCAMP);
        AbstractAction exit = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.getFrame().setVisible(false);
            }
        };
        exit.putValue("ShortDescription", "Exit the application");
        exit.putValue("MnemonicKey", 88);
        exit.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_close_app_16.png")));
        exit.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/calculations/nmr/nmr_close_app_16.png")));
        result.add(exit);
        return result;
    }

    private JMenu getViewMenu() {
        this.viewMenu = new JMenu("View");
        this.viewMenu.add(this.getUnitMenu());
        this.viewMenu.add(this.getZoomTypeMenu());
        AbstractAction maxAction = new AbstractAction("Display local maximum places"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.displayMaxPlaces = !NMRSpectrumView.this.displayMaxPlaces;
                NMRSpectrumView.this.setSpectrum(NMRSpectrumView.this.base);
            }
        };
        maxAction.putValue("SwingSelectedKey", this.displayMaxPlaces);
        maxAction.putValue("MnemonicKey", 77);
        this.viewMenu.add(new JCheckBoxMenuItem(maxAction));
        AbstractAction zoomInAction = new AbstractAction("Zoom In"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.getZoomed().zoomIn();
            }
        };
        zoomInAction.putValue("ShortDescription", "Zoom in in NMR chart");
        zoomInAction.putValue("MnemonicKey", 73);
        zoomInAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-in24.png")));
        zoomInAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-in16.png")));
        this.viewMenu.add(zoomInAction);
        AbstractAction zoomOutAction = new AbstractAction("Zoom Out"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.getZoomed().zoomOut();
            }
        };
        zoomOutAction.putValue("ShortDescription", "Zoom out in NMR chart");
        zoomOutAction.putValue("MnemonicKey", 79);
        zoomOutAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-out24.png")));
        zoomOutAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-out16.png")));
        this.viewMenu.add(zoomOutAction);
        AbstractAction resetZoomAction = new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.getZoomed().setVisibleArea(new Interval((Comparable)Double.valueOf(NMRSpectrumView.this.base.getDomainMin()), (Comparable)Double.valueOf(NMRSpectrumView.this.base.getDomainMax())), new Interval((Comparable)Double.valueOf(NMRSpectrumView.this.base.getRangeMin()), (Comparable)Double.valueOf(NMRSpectrumView.this.base.getRangeMax())));
            }
        };
        resetZoomAction.putValue("ShortDescription", "Reset zoom on NMR chart");
        resetZoomAction.putValue("MnemonicKey", 82);
        resetZoomAction.putValue("SwingLargeIconKey", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-all24.png")));
        resetZoomAction.putValue("SmallIcon", new ImageIcon(NMRPrediction.class.getResource("/chemaxon/icons/marvin/zoom-all16.png")));
        this.viewMenu.add(resetZoomAction);
        return this.viewMenu;
    }

    private JMenu getZoomTypeMenu() {
        JMenu result = new JMenu("Zoom Mode");
        result.setToolTipText("Select a zoom mode");
        ButtonGroup itemGroup = new ButtonGroup();
        AbstractAction domainAction = new AbstractAction("X-Axis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.setZoomType(GuidelineChartComponent.ZoomType.DOMAIN);
            }
        };
        domainAction.putValue("SwingSelectedKey", true);
        domainAction.putValue("ShortDescription", "Set the zoom mode to zoom on domain only");
        domainAction.putValue("MnemonicKey", 68);
        JRadioButtonMenuItem domainItem = new JRadioButtonMenuItem(domainAction);
        AbstractAction bothAction = new AbstractAction("Both Axes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NMRSpectrumView.this.setZoomType(GuidelineChartComponent.ZoomType.BOTH);
            }
        };
        bothAction.putValue("SwingSelectedKey", false);
        bothAction.putValue("ShortDescription", "Set the zoom mode to zoom on both domain and range");
        bothAction.putValue("MnemonicKey", 66);
        JRadioButtonMenuItem bothItem = new JRadioButtonMenuItem(bothAction);
        result.add(domainItem);
        result.add(bothItem);
        itemGroup.add(domainItem);
        itemGroup.add(bothItem);
        return result;
    }

    private JMenu getUnitMenu() {
        if (this.unitMenu == null) {
            this.unitMenu = new JMenu("Measurement Unit");
            ButtonGroup itemGroup = new ButtonGroup();
            this.hzAction = new AbstractAction("Hz"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NMRSpectrumView.this.setUnit(NMRSpectrum.Unit.Hz);
                }
            };
            this.hzAction.putValue("SwingSelectedKey", false);
            this.hzAction.putValue("MnemonicKey", 72);
            JRadioButtonMenuItem hz = new JRadioButtonMenuItem(this.hzAction);
            this.ppmAction = new AbstractAction("ppm"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NMRSpectrumView.this.setUnit(NMRSpectrum.Unit.ppm);
                }
            };
            this.ppmAction.putValue("SwingSelectedKey", true);
            this.ppmAction.putValue("MnemonicKey", 80);
            JRadioButtonMenuItem ppm = new JRadioButtonMenuItem(this.ppmAction);
            itemGroup.add(hz);
            itemGroup.add(ppm);
            this.unitMenu.add(hz);
            this.unitMenu.add(ppm);
        }
        return this.unitMenu;
    }

    private void setUnit(NMRSpectrum.Unit unit) {
        this.base.setUnit(unit);
        this.setSpectrum(this.base);
        if (unit == NMRSpectrum.Unit.Hz) {
            this.ppmAction.putValue("SwingSelectedKey", false);
            this.hzAction.putValue("SwingSelectedKey", true);
        } else {
            this.ppmAction.putValue("SwingSelectedKey", true);
            this.hzAction.putValue("SwingSelectedKey", false);
        }
    }

    private void importSpectrum() {
        int result = this.getSpectrumFileChooser().showOpenDialog(this.getFrame());
        if (result == 0) {
            File target = this.getSpectrumFileChooser().getSelectedFile();
            if (!target.exists()) {
                JOptionPane.showMessageDialog(this.getFrame(), "The target file does not exist!", "Warning", 2);
            } else {
                try {
                    this.setSpectrum(SpectrumUtility.importJCAMP(target.getAbsolutePath(), 100.0));
                    this.setUnit(this.base.getUnit());
                    if (this.base != null && this.base.getTitle() != null) {
                        this.getFrame().setTitle(this.base.getTitle() + " - NMR Spectrum Viewer");
                    } else if (this.base != null) {
                        this.getFrame().setTitle(target.getAbsolutePath() + " - NMR Spectrum Viewer");
                    }
                    this.getStatusBar().setComponentAt(3, "File: " + target.getName());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.getFrame(), "The selected file could not be imported!", "Import error", 0);
                }
            }
        }
    }

    private JFileChooser getSpectrumFileChooser() {
        if (this.spectrumFileChooser == null) {
            this.spectrumFileChooser = new JFileChooser();
            this.spectrumFileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "JCAMP-DX spectrum files (*.jdx)";
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String filename = f.getName();
                    return filename.endsWith(".jdx");
                }
            });
        }
        return this.spectrumFileChooser;
    }
}

