/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculator;

import chemaxon.struc.Molecule;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class CalculatorFormatter {
    protected static String SEPARATOR = "\t";
    DecimalFormat format = new DecimalFormat("##.##");

    public FormattedResult convert(Object o) {
        StringBuffer result = new StringBuffer();
        if (o == null) {
            return null;
        }
        List list = null;
        if (o instanceof Object[]) {
            list = Arrays.asList((Object[])o);
        } else if (o instanceof List) {
            list = (List)o;
        }
        if (list != null) {
            Object[] array = list.toArray();
            for (int i = 0; i < array.length; ++i) {
                result.append(this.convertSingle(this.format(array[i])));
                if (i >= array.length - 1) continue;
                result.append(SEPARATOR);
            }
        } else {
            result.append(this.format(this.convertSingle(o)));
        }
        return new FormattedResult(result.toString());
    }

    protected String convertSingle(Object o) {
        return o.toString();
    }

    public boolean needHeader() {
        return true;
    }

    public Object format(Object o) {
        if (o instanceof Double) {
            if (Double.isNaN((Double)o)) {
                return "";
            }
            return this.format.format((Double)o);
        }
        return o;
    }

    public String getHeader(String command) {
        return command;
    }

    public static class FormattedResult {
        String resultString = "";
        Molecule[] resultMolecules;
        String format;

        public FormattedResult(String result) {
            this.resultString = result;
        }

        public FormattedResult(Molecule[] result, String format2) {
            this.resultMolecules = result;
            this.format = format2;
        }

        public FormattedResult(Molecule[] result) {
            this(result, null);
        }

        public String getResult() {
            return this.resultString;
        }

        public Molecule[] getResultMolecules() {
            return this.resultMolecules;
        }

        public boolean isMoleculeResult() {
            return this.resultMolecules != null;
        }

        public String toString() {
            return this.isMoleculeResult() ? "" : this.resultString;
        }

        public String getResultFormat() {
            return this.format;
        }
    }
}

