/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.calculator;

import chemaxon.calculator.CalculatorLogger;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.struc.Molecule;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SimpleLogger
extends CalculatorLogger {
    private static final String MOLCOUNT_PROP = "_MOLCOUNT";
    private PrintStream os;

    public SimpleLogger(String path) throws FileNotFoundException {
        this.os = new PrintStream(new FileOutputStream(path));
    }

    public SimpleLogger() {
        this.os = System.err;
    }

    @Override
    protected void log(Molecule molecule, CalculatorLogger.Level logLevel, String command, String ... logData) {
        if (!logLevel.equals((Object)logLevel)) {
            return;
        }
        String id = "";
        if (molecule != null) {
            id = MPropHandler.convertToString(molecule.properties(), MOLCOUNT_PROP);
            id = id == null ? "" : id + "\t";
        }
        for (int j = 0; j < logData.length; ++j) {
            this.os.println(id + command + " : " + logData[j]);
        }
    }

    @Override
    public void log(Molecule mol, String command, Throwable ex) {
        this.log(mol, CalculatorLogger.Level.ERROR, command, ex.toString());
    }
}

