/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerDescriptor;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractStructureChecker
implements StructureChecker,
Licensable,
Cloneable,
PropertyChangeListener {
    protected final StructureCheckerErrorType errorType;
    private StructureCheckerDescriptor descriptor;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractStructureChecker(StructureCheckerErrorType errorType) {
        this.errorType = errorType;
        this.descriptor = new StructureCheckerDescriptor(this.getClass());
        this.descriptor.addPropertyChangeListener(this);
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public void setName(String name) {
        this.descriptor.setName(name);
    }

    @Override
    public void setNoErrorMessage(String noErrorMessage) {
        this.descriptor.setNoErrorMessage(noErrorMessage);
    }

    @Override
    public void setOneErrorMessage(String oneErrorMessage) {
        this.descriptor.setOneErrorMessage(oneErrorMessage);
    }

    @Override
    public void setMoreErrorMessage(String moreErrorMessage) {
        this.descriptor.setMoreErrorMessage(moreErrorMessage);
    }

    protected String getErrorDescription(int errorCount) {
        if (errorCount == 0) {
            return this.descriptor.getNoErrorMessage();
        }
        return errorCount == 1 ? errorCount + " " + this.descriptor.getOneErrorMessage() : errorCount + " " + this.descriptor.getMoreErrorMessage();
    }

    @Override
    public String getLocalMenuName() {
        return this.descriptor.getLocalMenuName();
    }

    @Override
    public void setLocalMenuName(String localMenuName) {
        this.descriptor.setLocalMenuName(localMenuName);
    }

    @Override
    public String getHelpText() {
        return this.descriptor.getHelpText();
    }

    @Override
    public void setHelpText(String helpText) {
        this.descriptor.setHelpText(helpText);
    }

    @Override
    public Icon getIcon() {
        return this.descriptor.getIcon();
    }

    @Override
    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Uperation is not supported anymore");
    }

    @Override
    public final StructureCheckerResult check(Molecule molecule) throws NullPointerException, LicenseException {
        if (molecule == null) {
            throw new NullPointerException("Molecule is null!");
        }
        this.checkLicense();
        HashMap<MolAtom, MolAtom> atomMap = new HashMap<MolAtom, MolAtom>();
        HashMap<MolBond, MolBond> bondMap = new HashMap<MolBond, MolBond>();
        Molecule moleculeToCheck = this.expandMolecule(molecule, atomMap, bondMap);
        StructureCheckerResult result = this.check1(moleculeToCheck);
        if (moleculeToCheck != molecule && result != null) {
            this.convertResult(molecule, moleculeToCheck, result, atomMap, bondMap);
        }
        return result;
    }

    protected abstract StructureCheckerResult check1(Molecule var1);

    protected Molecule expandMolecule(Molecule molecule, Map<MolAtom, MolAtom> atomMap, Map<MolBond, MolBond> bondMap) {
        int i;
        atomMap.clear();
        bondMap.clear();
        Molecule moleculeToCheck = molecule;
        Molecule clonedMolecule = molecule.cloneMolecule();
        for (i = 0; i < molecule.getAtomCount(); ++i) {
            atomMap.put(clonedMolecule.getAtom(i), molecule.getAtom(i));
        }
        for (i = 0; i < molecule.getBondCount(); ++i) {
            bondMap.put(clonedMolecule.getBond(i), molecule.getBond(i));
        }
        if (clonedMolecule.expandSgroups()) {
            moleculeToCheck = clonedMolecule;
        }
        return moleculeToCheck;
    }

    protected void convertResult(Molecule originalMolecule, Molecule expandedMolecule, StructureCheckerResult result, Map<MolAtom, MolAtom> atomMap, Map<MolBond, MolBond> bondMap) {
        int j;
        boolean found;
        int i;
        List<MolAtom> expandedAtomList = result.getAtoms();
        List<MolBond> expandedBondList = result.getBonds();
        for (i = 0; i < expandedAtomList.size(); ++i) {
            MolAtom keyAtom = expandedAtomList.get(i);
            if (atomMap.containsKey(keyAtom)) {
                expandedAtomList.set(i, atomMap.get(keyAtom));
                continue;
            }
            found = false;
            for (j = 0; j < expandedMolecule.getSgroupCount() && !found; ++j) {
                if (!(expandedMolecule.getSgroup(j) instanceof SuperatomSgroup) || !expandedMolecule.getSgroup(j).hasAtom(keyAtom)) continue;
                found = true;
                keyAtom = ((SuperatomSgroup)expandedMolecule.getSgroup(j)).getSuperAtom();
                if (!atomMap.containsKey(keyAtom)) continue;
                expandedAtomList.set(i, atomMap.get(keyAtom));
            }
        }
        for (i = 0; i < expandedBondList.size(); ++i) {
            MolBond keyBond = expandedBondList.get(i);
            if (bondMap.containsKey(keyBond)) {
                expandedBondList.set(i, bondMap.get(i));
                continue;
            }
            found = false;
            for (j = 0; j < expandedMolecule.getSgroupCount() && !found; ++j) {
                List<MolBond> bondList;
                if (!(expandedMolecule.getSgroup(j) instanceof SuperatomSgroup) || !(bondList = Arrays.asList(((SuperatomSgroup)expandedMolecule.getSgroup(j)).getSgroupGraph().getBondArray())).contains(keyBond)) continue;
                found = true;
                SgroupAtom keyAtom = ((SuperatomSgroup)expandedMolecule.getSgroup(j)).getSuperAtom();
                expandedAtomList.add(atomMap.get(keyAtom));
            }
            expandedBondList.set(i, null);
        }
        ArrayList<MolBond> updatedBondList = new ArrayList<MolBond>();
        for (int i2 = 0; i2 < expandedBondList.size(); ++i2) {
            MolBond bond = expandedBondList.get(i2);
            if (bond == null) continue;
            updatedBondList.add(bond);
        }
        result.setAtoms(expandedAtomList);
        result.setBonds(updatedBondList);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Structure Checker");
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Structure Checker");
    }

    @Override
    public void setLicenseEnvironment(String env) {
    }

    @Override
    public StructureCheckerErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getErrorCode() {
        return this.errorType.toString();
    }

    @Override
    public String getEditorClassName() {
        return this.descriptor.getEditorClassName();
    }

    @Override
    public String getDescription() {
        return this.descriptor.getDescription();
    }

    @Override
    public boolean isValid() {
        return !"".equals(this.getName());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public StructureChecker cloneItem() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AbstractStructureChecker clone() throws CloneNotSupportedException {
        AbstractStructureChecker clone = (AbstractStructureChecker)super.clone();
        clone.propertyChangeSupport = new PropertyChangeSupport(clone);
        clone.descriptor = this.descriptor.clone();
        return clone;
    }

    @Override
    public void setDescription(String description) {
        this.descriptor.setDescription(description);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public StructureCheckerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.descriptor)) {
            this.propertyChangeSupport.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.errorType == null ? 0 : this.errorType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStructureChecker other = (AbstractStructureChecker)obj;
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        return this.errorType == other.errorType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [description=" + this.getDescription() + ", errorType=" + (Object)((Object)this.errorType) + ", helpText=" + this.getHelpText() + ", icon=" + this.getIcon() + ", localMenuName=" + this.getLocalMenuName() + ", moreErrorMessage=" + this.descriptor.getMoreErrorMessage() + ", name=" + this.getName() + ", noErrorMessage=" + this.descriptor.getNoErrorMessage() + ", oneErrorMessage=" + this.descriptor.getOneErrorMessage() + "]";
    }
}

