/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.ComponentChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public abstract class AtomChecker
extends ComponentChecker<MolAtom> {
    public AtomChecker(StructureCheckerErrorType errorType) {
        super(errorType);
    }

    @Override
    protected int getComponentCount(Molecule molecule) {
        return molecule.getAtomCount();
    }

    @Override
    protected MolAtom getComponent(Molecule molecule, int i) {
        return molecule.getAtom(i);
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolAtom> atoms) {
        return atoms.isEmpty() ? null : new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), this.errorType, molecule, this.getErrorDescription(atoms.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

