/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.AtomQueryPropertyCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Atom Query Property Checker", localMenuName="Atom Query Property", description="Detects atoms having query properties", noErrorMessage="No atom query property found", oneErrorMessage="atom query property found", moreErrorMessage="atom query properties found", actionStringToken="atomqueryproperty", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.AtomQueryPropertyCheckerEditor")
public class AtomQueryPropertyChecker
extends AtomChecker {
    public static final String PROPERTY_KEY_HYDROGEN_COUNT = "hydrogenCount";
    public static final String PROPERTY_KEY_CONNECTION_COUNT = "connectionCount";
    public static final String PROPERTY_KEY_EXPLICIT_CONNECTION_COUNT = "explicitConnectionCount";
    public static final String PROPERTY_KEY_RING_COUNT = "ringCount";
    public static final String PROPERTY_KEY_IMPLICIT_HYDROGEN_COUNT = "implicitHydrogenCount";
    public static final String PROPERTY_KEY_SMALLEST_RING_SIZE = "smallestRingSize";
    public static final String PROPERTY_KEY_AROMATCITY = "aromaticity";
    public static final String PROPERTY_KEY_SUBSTITUTION_COUNT = "substitutionCount";
    public static final String PROPERTY_KEY_UNSATURATION = "unsaturation";
    public static final String PROPERTY_KEY_RING_BOND_COUNT = "ringBondCount";
    public static final String PROPERTY_KEY_AROMATICITY_CHECKING = "aromaticityChecking";
    public static final String PROPERTY_KEY_CONNECTION_COUNT_CHECKING = "conncetionCountChecking";
    public static final String PROPERTY_KEY_EXPLICIT_CONNECTION_COUNT_CHECKING = "explicitConnectionCountChecking";
    public static final String PROPERTY_KEY_HYDROGEN_COUNT_CHECKING = "hydrogenCountChecking";
    public static final String PROPERTY_KEY_IMPLICIT_HYDROGEN_COUNT_CHECKING = "implicitHydrogenCountChecking";
    public static final String PROPERTY_KEY_RING_BOND_COUNT_CHECKING = "ringBondCountChecking";
    public static final String PROPERTY_KEY_RING_COUNT_CHECKING = "ringCountChecking";
    public static final String PROPERTY_KEY_SMALLEST_RING_SIZE_CHECKING = "smallestRingSizeChecking";
    public static final String PROPERTY_KEY_SUBSTITUTION_COUNT_CHECKING = "substitutionCountChecing";
    public static final String PROPERTY_KEY_UNSATURATION_CHECKING = "unsaturationChecking";
    private static final String KEY_HYDROGEN_COUNT = "H";
    private static final String KEY_CONNECTION_COUNT = "X";
    private static final String KEY_EXPLICIT_CONNECTION_COUNT = "D";
    private static final String KEY_RING_COUNT = "R";
    private static final String KEY_IMPLICIT_HYDROGEN_COUNT = "h";
    private static final String KEY_SMALLEST_RING_SIZE = "r";
    private static final String KEY_AROMATCITY = "a";
    private static final String KEY_SUBSTITUTION_COUNT = "s";
    private static final String KEY_UNSATURATION = "u";
    private static final String KEY_RING_BOND_COUNT = "rb";
    @Persistent(alias="hydrogenCount")
    private boolean hydrogenCountChecking;
    @Persistent(alias="connectionCount")
    private boolean connectionCountChecking;
    @Persistent(alias="explicitConnectionCount")
    private boolean explicitConnectionCountChecking;
    @Persistent(alias="ringCount")
    private boolean ringCountChecking;
    @Persistent(alias="implicitHydrogenCount")
    private boolean implicitHydrogenCountChecking;
    @Persistent(alias="smallestRingSize")
    private boolean smallestRingSizeChecking;
    @Persistent(alias="aromaticity")
    private boolean aromaticityChecking;
    @Persistent(alias="substitutionCount")
    private boolean substitutionCountChecking;
    @Persistent(alias="unsaturation")
    private boolean unsaturationChecking;
    @Persistent(alias="ringBondCount")
    private boolean ringBondCountChecking;

    public AtomQueryPropertyChecker() {
        super(StructureCheckerErrorType.ATOM_QUERY_PROPERTY);
        this.setOptions(true);
    }

    private AtomQueryPropertyChecker(boolean hydrogenCount, boolean connectionCount, boolean explicitConnectionCount, boolean ringCount, boolean implicitHydrogenCount, boolean smallestRingSize, boolean aromaticity, boolean substitutionCount, boolean unsaturation, boolean ringBondCount) {
        super(StructureCheckerErrorType.ATOM_QUERY_PROPERTY);
        this.hydrogenCountChecking = hydrogenCount;
        this.connectionCountChecking = connectionCount;
        this.explicitConnectionCountChecking = explicitConnectionCount;
        this.ringCountChecking = ringCount;
        this.implicitHydrogenCountChecking = implicitHydrogenCount;
        this.smallestRingSizeChecking = smallestRingSize;
        this.aromaticityChecking = aromaticity;
        this.substitutionCountChecking = substitutionCount;
        this.unsaturationChecking = unsaturation;
        this.ringBondCountChecking = ringBondCount;
    }

    public AtomQueryPropertyChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.ATOM_QUERY_PROPERTY);
        this.setOptions(false);
        this.hydrogenCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_HYDROGEN_COUNT));
        this.connectionCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_CONNECTION_COUNT));
        this.explicitConnectionCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_EXPLICIT_CONNECTION_COUNT));
        this.ringCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_RING_COUNT));
        this.implicitHydrogenCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_IMPLICIT_HYDROGEN_COUNT));
        this.smallestRingSizeChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_SMALLEST_RING_SIZE));
        this.aromaticityChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_AROMATCITY));
        this.substitutionCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_SUBSTITUTION_COUNT));
        this.unsaturationChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_UNSATURATION));
        this.ringBondCountChecking = Boolean.parseBoolean(params.get(PROPERTY_KEY_RING_BOND_COUNT));
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        if (component.hasQProps()) {
            return this.hydrogenCountChecking && component.getQProp(KEY_HYDROGEN_COUNT) != null || this.connectionCountChecking && component.getQProp(KEY_CONNECTION_COUNT) != null || this.explicitConnectionCountChecking && component.getQProp(KEY_EXPLICIT_CONNECTION_COUNT) != null || this.ringCountChecking && component.getQProp(KEY_RING_COUNT) != null || this.implicitHydrogenCountChecking && component.getQProp(KEY_IMPLICIT_HYDROGEN_COUNT) != null || this.smallestRingSizeChecking && component.getQProp(KEY_SMALLEST_RING_SIZE) != null || this.aromaticityChecking && component.getQProp(KEY_AROMATCITY) != null || this.substitutionCountChecking && component.getQProp(KEY_SUBSTITUTION_COUNT) != null || this.unsaturationChecking && component.getQProp(KEY_UNSATURATION) != null || this.ringBondCountChecking && component.getQProp(KEY_RING_BOND_COUNT) != null;
        }
        return false;
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolAtom> atoms) {
        if (atoms.isEmpty()) {
            return null;
        }
        return new AtomQueryPropertyCheckerResult(this, atoms, molecule, this.getErrorDescription(atoms.size()), this.propertyList(), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AtomQueryPropertyChecker other = (AtomQueryPropertyChecker)obj;
            return this.hydrogenCountChecking == other.hydrogenCountChecking && this.connectionCountChecking == other.connectionCountChecking && this.explicitConnectionCountChecking == other.explicitConnectionCountChecking && this.ringCountChecking == other.ringCountChecking && this.implicitHydrogenCountChecking == other.implicitHydrogenCountChecking && this.smallestRingSizeChecking == other.smallestRingSizeChecking && this.aromaticityChecking == other.aromaticityChecking && this.substitutionCountChecking == other.substitutionCountChecking && this.unsaturationChecking == other.unsaturationChecking && this.ringBondCountChecking == other.ringBondCountChecking;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * ((Object)this.propertyList()).hashCode();
    }

    public boolean isAromaticityChecking() {
        return this.aromaticityChecking;
    }

    public boolean isConnectionCountChecking() {
        return this.connectionCountChecking;
    }

    public boolean isExplicitConnectionCountChecking() {
        return this.explicitConnectionCountChecking;
    }

    public boolean isHydrogenCountChecking() {
        return this.hydrogenCountChecking;
    }

    public boolean isImplicitHydrogenCountChecking() {
        return this.implicitHydrogenCountChecking;
    }

    public boolean isRingBondCountChecking() {
        return this.ringBondCountChecking;
    }

    public boolean isRingCountChecking() {
        return this.ringCountChecking;
    }

    public boolean isSmallestRingSizeChecking() {
        return this.smallestRingSizeChecking;
    }

    public boolean isSubstitutionCountChecking() {
        return this.substitutionCountChecking;
    }

    public boolean isUnsaturationChecking() {
        return this.unsaturationChecking;
    }

    private List<String> propertyList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.hydrogenCountChecking) {
            result.add(KEY_HYDROGEN_COUNT);
        }
        if (this.connectionCountChecking) {
            result.add(KEY_CONNECTION_COUNT);
        }
        if (this.explicitConnectionCountChecking) {
            result.add(KEY_EXPLICIT_CONNECTION_COUNT);
        }
        if (this.ringCountChecking) {
            result.add(KEY_RING_COUNT);
        }
        if (this.implicitHydrogenCountChecking) {
            result.add(KEY_IMPLICIT_HYDROGEN_COUNT);
        }
        if (this.smallestRingSizeChecking) {
            result.add(KEY_SMALLEST_RING_SIZE);
        }
        if (this.aromaticityChecking) {
            result.add(KEY_AROMATCITY);
        }
        if (this.substitutionCountChecking) {
            result.add(KEY_SUBSTITUTION_COUNT);
        }
        if (this.unsaturationChecking) {
            result.add(KEY_UNSATURATION);
        }
        if (this.ringBondCountChecking) {
            result.add(KEY_RING_BOND_COUNT);
        }
        return result;
    }

    public void setAromaticityChecking(boolean value) {
        boolean oldValue = this.aromaticityChecking;
        this.aromaticityChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_AROMATICITY_CHECKING, oldValue, value);
    }

    public void setConnectionCountChecking(boolean value) {
        boolean oldValue = this.connectionCountChecking;
        this.connectionCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_CONNECTION_COUNT_CHECKING, oldValue, value);
    }

    public void setExplicitConnectionCountChecking(boolean value) {
        boolean oldValue = this.explicitConnectionCountChecking;
        this.explicitConnectionCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_EXPLICIT_CONNECTION_COUNT_CHECKING, oldValue, value);
    }

    public void setHydrogenCountChecking(boolean value) {
        boolean oldValue = this.hydrogenCountChecking;
        this.hydrogenCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_HYDROGEN_COUNT_CHECKING, oldValue, value);
    }

    public void setImplicitHydrogenCountChecking(boolean value) {
        boolean oldValue = this.implicitHydrogenCountChecking;
        this.implicitHydrogenCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_IMPLICIT_HYDROGEN_COUNT_CHECKING, oldValue, value);
    }

    private void setOptions(boolean value) {
        this.hydrogenCountChecking = value;
        this.connectionCountChecking = value;
        this.explicitConnectionCountChecking = value;
        this.ringCountChecking = value;
        this.implicitHydrogenCountChecking = value;
        this.smallestRingSizeChecking = value;
        this.aromaticityChecking = value;
        this.substitutionCountChecking = value;
        this.unsaturationChecking = value;
        this.ringBondCountChecking = value;
    }

    public void setRingBondCountChecking(boolean value) {
        boolean oldValue = this.ringBondCountChecking;
        this.ringBondCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_RING_BOND_COUNT_CHECKING, oldValue, value);
    }

    public void setRingCountChecking(boolean value) {
        boolean oldValue = this.ringCountChecking;
        this.ringCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_RING_COUNT_CHECKING, oldValue, value);
    }

    public void setSmallestRingSizeChecking(boolean value) {
        boolean oldValue = this.smallestRingSizeChecking;
        this.smallestRingSizeChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SMALLEST_RING_SIZE_CHECKING, oldValue, value);
    }

    public void setSubstitutionCountChecking(boolean value) {
        boolean oldValue = this.substitutionCountChecking;
        this.substitutionCountChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SUBSTITUTION_COUNT_CHECKING, oldValue, value);
    }

    public void setUnsaturationChecking(boolean value) {
        boolean oldValue = this.unsaturationChecking;
        this.unsaturationChecking = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_UNSATURATION_CHECKING, oldValue, value);
    }

    @Override
    public String toString() {
        return this.getName() + " [" + this.propertyList().toString() + "]";
    }
}

