/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@CheckerInfo(name="Atom Type Checker", localMenuName="Atom Type", description="Detects atoms with the given types", noErrorMessage="No atom found with the given type", oneErrorMessage="atom of the given type found", moreErrorMessage="atoms of the given type found", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.AtomTypeCheckerEditor")
public class AtomTypeChecker
extends AtomChecker {
    public static final String PROPERTY_KEY_TYPES = "types";
    @Persistent
    protected List<String> types = new ArrayList<String>();

    protected AtomTypeChecker(StructureCheckerErrorType type) {
        super(type);
    }

    public AtomTypeChecker() {
        super(StructureCheckerErrorType.ATOM_TYPE);
    }

    public AtomTypeChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.ATOM_TYPE);
        if (params.containsKey(PROPERTY_KEY_TYPES)) {
            String[] data;
            for (String string : data = params.get(PROPERTY_KEY_TYPES).split(",")) {
                this.types.add(string.trim());
            }
        }
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        return this.types.contains(component.getSymbol());
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        List<String> oldValue = types;
        this.types = types;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_TYPES, oldValue, types);
    }
}

