/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@CheckerInfo(name="Attached Data Checker", localMenuName="Attached Data", description="Detects attached data", noErrorMessage="No attached data found", oneErrorMessage="atom found with attached data", moreErrorMessage="atoms found with attached data", actionStringToken="attacheddata")
public class AttachedDataChecker
extends AbstractStructureChecker {
    public AttachedDataChecker() {
        super(StructureCheckerErrorType.ATTACHED_DATA);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getSgroupCount() == 0) {
            return null;
        }
        ArrayList<Integer> dataIndeces = new ArrayList<Integer>();
        for (int i = 0; i < molecule.getSgroupCount(); ++i) {
            if (!(molecule.getSgroup(i) instanceof DataSgroup)) continue;
            dataIndeces.add(i);
        }
        if (dataIndeces.isEmpty()) {
            return null;
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        List<MolAtom> molAtoms = Arrays.asList(molecule.getAtomArray());
        for (Integer dataIndex : dataIndeces) {
            List<MolAtom> dataAtom = Arrays.asList(molecule.getSgroup(dataIndex).getAtomArray());
            for (MolAtom molAtom : dataAtom) {
                int atomIndex = molAtoms.indexOf(molAtom);
                if (atomIndex == -1) continue;
                atoms.add(molAtom);
            }
        }
        return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), this.errorType, molecule, this.getErrorDescription(dataIndeces.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

