/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.ComponentChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public abstract class BondChecker
extends ComponentChecker<MolBond> {
    public BondChecker(StructureCheckerErrorType errorType) {
        super(errorType);
    }

    @Override
    protected int getComponentCount(Molecule molecule) {
        return molecule.getBondCount();
    }

    @Override
    protected MolBond getComponent(Molecule molecule, int i) {
        return molecule.getBond(i);
    }

    @Override
    protected StructureCheckerResult createResult(Molecule molecule, List<MolBond> bonds) {
        return bonds.isEmpty() ? null : new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

