/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.calculations.stereo.Stereochemistry;
import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

@CheckerInfo(name="Chiral Flag Error Checker", localMenuName="Chiral Flag Error", description="Detects invalid chiral flags", noErrorMessage="No invalid chiral flag found", oneErrorMessage="invalid chiral flag found", moreErrorMessage="invalid chiral flags found", severity=CheckerSeverity.ERROR, actionStringToken="chiralflag")
public class ChiralFlagErrorChecker
extends AbstractStructureChecker {
    public ChiralFlagErrorChecker() {
        super(StructureCheckerErrorType.INVALID_CHIRAL_FLAG);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.isAbsStereo()) {
            if (StructureCheckerHelper.isChiral(molecule)) {
                List<MolAtom> atoms = this.getInvalidChiralCenters(molecule);
                if (atoms != null) {
                    return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), StructureCheckerErrorType.INVALID_CHIRAL_FLAG, molecule, this.getErrorDescription(1), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
                }
                atoms = this.getNotAbsoulteAtoms(molecule);
                if (atoms != null) {
                    return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), StructureCheckerErrorType.INVALID_CHIRAL_FLAG, molecule, this.getErrorDescription(1), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
                }
            } else {
                return new DefaultStructureCheckerResult(this, this.getInvalidChiralCenters(molecule), new ArrayList<MolBond>(), StructureCheckerErrorType.INVALID_CHIRAL_FLAG, molecule, this.getErrorDescription(1), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
            }
        }
        return null;
    }

    private List<MolAtom> getInvalidChiralCenters(Molecule mol) {
        ArrayList<MolAtom> result = null;
        Stereochemistry sc = new Stereochemistry();
        sc.setMolecule(mol);
        int[] centers = sc.chiralCenters();
        if (centers == null) {
            return result;
        }
        for (int i = 0; i < centers.length; ++i) {
            int chirality = mol.getChirality(centers[i]);
            if (chirality == 8 || chirality == 16) continue;
            if (result == null) {
                result = new ArrayList<MolAtom>();
            }
            result.add(mol.getAtom(centers[i]));
        }
        return result;
    }

    private List<MolAtom> getNotAbsoulteAtoms(Molecule mol) {
        ArrayList<MolAtom> result = null;
        Stereochemistry sc = new Stereochemistry();
        sc.setMolecule(mol);
        int[] centers = sc.chiralCenters();
        for (int i = 0; i < centers.length; ++i) {
            MolAtom center = mol.getAtom(centers[i]);
            if (center.getStereoGroupType() != 3) continue;
            if (result == null) {
                result = new ArrayList<MolAtom>();
            }
            result.add(center);
        }
        return result;
    }
}

