/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@CheckerInfo(name="Coordination System Error Checker", localMenuName="Coordination System Error", description="Detects various coordination system drawing problems", noErrorMessage="No invalid coordination system found", oneErrorMessage="invalid coordination system found", moreErrorMessage="invalid coordination systems found", severity=CheckerSeverity.ERROR, actionStringToken="coordsystem")
public class CoordinationSystemErrorChecker
extends AbstractStructureChecker {
    public CoordinationSystemErrorChecker() {
        super(StructureCheckerErrorType.INVALID_COORD_SYSTEM);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        for (int i = 0; i < molecule.getSgroupCount(); ++i) {
            ArrayList<MolBond> bonds = new ArrayList<MolBond>();
            if (molecule.getSgroup(i) instanceof MulticenterSgroup) {
                MolBond bond;
                int j;
                MulticenterSgroup group = (MulticenterSgroup)molecule.getSgroup(i);
                MolAtom multicenter = group.getCentralAtom();
                List<MolAtom> groupAtoms = Arrays.asList(group.getAtomArray());
                for (j = 0; j < group.getAtomCount(); ++j) {
                    bond = multicenter.getBondTo(group.getAtom(j));
                    if (bond == null) continue;
                    bonds.add(bond);
                }
                for (j = 0; j < multicenter.getBondCount(); ++j) {
                    bond = multicenter.getBond(j);
                    if (bond.getType() != 9) continue;
                    MolAtom atom = bond.getOtherAtom(multicenter);
                    if (atom.getAtno() == 137) {
                        bonds.add(bond);
                        continue;
                    }
                    if (groupAtoms.contains(atom)) continue;
                    for (MolAtom molAtom : groupAtoms) {
                        MolBond bondToGroop = atom.getBondTo(molAtom);
                        if (bondToGroop == null || bondToGroop.getType() == 9) continue;
                        bonds.add(bondToGroop);
                    }
                }
            }
            if (bonds.isEmpty()) continue;
            return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }
}

