/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

@CheckerInfo(name="Covalent Counterion Checker", localMenuName="Covalent Counterion", description="Detects counterions connected by covalent bonds", noErrorMessage="No covalent counterion found", oneErrorMessage="covalent counterion found", moreErrorMessage="covalent counterions found", actionStringToken="covalentcounterion")
public class CovalentCounterionChecker
extends AbstractStructureChecker {
    public CovalentCounterionChecker() {
        super(StructureCheckerErrorType.COVALENT_COUNTER_ION);
    }

    @Override
    protected StructureCheckerResult check1(Molecule mol) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        int errorCount = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 7 && atom.getAtno() != 8 && atom.getAtno() != 16) continue;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                MolBond bond = atom.getBond(j);
                MolAtom otherAtom = bond.getOtherAtom(atom);
                if (!PeriodicSystem.isAlkaliMetal(otherAtom.getAtno()) && !PeriodicSystem.isAlkalineEarthMetal(otherAtom.getAtno())) continue;
                atoms.add(atom);
                if (!atoms.contains(otherAtom)) {
                    atoms.add(otherAtom);
                    ++errorCount;
                }
                bonds.add(bond);
            }
        }
        return bonds.isEmpty() ? null : new DefaultStructureCheckerResult(this, atoms, bonds, this.getErrorType(), mol, this.getErrorDescription(errorCount), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

