/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.BondChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Crossed Double-Bond Checker", localMenuName="Crossed Double Bond", description="Detects unspecified stereo double bonds represented by crossed double bond symbol", noErrorMessage="No crossed double-bond found", oneErrorMessage="crossed double bond found", moreErrorMessage="crossed double bonds found", actionStringToken="crosseddoublebond")
public class CrossedDoubleBondChecker
extends BondChecker {
    public CrossedDoubleBondChecker() {
        super(StructureCheckerErrorType.CROSSED_DOUBLE_BOND);
    }

    @Override
    protected boolean check(Molecule molecule, MolBond bond) {
        int stereo = bond.getFlags() & 0x1C0;
        return stereo == 192;
    }
}

