/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@Deprecated
@CheckerInfo(name="Double Bond Stereo Error Checker", localMenuName="Double Bond Stereo Error", description="Detects strained small rings containing trans or cumulated double bonds, or triple bonds", noErrorMessage="No invalid stereo double bond found", oneErrorMessage="invalid stereo double bond found", moreErrorMessage="invalid stereo double bonds found", severity=CheckerSeverity.ERROR, actionStringToken="doublebondstereo")
public class DoubleBondStereoErrorChecker
extends AbstractStructureChecker {
    public DoubleBondStereoErrorChecker() {
        super(StructureCheckerErrorType.INVALID_STEREO);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        int[][] sssr;
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int[] js : sssr = molecule.getSSSR()) {
            if (js.length >= 8) continue;
            for (int j = 0; j < js.length - 1; ++j) {
                MolAtom atomA = molecule.getAtom(js[j]);
                MolAtom atomB = molecule.getAtom(js[j + 1]);
                MolBond bond = atomA.getBondTo(atomB);
                MolAtom atom1 = j == 0 ? molecule.getAtom(js[js.length - 1]) : molecule.getAtom(js[j - 1]);
                MolAtom atom4 = molecule.getAtom(js[(j + 2) % js.length]);
                if (bond.getType() != 2 || bond.calcStereo2(atom1, atom4) != 64 || bonds.contains(bond)) continue;
                bonds.add(bond);
            }
        }
        if (bonds.isEmpty()) {
            return null;
        }
        return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), bonds, this.errorType, molecule, this.getErrorDescription(bonds.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

