/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@CheckerInfo(name="Empty Structure Checker", localMenuName="Empty Structure", description="Detects structures not containing any atoms", noErrorMessage="No empty structure found", oneErrorMessage="empty structure found", moreErrorMessage="empty structures found", actionStringToken="empty")
public class EmptyStructureChecker
extends AbstractStructureChecker {
    public EmptyStructureChecker() {
        super(StructureCheckerErrorType.EMPTY);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        return molecule.getAtomCount() == 0 ? new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), new ArrayList<MolBond>(), this.getErrorType(), molecule, this.getDescription(), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon()) : null;
    }
}

