/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Explicit Lone Pair Checker", localMenuName="Explicit Lone Pair", description="Detects explicit lone pairs", noErrorMessage="No explicit lone pair found", oneErrorMessage="explicit lone pair found", moreErrorMessage="explicit lone pairs found", actionStringToken="explicitlp")
public class ExplicitLonePairChecker
extends AtomChecker {
    public ExplicitLonePairChecker() {
        super(StructureCheckerErrorType.EXPLICIT_LONE_PAIR);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        return component.getAtno() == 130;
    }
}

