/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.MetalloceneCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@CheckerInfo(name="Metallocene Error Checker", localMenuName="Metallocene", description="Detects Metallocene", noErrorMessage="No metallocene found", oneErrorMessage="metallocene found", moreErrorMessage="metallocenes found", severity=CheckerSeverity.ERROR, actionStringToken="metallocene")
public class MetalloceneErrorChecker
extends AbstractStructureChecker {
    private static List<Integer> metallicAtomNumbers = new ArrayList<Integer>(11);

    public MetalloceneErrorChecker() {
        super(StructureCheckerErrorType.METALLOCENE);
    }

    @Override
    protected StructureCheckerResult check1(Molecule mol) {
        int ringErrorCount = 0;
        ArrayList<MolAtom> metalAtoms = new ArrayList<MolAtom>();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (!MetalloceneErrorChecker.isMetal(atom)) continue;
            metalAtoms.add(atom);
        }
        if (metalAtoms.isEmpty()) {
            return null;
        }
        ArrayList<List<MolAtom>> fiveLongRings = new ArrayList<List<MolAtom>>();
        ArrayList<Integer> fiveLongRingIndices = new ArrayList<Integer>();
        ArrayList<MolAtom> ringAtoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> mergedThreeRingBonds = new ArrayList<MolBond>();
        int[][] sssr = mol.getSSSR();
        for (int i = 0; i < sssr.length; ++i) {
            int[] currentRingIndices = sssr[i];
            if (currentRingIndices.length == 5) {
                if (!MetalloceneErrorChecker.containsOnlyCarbon(currentRingIndices, mol) || !StructureCheckerHelper.isAromatic(currentRingIndices, mol) && !MetalloceneErrorChecker.isCyclopentadien(currentRingIndices, mol) && !MetalloceneErrorChecker.isAnyBondSystem(currentRingIndices, mol)) continue;
                fiveLongRingIndices.add(i);
                ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
                for (int j = 0; j < currentRingIndices.length; ++j) {
                    MolAtom atom = mol.getAtom(currentRingIndices[j]);
                    ringAtoms.add(atom);
                    atoms.add(atom);
                }
                fiveLongRings.add(atoms);
                continue;
            }
            if (currentRingIndices.length != 3) continue;
            for (int j = 0; j < currentRingIndices.length; ++j) {
                MolBond bond = mol.getAtom(currentRingIndices[j]).getBondTo(mol.getAtom(currentRingIndices[(j + 1) % currentRingIndices.length]));
                if (mergedThreeRingBonds.contains(bond)) {
                    mergedThreeRingBonds.remove(bond);
                    continue;
                }
                mergedThreeRingBonds.add(bond);
            }
        }
        ArrayList<MolAtom> mergedFiveLongRingAtoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> mergedFiveLongRingBonds = new ArrayList<MolBond>();
        int mergedFiveLongRingCount = 0;
        while (!mergedThreeRingBonds.isEmpty()) {
            MolBond bond = (MolBond)mergedThreeRingBonds.remove(0);
            ArrayList<MolBond> bondList = new ArrayList<MolBond>();
            bondList.add(bond);
            MolAtom startAtom = bond.getAtom1();
            MolAtom otherAtom = bond.getOtherAtom(startAtom);
            boolean ringFound = false;
            boolean hasNeighbour = true;
            while (!mergedThreeRingBonds.isEmpty() && !ringFound && hasNeighbour) {
                bond = MetalloceneErrorChecker.removeBondWithAtom(mergedThreeRingBonds, otherAtom);
                hasNeighbour = bond != null;
                if (!hasNeighbour || metalAtoms.contains(bond.getAtom1()) && bond.getAtom1().getBondCount() >= 4 || metalAtoms.contains(bond.getAtom2()) && bond.getAtom2().getBondCount() >= 4) continue;
                bondList.add(bond);
                otherAtom = bond.getOtherAtom(otherAtom);
                ringFound = startAtom.equals(otherAtom);
            }
            if (!ringFound || bondList.size() != 5) continue;
            ++mergedFiveLongRingCount;
            ArrayList<MolAtom> fiveLongRing = new ArrayList<MolAtom>();
            for (MolBond molBond : bondList) {
                if (!mergedFiveLongRingBonds.contains(molBond)) {
                    mergedFiveLongRingBonds.add(molBond);
                }
                if (!mergedFiveLongRingAtoms.contains(molBond.getAtom1())) {
                    mergedFiveLongRingAtoms.add(molBond.getAtom1());
                }
                if (!mergedFiveLongRingAtoms.contains(molBond.getAtom2())) {
                    mergedFiveLongRingAtoms.add(molBond.getAtom2());
                }
                if (!ringAtoms.contains(molBond.getAtom1())) {
                    ringAtoms.add(molBond.getAtom1());
                }
                if (!ringAtoms.contains(molBond.getAtom2())) {
                    ringAtoms.add(molBond.getAtom2());
                }
                if (!fiveLongRing.contains(molBond.getAtom1())) {
                    fiveLongRing.add(molBond.getAtom1());
                }
                if (fiveLongRing.contains(molBond.getAtom2())) continue;
                fiveLongRing.add(molBond.getAtom2());
            }
            fiveLongRings.add(fiveLongRing);
        }
        HashSet<MolAtom> removableMetallicAtoms = new HashSet<MolAtom>();
        for (MolAtom metalAtom : metalAtoms) {
            boolean hasMulticenterConnection = false;
            boolean hasNonRingConnection = false;
            boolean hasRingConnection = false;
            for (int i = 0; i < metalAtom.getBondCount(); ++i) {
                MolAtom otherAtom = metalAtom.getBond(i).getOtherAtom(metalAtom);
                if (!ringAtoms.contains(otherAtom) && otherAtom.getAtno() == 137) {
                    hasMulticenterConnection = true;
                    continue;
                }
                if (!ringAtoms.contains(otherAtom)) {
                    hasNonRingConnection = true;
                    continue;
                }
                hasRingConnection = true;
            }
            if (hasMulticenterConnection && !hasRingConnection || hasNonRingConnection && hasRingConnection) {
                removableMetallicAtoms.add(metalAtom);
                continue;
            }
            if (!ringAtoms.contains(metalAtom)) continue;
            removableMetallicAtoms.add(metalAtom);
        }
        metalAtoms.removeAll(removableMetallicAtoms);
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (MolAtom atom : metalAtoms) {
            if (!atoms.contains(atom)) {
                atoms.add(atom);
            }
            for (Integer idx : fiveLongRingIndices) {
                MetalloceneErrorChecker.addAtoms(mol, sssr, atoms, idx);
                MetalloceneErrorChecker.addBonds(mol, sssr, bonds, atom, idx);
            }
            for (MolAtom mergedAtom : mergedFiveLongRingAtoms) {
                MolBond bondTo = mergedAtom.getBondTo(atom);
                if (bondTo == null) continue;
                bonds.add(bondTo);
            }
        }
        if (!metalAtoms.isEmpty()) {
            atoms.addAll(mergedFiveLongRingAtoms);
            ringErrorCount = mergedFiveLongRingCount + fiveLongRingIndices.size();
        }
        StructureCheckerErrorType errorType = MetalloceneErrorChecker.calcErrorType(ringErrorCount);
        if (ringErrorCount < 2) {
            return null;
        }
        return new MetalloceneCheckerResult(this, atoms, bonds, errorType, mol, this.getErrorDescription(ringErrorCount / 2), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon(), fiveLongRings, metalAtoms);
    }

    private static boolean isMetal(MolAtom atom) {
        return metallicAtomNumbers.contains(atom.getAtno());
    }

    private static MolBond removeBondWithAtom(List<MolBond> bonds, MolAtom otherAtom) {
        for (int i = 0; i < bonds.size(); ++i) {
            MolBond bond = bonds.get(i);
            if (bond.getAtom1() != otherAtom && bond.getAtom2() != otherAtom) continue;
            bonds.remove(bond);
            return bond;
        }
        return null;
    }

    private static boolean containsOnlyCarbon(int[] currentRingIndices, Molecule mol) {
        for (int i = 0; i < currentRingIndices.length; ++i) {
            if (mol.getAtom(currentRingIndices[i]).getAtno() == 6) continue;
            return false;
        }
        return true;
    }

    private static boolean isCyclopentadien(int[] currentRingIndices, Molecule mol) {
        int doubleBondCount = 0;
        boolean containsOnlyCarbon = true;
        boolean twoNeighbourDoubleBond = false;
        boolean lastWasDouble = false;
        for (int i = 0; i < currentRingIndices.length - 1; ++i) {
            MolAtom atom = mol.getAtom(currentRingIndices[i]);
            boolean bl = containsOnlyCarbon = atom.getAtno() == 6;
            if (atom.getBondTo(mol.getAtom(currentRingIndices[i + 1])).getType() == 2) {
                ++doubleBondCount;
                if (lastWasDouble) {
                    twoNeighbourDoubleBond = true;
                }
                lastWasDouble = true;
                continue;
            }
            lastWasDouble = false;
        }
        return containsOnlyCarbon && doubleBondCount == 2 && !twoNeighbourDoubleBond;
    }

    private static boolean isAnyBondSystem(int[] currentRingIndices, Molecule mol) {
        for (int i = 0; i < currentRingIndices.length - 1; ++i) {
            MolAtom atom = mol.getAtom(currentRingIndices[i]);
            if (atom.getBondTo(mol.getAtom(currentRingIndices[i + 1])).getType() == 0) continue;
            return false;
        }
        return true;
    }

    private static StructureCheckerErrorType calcErrorType(int ringErrorCount) {
        if (ringErrorCount == 2) {
            return StructureCheckerErrorType.METALLOCENE;
        }
        return StructureCheckerErrorType.METALLOCENE_AMBIGUOUS;
    }

    private static void addBonds(Molecule mol, int[][] sssr, List<MolBond> bonds, MolAtom atom, Integer idx) {
        int[] indices = sssr[idx];
        for (int i = 0; i < indices.length; ++i) {
            MolBond bond = mol.getAtom(indices[i]).getBondTo(atom);
            if (bond == null) continue;
            bonds.add(bond);
        }
    }

    private static void addAtoms(Molecule mol, int[][] sssr, List<MolAtom> atoms, Integer idx) {
        for (int i = 0; i < sssr[idx].length; ++i) {
            atoms.add(mol.getAtom(sssr[idx][i]));
        }
    }

    static {
        metallicAtomNumbers.add(22);
        metallicAtomNumbers.add(23);
        metallicAtomNumbers.add(24);
        metallicAtomNumbers.add(26);
        metallicAtomNumbers.add(27);
        metallicAtomNumbers.add(28);
        metallicAtomNumbers.add(30);
        metallicAtomNumbers.add(40);
        metallicAtomNumbers.add(42);
        metallicAtomNumbers.add(44);
        metallicAtomNumbers.add(74);
    }
}

