/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Missing Atom Map Checker", localMenuName="Missing Atom Map", description="Detects atoms without atom maps", noErrorMessage="No missing atom map", oneErrorMessage="atom map is missing", moreErrorMessage="atoms maps are missing", actionStringToken="missingatommap")
public class MissingAtomMapChecker
extends AtomChecker {
    public MissingAtomMapChecker() {
        super(StructureCheckerErrorType.MISSING_ATOM_MAP);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        return atom.getAtomMap() == 0;
    }
}

