/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@CheckerInfo(name="Multicomponent Checker", localMenuName="Multicomponent", description="Detects disconnected fragments", noErrorMessage="No multicomponent found", oneErrorMessage="multicomponent found", moreErrorMessage="multicomponents found", actionStringToken="multicomponent")
public class MultiComponentChecker
extends AbstractStructureChecker {
    public MultiComponentChecker() {
        super(StructureCheckerErrorType.MULTI_COMPONENT);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        return molecule.getFragCount(1) <= 1 ? null : new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), new ArrayList<MolBond>(), this.errorType, molecule, this.getErrorDescription(molecule.getFragCount(1)), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
    }
}

