/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.BondAngleChecker;
import chemaxon.checkers.BondLengthChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.CheckerSeverity;
import chemaxon.checkers.OverlappingAtomsChecker;
import chemaxon.checkers.OverlappingBondsChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@CheckerInfo(name="OCR Error Checker", localMenuName="OCR Errors", description="Detects drawings that are probably not chemical structures, often resulted from incorrect optical scanning of documents", noErrorMessage="No OCR error found", oneErrorMessage="OCR error found", moreErrorMessage="OCR errors found", severity=CheckerSeverity.ERROR, actionStringToken="ocr")
public class OCRErrorChecker
extends AbstractStructureChecker {
    BondAngleChecker angleChecker = new BondAngleChecker(0.1);
    BondLengthChecker lengthChecker = new BondLengthChecker();
    OverlappingAtomsChecker overlappingAtomsChecker = new OverlappingAtomsChecker();
    OverlappingBondsChecker overlappingBondsChecker = new OverlappingBondsChecker();

    public OCRErrorChecker() {
        super(StructureCheckerErrorType.DOODLE);
        this.setName("OCR Error");
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getDim() == 0 || molecule.getDim() == 3) {
            return null;
        }
        if (OCRErrorChecker.compoundsLookLikeDoodle(molecule) && this.hasTooManyDrawingProblem(molecule)) {
            return new DefaultStructureCheckerResult(this, new ArrayList<MolAtom>(), new ArrayList<MolBond>(), this.getErrorType(), molecule, this.getDescription(), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }

    private boolean hasTooManyDrawingProblem(Molecule molecule) {
        return this.getProblemPercent(molecule, this.lengthChecker, molecule.getBondCount()) > 0.49 || this.getProblemPercent(molecule, this.angleChecker, molecule.getBondCount()) > 0.89 || this.getProblemPercent(molecule, this.overlappingBondsChecker, molecule.getBondCount()) > 0.49 || this.getProblemPercent(molecule, this.overlappingAtomsChecker, molecule.getAtomCount()) > 0.49;
    }

    private double getProblemPercent(Molecule molecule, StructureChecker checker, int maxCount) {
        StructureCheckerResult result = checker.check(molecule);
        return result == null ? 0.0 : (double)result.getBonds().size() / (double)maxCount;
    }

    private static boolean compoundsLookLikeDoodle(Molecule molecule) {
        int explicitHydrogenCount = 0;
        int carbonCount = 0;
        int oxygenCount = 0;
        int iodCount = 0;
        int heteroAtomCount = 0;
        int notAnElementCount = 0;
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            int atno = molecule.getAtom(i).getAtno();
            if (atno == 1) {
                ++explicitHydrogenCount;
                continue;
            }
            if (atno == 6) {
                ++carbonCount;
                continue;
            }
            if (atno == 8) {
                ++oxygenCount;
                continue;
            }
            if (atno == 53) {
                ++iodCount;
                continue;
            }
            if (atno < 128) {
                ++heteroAtomCount;
                continue;
            }
            ++notAnElementCount;
        }
        int atomCount = molecule.getAtomCount() - notAnElementCount;
        return oxygenCount < 4 && iodCount < 4 && (heteroAtomCount == 0 || heteroAtomCount == 1 && atomCount <= 10 || (double)heteroAtomCount / (double)atomCount < 0.015) && (((double)explicitHydrogenCount + (double)carbonCount) / (double)atomCount > 0.9 || atomCount < 15);
    }
}

