/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Overlapping Atoms Checker", localMenuName="Overlapping Atoms", description="Detects atoms that are too close to each other", noErrorMessage="No overlapping atom found", oneErrorMessage="overlapping atom found", moreErrorMessage="overlapping atoms found", actionStringToken="overlappingatoms")
public class OverlappingAtomsChecker
extends AtomChecker {
    public OverlappingAtomsChecker() {
        super(StructureCheckerErrorType.OVERLAPPING_ATOMS);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (molecule.getDim() == 0 || molecule.getDim() == 3) {
            return null;
        }
        return super.check1(molecule);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom atom) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom molAtom = molecule.getAtom(i);
            if (atom.equals(molAtom) || !(StructureCheckerHelper.distance(atom, molAtom) < 0.77)) continue;
            return true;
        }
        return false;
    }
}

