/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.calculations.stereo.Stereochemistry;
import chemaxon.checkers.AtomChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Racemate Checker", localMenuName="Racemate", description="Detects asymmetric tetrahedral atoms with no specific stereo configuration", noErrorMessage="No racemate found", oneErrorMessage="racemate found", moreErrorMessage="racemic stereo centers found", actionStringToken="racemate")
public class RacemateChecker
extends AtomChecker {
    private final Stereochemistry stereo = new Stereochemistry();

    public RacemateChecker() {
        super(StructureCheckerErrorType.RACEMATE);
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        this.stereo.setMolecule(molecule);
        return super.check1(molecule);
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        int ch;
        int a = molecule.indexOf(component);
        return this.stereo.isAsymmetricAtom(a) && (ch = molecule.getChirality(a)) != 8 && ch != 16;
    }
}

