/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AtomTypeChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

@CheckerInfo(name="Rare Element Checker", localMenuName="Rare Element", description="Detects elements that are uncommon in organic compounds", noErrorMessage="No rare element found", oneErrorMessage="rare element found", moreErrorMessage="rare elements found", actionStringToken="rare")
public class RareElementChecker
extends AtomTypeChecker {
    public RareElementChecker() {
        super(StructureCheckerErrorType.RARE_ELEMENT);
        this.types.add("H");
        this.types.add("Li");
        this.types.add("Na");
        this.types.add("K");
        this.types.add("Mg");
        this.types.add("Ca");
        this.types.add("B");
        this.types.add("C");
        this.types.add("N");
        this.types.add("O");
        this.types.add("F");
        this.types.add("Cl");
        this.types.add("Br");
        this.types.add("I");
        this.types.add("Al");
        this.types.add("P");
        this.types.add("S");
        this.types.add("Cr");
        this.types.add("Mn");
        this.types.add("Fe");
        this.types.add("Co");
        this.types.add("Ni");
        this.types.add("Cu");
        this.types.add("Zn");
    }

    @Override
    protected boolean check(Molecule molecule, MolAtom component) {
        return component.getAtno() < 128 && !super.check(molecule, component);
    }
}

