/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.CheckerInfo;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Map;

@CheckerInfo(name="R-atom Checker", localMenuName="R-atom", description="Detects molecules containing R-atoms", noErrorMessage="No R-atom found", oneErrorMessage="R-atom found", moreErrorMessage="R-atoms found", actionStringToken="ratom", editorClassName="chemaxon.marvin.sketch.swing.modules.checker.editors.RatomCheckerEditor")
public class RatomChecker
extends AbstractStructureChecker {
    private static final String PROPERTY_KEY_GENERIC = "generic";
    private static final String PROPERTY_KEY_NESTED = "nested";
    private static final String PROPERTY_KEY_LINKER = "linker";
    private static final String PROPERTY_KEY_DISCONNECTED = "disconnected";
    private static final String PROPERTY_KEY_ALL = "all";
    public static final String PROPERTY_KEY_SEARCH_ALL = "searchAll";
    public static final String PROPERTY_KEY_SEARCH_DISCONNECTED = "searchDisconnected";
    public static final String PROPERTY_KEY_SEARCH_GENERIC = "searchGeneric";
    public static final String PROPERTY_KEY_SEARCH_LINKER = "searchLinker";
    public static final String PROPERTY_KEY_SEARCH_NESTED = "searchNested";
    @Persistent(alias="all")
    private boolean searchAll = true;
    @Persistent(alias="disconnected")
    private boolean searchDisconnected = true;
    @Persistent(alias="generic")
    private boolean searchGeneric = true;
    @Persistent(alias="linker")
    private boolean searchLinker = true;
    @Persistent(alias="nested")
    private boolean searchNested = true;

    public RatomChecker() {
        super(StructureCheckerErrorType.RATOM);
    }

    public RatomChecker(Map<String, String> params) {
        super(StructureCheckerErrorType.RATOM);
        this.searchAll = Boolean.parseBoolean(params.get(PROPERTY_KEY_ALL));
        this.searchDisconnected = Boolean.parseBoolean(params.get(PROPERTY_KEY_DISCONNECTED));
        this.searchLinker = Boolean.parseBoolean(params.get(PROPERTY_KEY_LINKER));
        this.searchNested = Boolean.parseBoolean(params.get(PROPERTY_KEY_NESTED));
        this.searchGeneric = Boolean.parseBoolean(params.get(PROPERTY_KEY_GENERIC));
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        if (!(this.searchAll || this.searchDisconnected || this.searchLinker || this.searchNested || this.searchGeneric)) {
            return null;
        }
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atom.getAtno() != 134 || !(this.searchAll || this.searchDisconnected && atom.getBondCount() == 0 || this.searchLinker && atom.getBondCount() > 1) && (!this.searchGeneric || atom.getRgroup() != 0)) continue;
            atoms.add(atom);
        }
        if (molecule instanceof RgMolecule) {
            RgMolecule rmol = (RgMolecule)molecule;
            for (int i = 0; i < rmol.getRgroupCount(); ++i) {
                for (int j = 0; j < rmol.getRgroupMemberCount(i); ++j) {
                    Molecule rmember = rmol.getRgroupMember(i, j);
                    for (int k = 0; k < rmember.getAtomCount(); ++k) {
                        MolAtom atom = rmember.getAtom(k);
                        if (atom.getAtno() != 134 || !(this.searchAll || this.searchNested || this.searchDisconnected && atom.getBondCount() == 0 || this.searchLinker && atom.getBondCount() > 1) && (!this.searchGeneric || atom.getRgroup() != 0)) continue;
                        atoms.add(atom);
                    }
                }
            }
        }
        if (!atoms.isEmpty()) {
            return new DefaultStructureCheckerResult(this, atoms, new ArrayList<MolBond>(), StructureCheckerErrorType.RATOM, molecule, this.getErrorDescription(atoms.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }

    public boolean isSearchAll() {
        return this.searchAll;
    }

    public boolean isSearchDisconnected() {
        return this.searchDisconnected;
    }

    public boolean isSearchGeneric() {
        return this.searchGeneric;
    }

    public boolean isSearchLinker() {
        return this.searchLinker;
    }

    public boolean isSearchNested() {
        return this.searchNested;
    }

    public void setSearchAll(boolean value) {
        boolean oldValue = this.searchAll;
        this.searchAll = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_ALL, oldValue, value);
    }

    public void setSearchDisconnected(boolean value) {
        boolean oldValue = this.searchDisconnected;
        this.searchDisconnected = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_DISCONNECTED, oldValue, value);
    }

    public void setSearchGeneric(boolean value) {
        boolean oldValue = this.searchGeneric;
        this.searchGeneric = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_GENERIC, oldValue, value);
    }

    public void setSearchLinker(boolean value) {
        boolean oldValue = this.searchLinker;
        this.searchLinker = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_LINKER, oldValue, value);
    }

    public void setSearchNested(boolean value) {
        boolean oldValue = this.searchNested;
        this.searchNested = value;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_KEY_SEARCH_NESTED, oldValue, value);
    }
}

