/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers;

import chemaxon.checkers.AbstractStructureChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class ReactionChecker
extends AbstractStructureChecker {
    private final StructureChecker checker;

    public ReactionChecker(StructureCheckerErrorType errorType, StructureChecker checker) {
        super(errorType);
        this.checker = checker;
    }

    @Override
    protected StructureCheckerResult check1(Molecule molecule) {
        RxnMolecule reaction = RxnMolecule.getReaction(molecule);
        if (reaction != null) {
            int i;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (i = 0; i < reaction.getReactantCount(); ++i) {
                ids.add(reaction.getComponentID(reaction.getReactant(i)));
            }
            for (i = 0; i < reaction.getProductCount(); ++i) {
                ids.add(reaction.getComponentID(reaction.getProduct(i)));
            }
            ArrayList<StructureCheckerResult> resultList = new ArrayList<StructureCheckerResult>();
            for (Long id : ids) {
                Molecule component = reaction.getComponent(id);
                StructureCheckerResult result = this.checker.check(component);
                if (result == null || this.isCorrect(result)) continue;
                resultList.add(result);
            }
            return this.createResult(molecule, resultList);
        }
        return null;
    }

    protected abstract boolean isCorrect(StructureCheckerResult var1);

    protected StructureCheckerResult createResult(Molecule molecule, List<StructureCheckerResult> resultList) {
        if (!resultList.isEmpty()) {
            LinkedHashSet<MolAtom> atomSet = new LinkedHashSet<MolAtom>();
            LinkedHashSet<MolBond> bondSet = new LinkedHashSet<MolBond>();
            for (StructureCheckerResult result : resultList) {
                atomSet.addAll(result.getAtoms());
                bondSet.addAll(result.getBonds());
            }
            ArrayList<MolAtom> atoms = new ArrayList<MolAtom>(atomSet);
            ArrayList<MolBond> bonds = new ArrayList<MolBond>(bondSet);
            return new DefaultStructureCheckerResult(this, atoms, bonds, this.errorType, molecule, this.getErrorDescription(resultList.size()), this.getName(), this.getLocalMenuName(), this.getHelpText(), this.getIcon());
        }
        return null;
    }
}

